/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.honor;

import android.graphics.Bitmap;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.user.R;
import com.yy.socialplatformbase.data.ShareData;
import java.io.File;

public class HonorShareHelper {
    private static String IKXD_PRODUCT_HOST = "https://www.ihago.net/a/hagores-sharepage/index.html?titleId=%d&uid=%d&langCode=%s&h=%d";
    private static String IKXD_IND_TEST_HOST = "https://test.ihago.net/a/hagores-sharepage/index.html?titleId=%d&uid=%d&langCode=%s&h=%d";
    private IIntlShareService mShareService;

    public HonorShareHelper(IIntlShareService shareService) {
        this.mShareService = shareService;
    }

    public void shareFacebook(long hornorId) {
        final String shareLink = this.genShareLink(hornorId, AccountUtil.getUid());
        final ShareData.Builder builder = ShareData.builder();
        builder.to(2);
        builder.type(2);
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shortUrl});
                builder.text(text);
                builder.gotoUrl(shortUrl);
                HonorShareHelper.this.mShareService.share(5, builder.build());
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shareLink});
                builder.text(text);
                builder.gotoUrl(shareLink);
                HonorShareHelper.this.mShareService.share(5, builder.build());
            }
        });
    }

    public void shareLine(long hornorId, final View shareView) {
        final String shareLink = this.genShareLink(hornorId, AccountUtil.getUid());
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shortUrl});
                HonorShareHelper.this.genShareImageAndShare(shareView, 1, text, null);
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shareLink});
                HonorShareHelper.this.genShareImageAndShare(shareView, 1, text, null);
            }
        });
    }

    public void shareWhatsapp(long hornorId, final View shareView) {
        final String shareLink = this.genShareLink(hornorId, AccountUtil.getUid());
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shortUrl});
                HonorShareHelper.this.genShareImageAndShare(shareView, 2, text, null);
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shareLink});
                HonorShareHelper.this.genShareImageAndShare(shareView, 2, text, null);
            }
        });
    }

    public void shareInstagram(long hornorId, View shareView) {
        this.genShareImageAndShare(shareView, 3, null, null);
    }

    public void shareMessenger(long hornorId) {
        final ShareData.Builder builder = ShareData.builder();
        builder.to(1);
        builder.type(2);
        builder.title(ResourceUtils.getString((int)R.string.share_default_title));
        final String shareLink = this.genShareLink(hornorId, AccountUtil.getUid());
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shortUrl});
                builder.text(text);
                builder.gotoUrl(shortUrl);
                HonorShareHelper.this.mShareService.share(6, builder.build());
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shareLink});
                builder.text(text);
                builder.gotoUrl(shareLink);
                HonorShareHelper.this.mShareService.share(6, builder.build());
            }
        });
    }

    public void shareVK(long hornorId) {
        final String shareLink = this.genShareLink(hornorId, AccountUtil.getUid());
        final ShareData.Builder builder = ShareData.builder();
        builder.to(2);
        builder.type(2);
        ShortUrlUtil.getShortUrl((String)shareLink, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shortUrl});
                builder.text(text);
                builder.gotoUrl(shortUrl);
                HonorShareHelper.this.mShareService.share(9, builder.build());
            }

            public void onError(String input, int code, String msg) {
                String text = ResourceUtils.getString((int)R.string.honor_get_share_msg, (Object[])new Object[]{shareLink});
                builder.text(text);
                builder.gotoUrl(shareLink);
                HonorShareHelper.this.mShareService.share(9, builder.build());
            }
        });
    }

    public void genShareImageAndShare(final View shareView, final int channelId, final String text, final HelperListener listener) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)shareView);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HonorShareHelper.this.invokeListener(listener, false);
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String imageName = "viewimage.png";
                FileUtils.delete((String)(imagePath + File.separator + imageName));
                final String imageFull = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.PNG);
                if (!FP.empty((CharSequence)imageFull)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ShareData shareData = ShareData.builder().type(1).imgPath(imageFull).text(text).systemShare(true).build();
                            HonorShareHelper.this.mShareService.share(channelId, shareData);
                            HonorShareHelper.this.invokeListener(listener, true);
                        }
                    });
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HonorShareHelper.this.invokeListener(listener, false);
                        }
                    });
                }
            }
        });
    }

    private String genShareLink(long tilteId, long uid) {
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        String shareUrl = null;
        shareUrl = type == EnvSettingType.Dev || type == EnvSettingType.Product ? StringUtils.formatWitUSLocal((String)IKXD_PRODUCT_HOST, (Object[])new Object[]{tilteId, uid, SystemUtils.getLangAndCountry(), UriProvider.getIdc()}) : (type == EnvSettingType.Test ? StringUtils.formatWitUSLocal((String)IKXD_IND_TEST_HOST, (Object[])new Object[]{tilteId, uid, SystemUtils.getLangAndCountry(), UriProvider.getIdc()}) : StringUtils.formatWitUSLocal((String)IKXD_PRODUCT_HOST, (Object[])new Object[]{tilteId, uid, SystemUtils.getLangAndCountry(), UriProvider.getIdc()}));
        return shareUrl;
    }

    public void genImageAndSaveToAlbum(final View saveView, final HelperListener listener) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)saveView);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HonorShareHelper.this.invokeListener(listener, false);
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String imageName = "honor_get_" + System.currentTimeMillis() + ".png";
                final String saveResult = ViewImage.saveImgToAlbum((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (boolean)true);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!FP.empty((CharSequence)saveResult)) {
                            HonorShareHelper.this.invokeListener(listener, true);
                        } else {
                            HonorShareHelper.this.invokeListener(listener, false);
                        }
                    }
                });
            }
        });
    }

    private void invokeListener(HelperListener listener, boolean success) {
        if (listener == null) {
            return;
        }
        if (success) {
            listener.onSuccess();
        } else {
            listener.onFailed();
        }
    }

    public static interface HelperListener {
        public void onSuccess();

        public void onFailed();
    }
}

