/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user;

import android.content.Context;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.AbsFirstOrderModuleLoader;
import com.yy.appbase.kvo.moduledata.UserInfoModuleData;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IControllerRegistryService;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.ILikeService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.user.base.ILabelService;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.base.freeze.IUserFreezeService;
import com.yy.hiyo.user.base.service.IProfileService;
import com.yy.hiyo.user.base.service.IUserLevelDataService;
import com.yy.hiyo.user.freeze.UserFreezeService;
import com.yy.hiyo.user.honor.HonorShowWindowController;
import com.yy.hiyo.user.honor.UserHonorService;
import com.yy.hiyo.user.interest.IInterestLabelService;
import com.yy.hiyo.user.interest.InterestLabelService;
import com.yy.hiyo.user.interest.ui.ChooseInterestLabelController;
import com.yy.hiyo.user.interest.ui.GamePreferSettingController;
import com.yy.hiyo.user.profile.NewProfileController;
import com.yy.hiyo.user.profile.ProfileChannelsController;
import com.yy.hiyo.user.profile.UserInfoModuleImpl;
import com.yy.hiyo.user.profile.bbs.BBsPostDbService;
import com.yy.hiyo.user.profile.bbs.IBBsPostDbService;
import com.yy.hiyo.user.profile.card.ProfileCardController;
import com.yy.hiyo.user.profile.channel.ProfileChannelListController;
import com.yy.hiyo.user.profile.edit.EditProfileController;
import com.yy.hiyo.user.profile.instagram.InstagramAuthController;
import com.yy.hiyo.user.profile.instagramphotos.InstagramPhotosWindowController;
import com.yy.hiyo.user.profile.label.LabelService;
import com.yy.hiyo.user.profile.label.ProfileLabelController;
import com.yy.hiyo.user.profile.leaderboard.LeaderboardWindowController;
import com.yy.hiyo.user.profile.like.LikeController;
import com.yy.hiyo.user.profile.medal.MedalGuideController;
import com.yy.hiyo.user.profile.sevice.ProfileService;
import com.yy.hiyo.user.profile.textedit.TextEditWindowController;
import com.yy.hiyo.user.profile.userlevel.LevelUpgradeNotifyService;
import com.yy.hiyo.user.profile.userlevel.UserLevelController;
import com.yy.hiyo.user.profile.userlevel.UserLevelDataService;

public class UserModuleLoader
extends AbsFirstOrderModuleLoader {
    private boolean mKvoModuleInited = false;

    public void afterEnvInit() {
        this.ensureKvoModule();
        ServiceManagerProxy.getServiceManager().setService(IInterestLabelService.class, (env, manager) -> new InterestLabelService());
    }

    public void afterStartup() {
        ServiceManagerProxy.getServiceManager().setService(IProfileService.class, (env, manager) -> new ProfileService());
    }

    public void afterStartupOneSecond() {
        this.registerNewProfileController();
        this.registerProfileCardController();
        this.registerLabelController();
        this.registerPostDbController();
        ServiceManagerProxy.getServiceManager().setService(IHonorService.class, (env, manager) -> new UserHonorService(env));
        ServiceManagerProxy.getServiceManager().setService(ILikeService.class, (env, manager) -> new LikeController(env));
        ServiceManagerProxy.getServiceManager().setService(ILabelService.class, (env, manager) -> new LabelService(env));
        this.registerMedalGuideController();
        this.registerUserLevelController();
        this.registerGamePreferSettingController();
        this.registerProfileChannelController();
    }

    private void registerPostDbController() {
        ServiceManagerProxy.getInstance().setService(IBBsPostDbService.class, (env, manager) -> new BBsPostDbService(env));
    }

    public void afterStartupThreeSecond() {
        this.registerHonorShowController();
        this.registerLevelUpgradeService();
        this.registerLevelDataService();
        ServiceManagerProxy.getServiceManager().setService(IUserFreezeService.class, (env, manager) -> new UserFreezeService());
    }

    public void afterStartupFiveSecond() {
        this.registerEditProfileController();
        this.registerProfileTextEditController();
        this.registerProfileChannelListController();
        if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ((IProfileService)ServiceManagerProxy.getService(IProfileService.class)).preload(AccountUtil.getUid());
        }
    }

    public void afterStartupTenSecond() {
        this.registerInsAuthController();
        this.registerProfileInstagramPhotosController();
        this.registerProfileLeaderboardController();
    }

    public void handleTimeEvent(int timeEvent) {
        super.handleTimeEvent(timeEvent);
        if (timeEvent == ENSURE_KVO_MODULE) {
            this.ensureKvoModule();
        }
    }

    private void ensureKvoModule() {
        if (this.mKvoModuleInited) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.ensureKvoModuleInner();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserModuleLoader.this.ensureKvoModuleInner();
                }
            });
        }
    }

    private void ensureKvoModuleInner() {
        if (this.mKvoModuleInited) {
            return;
        }
        this.mKvoModuleInited = true;
        KvoModuleManager.registerModule(UserInfoModule.class, () -> new UserInfoModuleImpl(new UserInfoModuleData()));
    }

    private void registerNewProfileController() {
        int[] messageIds = new int[]{UserMsgDef.OPEN_WINDOW_NEW_PROFILE, UserMsgDef.CLOSE_WINDOW_NEW_PROFILE, UserMsgDef.ALBUM_UPDATE_POST, BaseMsgDef.MSG_OPEN_PROFILE_NEW_WINDOW};
        int[] notificationIds = new int[]{NotificationDef.UPDATE_ALBUM, NotificationDef.N_LOGIN_ACCOUNT_CHANGED, NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, GameNotificationDef.GAME_MODLE_INIT, NotificationDef.OPEN_USER_NEW_PROFILE};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, notificationIds, NewProfileController.class, NewProfileController::new);
    }

    private void registerProfileChannelController() {
        int[] messageIds = new int[]{UserMsgDef.MSG_OPEN_PROFILE_CHANNELS};
        int[] notificationIds = new int[]{};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, notificationIds, ProfileChannelsController.class, ProfileChannelsController::new);
    }

    private void registerLabelController() {
        int[] messageIds = new int[]{UserMsgDef.OPEN_PROFILE_LABEL};
        int[] notificationIds = new int[]{NotificationDef.UPDATE_LABEL};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, notificationIds, ProfileLabelController.class, ProfileLabelController::new);
    }

    private void registerMedalGuideController() {
        int[] messageIds = new int[]{UserMsgDef.SHOW_MEDAL_GUIDE_DIALOG};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, MedalGuideController.class, MedalGuideController::new);
    }

    private void registerUserLevelController() {
        int[] messageIds = new int[]{BaseMsgDef.OPEN_WINDOW_USER_LEVEL};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, UserLevelController.class, UserLevelController::new);
    }

    private void registerProfileCardController() {
        int[] messageIds = new int[]{BaseMsgDef.MSG_SHOW_PROFILE_DIALOG};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, ProfileCardController.class, ProfileCardController::new);
    }

    private void registerEditProfileController() {
        int[] messageIds = new int[]{UserMsgDef.OPEN_WINDOW_EDIT_PROFILE, UserMsgDef.CLOSE_WINDOW_EDIT_PROFILE, BaseMsgDef.OPEN_WINDOW_EDIT_PROFILE_WHIE_OPEN_DIALOG, UserMsgDef.UPDATE_ALBUM_TO_BBS};
        int[] notificationIds = new int[]{NotificationDef.UPDATE_ALBUM};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, notificationIds, EditProfileController.class, EditProfileController::new);
    }

    private void registerInsAuthController() {
        int[] messageIds = new int[]{UserMsgDef.CONNECT_INS_AUTH, UserMsgDef.CLOSE_WINDOW_INS_AUTH, UserMsgDef.UPDATE_INS_PHOTOS, UserMsgDef.DISCONNECT_INS_AUTH};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, InstagramAuthController.class, InstagramAuthController::new);
    }

    private void registerProfileTextEditController() {
        int[] messageIds = new int[]{UserMsgDef.OPEN_WINDOW_HOMETOWN_EDIT, UserMsgDef.OPEN_WINDOW_NICKNAME_EDIT, UserMsgDef.OPEN_WINDOW_CAREER_EDIT, UserMsgDef.OPEN_WINDOW_BIO_EDIT, UserMsgDef.CLOSE_WINDOW_TEXT_EDIT, BaseMsgDef.CLOSE_WINDOW_TEXT_EDIT, AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_EDIT_GROUP_NAME, AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_EDIT_GROUP_NOTICE, AppbaseMsgDef.ChannelMsgDef.OPEN_CHANNEL_NICK_EDIT};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, TextEditWindowController.class, TextEditWindowController::new);
    }

    private void registerProfileLeaderboardController() {
        int[] messageIds = new int[]{UserMsgDef.OPEN_WINDOW_LEADERBOARD, UserMsgDef.CLOSE_WINDOW_LEADERBOARD, UserMsgDef.OPEN_WINDOW_NEW_LEADERBOARD, UserMsgDef.CLOSE_WINDOW_NEW_LEADERBOARD};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, LeaderboardWindowController.class, LeaderboardWindowController::new);
    }

    private void registerProfileInstagramPhotosController() {
        int[] messageIds = new int[]{UserMsgDef.OPEN_WINDOW_INSTAGRAM_PHOTOS, UserMsgDef.CLOSE_WINDOW_INSTAGRAM_PHOTOS};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, InstagramPhotosWindowController.class, InstagramPhotosWindowController::new);
    }

    private void registerProfileChannelListController() {
        int[] messageIds = new int[]{UserMsgDef.OPEN_WINDOW_PROFILE_CHANNEL_LIST, UserMsgDef.CLOSE_WINDOW_PROFILE_CHANNEL_LIST};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, ProfileChannelListController.class, ProfileChannelListController::new);
    }

    private void registerHonorShowController() {
        int[] messageIds = new int[]{BaseMsgDef.MSG_SHOW_HONOR_GET};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, HonorShowWindowController.class, HonorShowWindowController::new);
    }

    private void registerInterestLabelController() {
        int[] messageIds = new int[]{UserMsgDef.MSG_OPEN_CHAOOSE_INTEREST_LABEL_WINDOW, UserMsgDef.MSG_OPEN_CHOOSE_INTEREST_LABEL_DIALOG, UserMsgDef.MSG_SHOW_CHOOSE_INTEREST_LABEL_FLOAT};
        int[] notificationIds = new int[]{NotificationDef.N_LOGIN_SUCCESS, NotificationDef.N_SHOW_HOME_PAGE, NotificationDef.N_USER_REGISTER_TIME_UPDATE};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, notificationIds, ChooseInterestLabelController.class, ChooseInterestLabelController::new);
    }

    private void registerGamePreferSettingController() {
        int[] messageIds = new int[]{UserMsgDef.MSG_OPEN_GAME_PREFER_SETTING_WINDOW};
        ((IControllerRegistryService)ServiceManagerProxy.getService(IControllerRegistryService.class)).registerController(messageIds, null, GamePreferSettingController.class, GamePreferSettingController::new);
    }

    private void registerLevelUpgradeService() {
        ServiceManagerProxy.getServiceManager().setService(LevelUpgradeNotifyService.class, (env, manager) -> new LevelUpgradeNotifyService(env));
        ServiceManagerProxy.getService(LevelUpgradeNotifyService.class);
    }

    private void registerLevelDataService() {
        ServiceManagerProxy.getServiceManager().setService(IUserLevelDataService.class, (env, manager) -> new UserLevelDataService(env));
    }
}

