/*
 * Decompiled with CFR 0.152.
 */
package com.liaoinstan.springview.widget;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.OverScroller;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.liaoinstan.springview.widget.Flag;
import com.liaoinstan.springview.widget.SpringHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;

public class SpringView
extends ViewGroup {
    private static final String TAG = "SpringView";
    private Context context;
    private LayoutInflater inflater;
    private OverScroller mScroller;
    private Handler handler = new Handler();
    private Flag flag = new Flag();
    private OnFreshListener listener;
    private boolean needResetAnim = false;
    private boolean isMoveNow = false;
    private boolean enableHeader = true;
    private boolean isCallFresh = false;
    private float MOVE_PARA = 2.0f;
    private int MOVE_TIME;
    private int MAX_HEADER_PULL_HEIGHT = 600;
    private int HEADER_LIMIT_HEIGHT;
    private int HEADER_SPRING_HEIGHT;
    private float mLastY;
    private float mLastX;
    private float dsY;
    private boolean isInControl = false;
    private View header;
    private View contentLay;
    private View contentView;
    private int paddingTopContent;
    private int paddingBottomContent;
    private boolean isInflate = false;
    private int touchSlop = 0;
    private float dy;
    private float dx;
    private boolean isNeedMyMove;
    private int downAction;
    private boolean isContentDown;
    private int mActivePointerId = -1;
    private DragHander _headerHander;
    private DragHander headerHander;

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onFinishInflate();
    }

    public SpringView(Context context) {
        this(context, null);
    }

    public SpringView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpringView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.inflater = LayoutInflater.from((Context)context);
        this.mScroller = new OverScroller(context);
        this.MOVE_TIME = RuntimeContext.sPhoneType > 1 ? 500 : 300;
    }

    protected void onFinishInflate() {
        if (this.isInflate) {
            return;
        }
        this.isInflate = true;
        View content = this.getChildAt(0);
        if (content == null) {
            return;
        }
        this.setPadding(0, 0, 0, 0);
        if (SpringHelper.isViewCouldScroll(content)) {
            this.contentLay = content;
            this.contentView = content;
        } else {
            View viewCouldScroll = SpringHelper.findViewCouldScroll(content);
            this.contentView = viewCouldScroll != null ? viewCouldScroll : content;
            this.contentLay = content;
        }
        this.paddingTopContent = this.contentView.getPaddingTop();
        this.paddingBottomContent = this.contentView.getPaddingBottom();
        super.onFinishInflate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.forceLayout();
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            }
        }
        if (this.headerHander != null) {
            int h;
            int xh = this.headerHander.getDragMaxHeight(this.header);
            if (xh > 0) {
                this.MAX_HEADER_PULL_HEIGHT = xh;
            }
            this.HEADER_LIMIT_HEIGHT = (h = this.headerHander.getDragLimitHeight(this.header)) > 0 ? h : this.header.getMeasuredHeight();
            int sh = this.headerHander.getDragSpringHeight(this.header);
            this.HEADER_SPRING_HEIGHT = sh > 0 ? sh : this.HEADER_LIMIT_HEIGHT;
        } else {
            if (this.header != null) {
                this.HEADER_LIMIT_HEIGHT = this.header.getMeasuredHeight();
            }
            this.HEADER_SPRING_HEIGHT = this.HEADER_LIMIT_HEIGHT;
        }
        this.contentView.setPadding(this.contentView.getPaddingLeft(), this.paddingTopContent, this.contentView.getPaddingRight(), this.paddingBottomContent);
        ((ViewGroup)this.contentView).setClipToPadding(false);
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.contentLay != null) {
            if (this.header != null) {
                this.header.layout(0, -this.header.getMeasuredHeight(), this.getWidth(), 0);
            }
            this.contentLay.layout(0, 0, this.contentLay.getMeasuredWidth(), this.contentLay.getMeasuredHeight());
            if (this.header != null) {
                this.header.bringToFront();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.dealMulTouchEvent(event);
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.flag.hasCallFull = false;
                this.flag.hasCallRefresh = false;
                this.flag.hasCallEnding = false;
                float firstY = event.getY();
                this.isNeedMyMove = false;
                this.isContentDown = !this.isTop() || !(firstY < (float)(-this.getScrollY()));
                break;
            }
            case 2: {
                boolean isTop = this.isChildScrollToTop();
                this.dsY += this.dy;
                this.isMoveNow = true;
                this.isNeedMyMove = this.isNeedMyMove(event);
                if (!this.isNeedMyMove || this.isInControl || !this.isContentDown) break;
                this.isInControl = true;
                event.setAction(3);
                MotionEvent ev2 = MotionEvent.obtain((MotionEvent)event);
                this.dispatchTouchEvent(event);
                ev2.setAction(0);
                return this.dispatchTouchEvent(ev2);
            }
            case 1: 
            case 3: {
                this.isMoveNow = false;
                break;
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean isTop(View view) {
        LinearLayoutManager linearLayoutManager;
        int firstPos;
        RecyclerView rv;
        return view instanceof RecyclerView && (rv = (RecyclerView)view).getLayoutManager() instanceof LinearLayoutManager && (firstPos = (linearLayoutManager = (LinearLayoutManager)rv.getLayoutManager()).findFirstCompletelyVisibleItemPosition()) == 0;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        super.onInterceptTouchEvent(event);
        return this.isNeedMyMove;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.contentLay == null) {
            return false;
        }
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.performClick();
                break;
            }
            case 2: {
                if (this.isNeedMyMove) {
                    this.needResetAnim = false;
                    if (this.isTop()) {
                        this.showHeaderAndFooter(true);
                    }
                    this.doMove();
                    this.isInControl = true;
                    break;
                }
                if (this.dy == 0.0f || !this.isFlow()) break;
                this.resetPosition();
                event.setAction(0);
                this.dispatchTouchEvent(event);
                this.isInControl = false;
                break;
            }
            case 1: 
            case 3: {
                this.needResetAnim = true;
                this.flag.hasCallPreDrag = false;
                this.restSmartPosition();
                this.dsY = 0.0f;
                this.dy = 0.0f;
                break;
            }
        }
        return false;
    }

    public void dealMulTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        switch (action) {
            case 0: {
                this.downAction = action;
                int pointerIndex = ev.getActionIndex();
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                this.mLastX = x;
                this.mLastY = y;
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                this.dx = x - this.mLastX;
                this.dy = y - this.mLastY;
                this.mLastY = y;
                this.mLastX = x;
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                break;
            }
            case 5: {
                this.downAction = action;
                int pointerIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(pointerIndex);
                if (pointerId == this.mActivePointerId) break;
                this.mLastX = ev.getX(pointerIndex);
                this.mLastY = ev.getY(pointerIndex);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                break;
            }
            case 6: {
                int pointerIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.mLastX = ev.getX(newPointerIndex);
                this.mLastY = ev.getY(newPointerIndex);
                this.mActivePointerId = ev.getPointerId(newPointerIndex);
                break;
            }
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    private void doMove() {
        if (!this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
        }
        float movePara = this.dy > 0.0f && this.headerHander != null && this.headerHander.getMovePara() > 0.0f ? this.headerHander.getMovePara() : this.MOVE_PARA;
        int moveDy = this.dy > 0.0f ? (int)((float)(this.MAX_HEADER_PULL_HEIGHT + this.getScrollY()) / (float)this.MAX_HEADER_PULL_HEIGHT * this.dy / movePara) : (int)((float)(this.MAX_HEADER_PULL_HEIGHT - this.getScrollY()) / (float)this.MAX_HEADER_PULL_HEIGHT * this.dy / movePara);
        this.scrollBy(0, -moveDy);
        this.callOnScrollAndDrag();
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(0, this.mScroller.getCurrY());
            this.callOnScrollAndDrag();
            this.invalidate();
        }
        if (!this.isMoveNow && this.mScroller.isFinished()) {
            if (this.flag.scrollAnimType == 0) {
                if (!this.flag.hasCallFull) {
                    this.flag.hasCallFull = true;
                    this.callOnAfterFullAnim();
                }
            } else if (this.flag.scrollAnimType == 1) {
                if (!this.flag.hasCallRefresh) {
                    this.flag.hasCallRefresh = true;
                    this.callOnAfterRefreshAnim();
                }
            } else if (this.flag.scrollAnimType == 2 && !this.flag.hasCallEnding) {
                this.flag.hasCallEnding = true;
                this.resetPosition();
            }
        }
    }

    private void callOnScrollAndDrag() {
        this.callbackOnFinishAnim();
    }

    private void callOnAfterFullAnim() {
        if ((this.flag.callFreshOrLoad == 1 || this.flag.callFreshOrLoad == 3) && this.headerHander != null && this.flag.callHeaderAnimFlag == 2) {
            this.flag.callHeaderAnimFlag = 0;
        }
        if (this.flag.callFreshOrLoad == 1) {
            this.isCallFresh = false;
        }
        this.flag.callFreshOrLoad = 0;
    }

    private void callOnAfterRefreshAnim() {
        if (this.isTop()) {
            MLog.debug((Object)TAG, (String)"callOnAfterRefreshAnim true", (Object[])new Object[0]);
            this.listener.onRefresh();
        }
    }

    private void callbackOnFinishAnim() {
        if (this.getScrollY() < 0 && this.getScrollY() > -10 && this.headerHander != null && (this.flag.callHeaderAnimFlag == 0 || this.flag.callHeaderAnimFlag == 1)) {
            this.headerHander.onFinishAnim();
            this.flag.callHeaderAnimFlag = 2;
        }
    }

    private void callbackOnStartAnim() {
        if (this.isTop()) {
            this.flag.callFreshOrLoad = 1;
            if (this.headerHander != null && (this.flag.callHeaderAnimFlag == 0 || this.flag.callHeaderAnimFlag == 2)) {
                this.headerHander.onStartAnim(false);
                this.flag.callHeaderAnimFlag = 1;
            }
        }
    }

    private boolean isNeedMyMove(MotionEvent event) {
        if (this.contentLay == null) {
            return false;
        }
        if (this.downAction == 0 && this.getScrollY() < 0 && event.getY() < (float)(-this.getScrollY()) && !this.isContentDown) {
            return false;
        }
        boolean isNowTop = this.isChildScrollToTop();
        if (!this.enableHeader && isNowTop && this.dy > 0.0f) {
            return false;
        }
        return this.header != null && isNowTop && Math.abs(this.dsY) > (float)this.touchSlop && (this.dy > 0.0f || this.getScrollY() < -20);
    }

    private void resetPosition() {
        this.flag.scrollAnimType = 0;
        this.isInControl = false;
        this.mScroller.startScroll(0, this.getScrollY(), 0, -this.getScrollY(), this.MOVE_TIME);
        this.invalidate();
    }

    public void resetPositionFast() {
        this.flag.scrollAnimType = 0;
        this.isInControl = false;
        this.mScroller.startScroll(0, this.getScrollY(), 0, -this.getScrollY(), 0);
    }

    private void resetRefreshPosition() {
        this.flag.scrollAnimType = 1;
        this.isInControl = false;
        if (this.getScrollY() < 0) {
            this.mScroller.startScroll(0, this.getScrollY(), 0, -this.getScrollY() - this.HEADER_SPRING_HEIGHT, this.MOVE_TIME);
            this.invalidate();
        }
    }

    private void restSmartPosition() {
        if (this.listener == null) {
            this.resetPosition();
        } else if (this.isTop()) {
            if (this.dsY > 0.0f) {
                if (this.isTopOverLimit()) {
                    this.callbackOnStartAnim();
                    this.resetRefreshPosition();
                } else {
                    this.flag.callFreshOrLoad = 3;
                    this.resetPosition();
                }
            } else if (Math.abs(this.dsY) > (float)this.HEADER_LIMIT_HEIGHT) {
                this.resetPosition();
            } else {
                this.resetRefreshPosition();
            }
        }
    }

    private void showHeaderAndFooter(Boolean showHeader) {
        if (this.header != null) {
            this.header.setVisibility(showHeader != false ? 0 : 4);
        }
    }

    public boolean isChildScrollToTop() {
        return this.contentView == null || !this.contentView.canScrollVertically(-1) || this.isTop(this.contentView);
    }

    private boolean isTopOverLimit() {
        return -this.getScrollY() > this.HEADER_LIMIT_HEIGHT;
    }

    private boolean isTop() {
        return this.getScrollY() < 0;
    }

    private boolean isFlow() {
        return this.getScrollY() > -30 && this.getScrollY() < 30;
    }

    public void onFinishFreshAndLoad() {
        if (!this.isMoveNow && this.needResetAnim) {
            if (this.isCallFresh) {
                this.resetPosition();
            } else {
                boolean needTop = this.isTop();
                if (needTop) {
                    this.resetPosition();
                }
            }
        }
    }

    public void onFinishFreshAndLoadDelay(int delay) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SpringView.this.onFinishFreshAndLoad();
            }
        }, (long)delay);
    }

    public void onFinishFreshAndLoadDelay() {
        this.onFinishFreshAndLoadDelay(100);
    }

    public void callFresh(boolean callBySystem) {
        if (!this.isTop()) {
            this.isCallFresh = true;
            this.flag.scrollAnimType = 1;
            this.needResetAnim = true;
            this.flag.hasCallRefresh = false;
            this.flag.hasCallFull = false;
            this.flag.callFreshOrLoad = 1;
            if (this.headerHander != null) {
                this.headerHander.onStartAnim(callBySystem);
            }
            this.showHeaderAndFooter(true);
            this.mScroller.startScroll(0, this.getScrollY(), 0, -this.getScrollY() - this.HEADER_SPRING_HEIGHT, this.MOVE_TIME);
            this.invalidate();
        }
    }

    public void callFreshDelay(int delay) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SpringView.this.callFresh(false);
            }
        }, (long)delay);
    }

    public void setListener(OnFreshListener listener) {
        this.listener = listener;
    }

    public DragHander getHeader() {
        return this.headerHander;
    }

    public <TH extends DragHander> TH getHeader(Class<TH> c) {
        return (TH)this.headerHander;
    }

    public void setHeader(DragHander headerHander) {
        if (this.headerHander != null && this.isTop()) {
            this._headerHander = headerHander;
            this.resetPosition();
        } else {
            this._setHeader(headerHander);
        }
    }

    private void _setHeader(DragHander headerHander) {
        View tempView;
        this.headerHander = headerHander;
        if (this.header != null) {
            this.removeView(this.header);
        }
        if ((tempView = headerHander.getView(this.inflater, this)) instanceof SpringView) {
            this.header = this.getChildAt(this.getChildCount() - 1);
        } else {
            this.addView(tempView);
            this.header = tempView;
        }
    }

    public static interface DragHander {
        public View getView(LayoutInflater var1, ViewGroup var2);

        public int getDragLimitHeight(View var1);

        public int getDragMaxHeight(View var1);

        public int getDragSpringHeight(View var1);

        public float getMovePara();

        public Type getType();

        public void onStartAnim(boolean var1);

        public void onFinishAnim();
    }

    public static interface OnFreshListener {
        public void onRefresh();

        public void onLoadmore();
    }

    public static enum Type {
        OVERLAP,
        FOLLOW,
        DRAG,
        SCROLL;

    }
}

