/*
 * Decompiled with CFR 0.152.
 */
package com.liaoinstan.springview.widget;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebView;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ScrollingView;
import com.google.android.material.appbar.AppBarLayout;

class SpringHelper {
    SpringHelper() {
    }

    static AppBarLayout findAppBarLayout(View v) {
        ViewParent p;
        AppBarLayout appBarLayout = null;
        for (p = v.getParent(); p != null && !(p instanceof CoordinatorLayout); p = p.getParent()) {
        }
        if (p != null) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)p;
            int childCount = coordinatorLayout.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = coordinatorLayout.getChildAt(i);
                if (!(child instanceof AppBarLayout)) continue;
                appBarLayout = (AppBarLayout)child;
                break;
            }
        }
        return appBarLayout;
    }

    static boolean couldScroll(AppBarLayout appBarLayout) {
        if (appBarLayout == null) {
            return false;
        }
        boolean couldScroll = false;
        for (int i = 0; i < appBarLayout.getChildCount(); ++i) {
            View child = appBarLayout.getChildAt(i);
            if (!SpringHelper.couldScrollChild(child)) continue;
            couldScroll = true;
            break;
        }
        return couldScroll;
    }

    private static boolean couldScrollChild(View v) {
        if (v.getLayoutParams() instanceof AppBarLayout.LayoutParams) {
            AppBarLayout.LayoutParams layoutParams = (AppBarLayout.LayoutParams)v.getLayoutParams();
            int scrollFlags = layoutParams.getScrollFlags();
            return (scrollFlags & 1) == 1;
        }
        Log.e((String)"SpringView", (String)"view\u68c0\u67e5\u51fa\u73b0\u5f02\u5e38");
        return false;
    }

    static boolean isViewCouldScroll(View view) {
        if (view instanceof ListView || view instanceof ScrollView || view instanceof ScrollingView || view instanceof WebView) {
            return true;
        }
        return view.canScrollVertically(-1) || view.canScrollVertically(1);
    }

    static View findViewCouldScroll(View view) {
        if (SpringHelper.isViewCouldScroll(view)) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View findView = SpringHelper.findViewCouldScroll(viewGroup.getChildAt(i));
                if (findView == null) continue;
                return findView;
            }
            return null;
        }
        return null;
    }
}

