/*
 * Decompiled with CFR 0.152.
 */
package com.yy.socialplatformbase.platform.google.billing;

public class PurchaseParams {
    private final String type;
    private final String productId;
    private final String payload;
    private String accountId;
    private String skuDetails;

    private PurchaseParams(Builder builder) {
        this.type = builder.type;
        this.productId = builder.productId;
        this.payload = builder.payload;
        this.accountId = builder.accountId;
        this.skuDetails = builder.skuDetails;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public PurchaseParams(String type, String productId, String payload) {
        this.type = type;
        this.productId = productId;
        this.payload = payload;
    }

    public String getType() {
        return this.type;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getSkuDetails() {
        return this.skuDetails;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PurchaseParams)) {
            return false;
        }
        return this.productId != null && this.productId.equals(((PurchaseParams)obj).productId) && this.payload != null && this.payload.equals(((PurchaseParams)obj).payload);
    }

    public int hashCode() {
        int hash = 17;
        hash = 23 * hash + (this.productId == null ? 0 : this.productId.hashCode());
        hash = 31 * hash + (this.payload == null ? 0 : this.payload.hashCode());
        return hash;
    }

    public String toString() {
        return "PurchaseParams{type='" + this.type + '\'' + ", productId='" + this.productId + '\'' + ", payload='" + this.payload + '\'' + '}';
    }

    public static final class Builder {
        private String type = "";
        private String productId = "";
        private String payload = "";
        private String accountId = "";
        private String skuDetails = "";

        private Builder() {
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Builder productId(String val) {
            this.productId = val;
            return this;
        }

        public Builder payload(String val) {
            this.payload = val;
            return this;
        }

        public Builder accountId(String val) {
            this.accountId = val;
            return this;
        }

        public Builder skuDetails(String val) {
            this.skuDetails = val;
            return this;
        }

        public PurchaseParams build() {
            return new PurchaseParams(this);
        }
    }
}

