/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import com.yy.hiyo.share.sharetype.GameMasterView;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;

public class ShareMasterModel
extends AbstractShareModel {
    private static final String TAG = "ShareMasterModel";
    private Context mContext;
    private int masterType = 0;

    public ShareMasterModel(UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager, int masterType) {
        super(userInfoKS, serviceManager, dialogLinkManager);
        this.masterType = masterType;
    }

    @Override
    protected void startGetShareData(Context context) {
        this.mContext = context;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)ShareMasterModel.TAG, (String)"start load image", (Object[])new Object[0]);
                if (Build.VERSION.SDK_INT <= 19) {
                    try {
                        ShareMasterModel.this.genImageReal();
                    }
                    catch (Exception e) {
                        MLog.error((Object)ShareMasterModel.TAG, (String)"genImageReal exception", (Throwable)e, (Object[])new Object[0]);
                    }
                } else {
                    ShareMasterModel.this.genImageReal();
                }
            }
        });
    }

    private void genImageReal() {
        final GameMasterView[] gameMasterView = new GameMasterView[]{new GameMasterView(this.mContext)};
        gameMasterView[0].updateShareCardViewBackground(R.drawable.ico_profile_page_share_bg_horizontal);
        gameMasterView[0].setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        gameMasterView[0].measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        gameMasterView[0].layout(0, 0, gameMasterView[0].getMeasuredWidth(), gameMasterView[0].getMeasuredHeight());
        gameMasterView[0].updateMaster(this.mUserInfoKS, this.masterType, new IShareCardImageFinishLoadedCallback(){

            @Override
            public void onImageFinishLoaded(String imagePath) {
                ShareMasterModel.this.mImagePath = imagePath;
                ShareMasterModel.this.uploadImageForShare();
                gameMasterView[0] = null;
            }
        });
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(String.format(ResourceUtils.getString((int)R.string.title_share_streak_win), this.mUserInfoKS.nick));
        }
        return String.format(ResourceUtils.getString((int)R.string.title_share_streak_win), this.mUserInfoKS.nick);
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.subtitle_share_streak_win));
        }
        return ResourceUtils.getString((int)R.string.subtitle_share_streak_win);
    }

    @Override
    protected String getShareUrl() {
        return this.generateFindFriendShareUrl();
    }
}

