/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.R;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.FindFriendShareBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnGetShareForFriendCallback;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.IStartShareCallback;
import com.yy.hiyo.share.base.ShareCardData;
import com.yy.hiyo.share.base.bean.GameCardShareParam;
import com.yy.hiyo.share.base.bean.ShareCardInfo;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import com.yy.hiyo.share.sharetype.AdPictureCardModel;
import com.yy.hiyo.share.sharetype.IGetShareDataCallback;
import com.yy.hiyo.share.sharetype.InviteCardModel;
import com.yy.hiyo.share.sharetype.InviteFriendData;
import com.yy.hiyo.share.sharetype.PkGameCardModel;
import com.yy.hiyo.share.sharetype.ProfileCardModel;
import com.yy.hiyo.share.sharetype.ShareGameCardModel;
import com.yy.hiyo.share.sharetype.ShareMasterModel;
import com.yy.hiyo.share.sharetype.SingleGameCardModel;
import com.yy.hiyo.share.sharetype.StreakWinCardModel;
import com.yy.hiyo.share.sharetype.VietnamInviteCardModel;
import com.yy.socialplatformbase.data.ShareData;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class ShareCardTypeController
extends DefaultController
implements IGetShareDataCallback,
ISharePage {
    private static final String TAG = "ShareCardTypeController";
    private static final int TYPE_SHARE_CARD_PROFILE = 0;
    private static final int TYPE_SHARE_CARD_FIND_FRIEND = 1;
    private static final int TYPE_SHARE_CARD_STREAK_WIN = 2;
    private static final int TYPE_SHARE_CARD_INVITE_FRIEND = 3;
    private static final int TYPE_SHARE_CARD_GAME_MASTER = 4;
    private static final int TYPE_SHARE_CARD_AR_GAME = 5;
    private int cardType;
    private UserInfoKS mUserInfoKS;
    private String mPageType;
    private int mPageId;
    private String mImageUrl;
    private String mShortUrl;
    private String mImagePath;
    private boolean mFindFriendNewIn;
    private int mStreakWinCount;
    private boolean mIsNewUser;
    private boolean isVietnamShare;
    private int mChannelId;
    private AbstractShareModel mShareModel;
    private long mCurrentTimeMillis;
    private int mShareTo;
    private int masterType;
    private GameCardShareParam mGameCardShareParam;
    private IAB mStyleABTest = null;
    private DataCallback<String> mGetShortUrlCallback;
    private String mProfileShortUrl = "";

    public ShareCardTypeController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).closeShareDialog();
        }
    }

    public void handleMessage(Message msg) {
        this.mPageId = -1;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.mCurrentTimeMillis < 500L) {
            return;
        }
        this.mCurrentTimeMillis = currentTimeMillis;
        if (msg.what == BaseMsgDef.MSG_SHOW_PROFILE_SHARE) {
            this.resetData();
            this.mPageId = msg.arg1;
            if (msg.obj instanceof String) {
                this.mPageType = (String)msg.obj;
            }
            long uid = AccountUtil.getUid();
            if (msg.getData() != null && msg.getData().containsKey("uid")) {
                uid = msg.getData().getLong("uid");
            }
            this.cardType = 0;
            this.needShowShareSelectItems(uid);
        } else if (msg.what == BaseMsgDef.MSG_SHARE_FIND_FRIEND) {
            this.mFindFriendNewIn = true;
            this.mChannelId = msg.arg1;
            this.mPageId = msg.arg2;
            this.cardType = 1;
            if (msg.obj instanceof DataCallback) {
                this.mGetShortUrlCallback = (DataCallback)msg.obj;
                if (StringUtils.isNotEmpty((String)this.mProfileShortUrl)) {
                    this.mGetShortUrlCallback.onResult((Object)this.mProfileShortUrl);
                    return;
                }
            }
            this.needShowShareSelectItems(AccountUtil.getUid());
        } else if (msg.what == BaseMsgDef.MSG_SHARE_STREAK_WIN) {
            this.resetData();
            if (msg.obj instanceof Integer) {
                this.mStreakWinCount = (Integer)msg.obj;
            }
            this.mChannelId = msg.arg1;
            this.mIsNewUser = msg.arg2 == 1;
            this.cardType = 2;
            this.needShowShareSelectItems(AccountUtil.getUid());
        } else if (msg.what == BaseMsgDef.MSG_SHARE_INVITE_FRIEND) {
            if (msg.obj instanceof InviteFriendData) {
                this.resetData();
                InviteFriendData data = (InviteFriendData)msg.obj;
                this.mChannelId = data.sharePlatform;
                this.isVietnamShare = data.isVietnam;
                this.mPageId = msg.arg1;
                this.cardType = 3;
                this.mPageType = "invitefriend";
                this.needShowShareSelectItems(AccountUtil.getUid());
            }
        } else if (msg.what == BaseMsgDef.MSG_SHARE_GAME_MASTER) {
            this.resetData();
            this.mChannelId = msg.arg1;
            this.masterType = msg.arg2;
            this.cardType = 4;
            this.needShowShareSelectItems(AccountUtil.getUid());
        } else if (msg.what == BaseMsgDef.MSG_SHARE_CARD_AR_GAME) {
            this.resetData();
            this.mChannelId = msg.arg1;
            this.mPageId = msg.arg2;
            this.cardType = 5;
            if (msg.obj instanceof GameCardShareParam) {
                this.mGameCardShareParam = (GameCardShareParam)msg.obj;
            }
            this.needShowShareSelectItems(AccountUtil.getUid());
        }
    }

    @Nullable
    private IAB getCardStyleTest() {
        return this.mStyleABTest;
    }

    private void getUserInfoForShare(long uid) {
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (userInfoKSList == null || userInfoKSList.size() <= 0) {
                    return;
                }
                ShareCardTypeController.this.mUserInfoKS = userInfoKSList.get(0);
                if (ShareCardTypeController.this.mUserInfoKS != null) {
                    if (ShareCardTypeController.this.cardType == 0) {
                        ShareCardTypeController.this.showProfileShareDialog();
                    } else if (ShareCardTypeController.this.cardType == 1) {
                        ShareCardTypeController.this.shareFromFindFriend();
                    } else if (ShareCardTypeController.this.cardType == 2) {
                        ShareCardTypeController.this.shareFromStreakWin();
                    } else if (ShareCardTypeController.this.cardType == 3) {
                        ShareCardTypeController.this.shareFromInviteFriend();
                    } else if (ShareCardTypeController.this.cardType == 4) {
                        ShareCardTypeController.this.shareFromGameMaster();
                    } else if (ShareCardTypeController.this.cardType == 5) {
                        ShareCardTypeController.this.shareGameCard();
                    }
                }
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
    }

    private void needShowShareSelectItems(long uid) {
        if (this.mChannelId == 11) {
            this.showShareSelectItems();
            return;
        }
        this.getUserInfoForShare(uid);
    }

    private void showShareSelectItems() {
        ArrayList<ButtonItem> buttonItems = new ArrayList<ButtonItem>(2);
        buttonItems.add(new ButtonItem(ResourceUtils.getString((int)R.string.share_to_friend), 3, new ButtonItem.OnClickListener(){

            public void onClick() {
                ShareCardTypeController.this.mShareTo = 1;
                if (ShareCardTypeController.this.cardType == 0) {
                    ShareCardTypeController.this.shareProfile();
                } else {
                    ShareCardTypeController.this.getUserInfoForShare(AccountUtil.getUid());
                }
            }
        }));
        buttonItems.add(new ButtonItem(ResourceUtils.getString((int)R.string.share_to_timeline), 3, new ButtonItem.OnClickListener(){

            public void onClick() {
                ShareCardTypeController.this.mShareTo = 2;
                if (ShareCardTypeController.this.cardType == 0) {
                    ShareCardTypeController.this.shareProfile();
                } else {
                    ShareCardTypeController.this.getUserInfoForShare(AccountUtil.getUid());
                }
            }
        }));
        this.mDialogLinkManager.showCommonPopupDialog(buttonItems, true, true);
    }

    private void showProfileShareDialog() {
        MLog.info((Object)TAG, (String)"start to show profile share card", (Object[])new Object[0]);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("page_id", String.valueOf(this.mPageId)).put("function_id", "2"));
        ShareCardData shareCardData = new ShareCardData();
        shareCardData.iconUrl = this.mUserInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75);
        shareCardData.title = this.mUserInfoKS.nick;
        shareCardData.subtitle = ResourceUtils.getString((int)R.string.short_summary_id) + this.mUserInfoKS.vid;
        shareCardData.shareTip = ResourceUtils.getString((int)R.string.tip_profile_share);
        if (this.mUserInfoKS.sex == 1) {
            shareCardData.defaultIcon = R.drawable.icon_avatar_default_male;
            shareCardData.cardBg = R.drawable.page_profile_share_male_bg;
        } else {
            shareCardData.defaultIcon = R.drawable.icon_avatar_default_female;
            shareCardData.cardBg = R.drawable.page_profile_share_female_bg;
        }
        shareCardData.shareChannelList = ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).getChannelsByPage((ISharePage)this);
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).showShareCardDialog(shareCardData, new IStartShareCallback(){

            public void onStartShare(int channelId) {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                    return;
                }
                ShareCardTypeController.this.mChannelId = channelId;
                if (ShareCardTypeController.this.mChannelId == 11) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("page_id", String.valueOf(ShareCardTypeController.this.mPageId)).put("function_id", "3"));
                    ShareCardTypeController.this.showShareSelectItems();
                } else {
                    ShareCardTypeController.this.shareProfile();
                }
            }
        }, new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                ShareCardTypeController.this.resetData();
            }
        });
    }

    private void shareProfile() {
        this.showLoadingDialog();
        if (this.mShareModel != null) {
            this.mShareModel.cancelCallback();
        }
        this.mShareModel = null;
        this.mShareModel = new ProfileCardModel(this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
        this.mShareModel.setPageType(this.mPageType);
        this.mShareModel.setChannelId(this.mChannelId);
        this.mShareModel.setShareStyleAB(this.getCardStyleTest());
        this.mShareModel.startGetShareData(this.mContext, this);
    }

    private void shareFromFindFriend() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (!(this.mFindFriendNewIn || TextUtils.isEmpty((CharSequence)this.mShortUrl) || TextUtils.isEmpty((CharSequence)this.mImagePath) || TextUtils.isEmpty((CharSequence)this.mImageUrl))) {
            this.startShare();
            return;
        }
        this.showLoadingDialog();
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getShareForFriend(AccountUtil.getUid(), new OnGetShareForFriendCallback(){

            public void onGetSuccess(FindFriendShareBean shareBean) {
                ShareCardTypeController.this.doFindFriendShare(shareBean);
            }

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)ShareCardTypeController.TAG, (String)("getShareForFriend onErr\uff1a" + e.toString()), (Object[])new Object[0]);
                ShareCardTypeController.this.dismissLoadingDialog();
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.network_error), (int)0);
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.info((Object)ShareCardTypeController.TAG, (String)"getShareForFriend onResponseError", (Object[])new Object[0]);
                ShareCardTypeController.this.dismissLoadingDialog();
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.network_error), (int)0);
            }
        });
    }

    private void doFindFriendShare(FindFriendShareBean shareBean) {
        if (this.mShareModel != null) {
            this.mShareModel.cancelCallback();
        }
        this.mShareModel = null;
        if (shareBean == null) {
            return;
        }
        if (shareBean.template == 1) {
            this.mShareModel = new PkGameCardModel(shareBean.gameicon, this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
        } else if (shareBean.template == 2) {
            this.mShareModel = new SingleGameCardModel(shareBean.gameicon, shareBean.gameScore, shareBean.gameName, this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
        } else if (shareBean.template == 3) {
            this.mShareModel = new ProfileCardModel(this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
            this.mShareModel.setChannelId(this.mChannelId);
            this.mShareModel.setPageType("playwithfriend");
            this.mShareModel.setShareStyleAB(this.getCardStyleTest());
        } else if (shareBean.template == 4) {
            boolean isNeedDownloadImage = false;
            if (this.mChannelId == 9 || this.mChannelId == 3 || this.mChannelId == 2 || this.mChannelId == 0) {
                isNeedDownloadImage = true;
            }
            this.mShareModel = new AdPictureCardModel(isNeedDownloadImage, this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
        }
        if (this.mShareModel != null) {
            this.mShareModel.setFindFriendGuideType(shareBean.template);
        } else {
            this.mShareModel = new ProfileCardModel(this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
            this.mShareModel.setPageType("playwithfriend");
            this.mShareModel.setFindFriendGuideType(2);
            this.mShareModel.setShareStyleAB(this.getCardStyleTest());
        }
        this.mShareModel.setChannelId(this.mChannelId);
        this.mShareModel.startGetShareData(this.mContext, this);
    }

    private void shareFromStreakWin() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (!(this.mStreakWinCount <= 0 || TextUtils.isEmpty((CharSequence)this.mShortUrl) || TextUtils.isEmpty((CharSequence)this.mImagePath) || TextUtils.isEmpty((CharSequence)this.mImageUrl))) {
            this.startShare();
            return;
        }
        this.mShareModel = new StreakWinCardModel(this.mStreakWinCount, this.mIsNewUser, this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
        this.mShareModel.startGetShareData(this.mContext, this);
        this.mShareModel.setPageType("streak_window");
    }

    private void shareFromGameMaster() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (!(TextUtils.isEmpty((CharSequence)this.mShortUrl) || TextUtils.isEmpty((CharSequence)this.mImagePath) || TextUtils.isEmpty((CharSequence)this.mImageUrl))) {
            this.startShare();
            return;
        }
        this.mShareModel = new ShareMasterModel(this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager, this.masterType);
        this.mShareModel.startGetShareData(this.mContext, this);
        this.mShareModel.setPageType("game_master");
    }

    private void shareGameCard() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (!(TextUtils.isEmpty((CharSequence)this.mShortUrl) || TextUtils.isEmpty((CharSequence)this.mImagePath) || TextUtils.isEmpty((CharSequence)this.mImageUrl))) {
            this.startShare();
            return;
        }
        this.mShareModel = new ShareGameCardModel(this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager, this.mGameCardShareParam);
        this.mShareModel.startGetShareData(this.mContext, this);
        this.mShareModel.setPageType("ar_game");
    }

    private void shareFromInviteFriend() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (!(TextUtils.isEmpty((CharSequence)this.mShortUrl) || TextUtils.isEmpty((CharSequence)this.mImagePath) || TextUtils.isEmpty((CharSequence)this.mImageUrl))) {
            this.startShare();
            return;
        }
        this.showLoadingDialog();
        if (this.isVietnamShare) {
            this.mShareModel = new VietnamInviteCardModel(this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
        } else {
            this.mShareModel = new InviteCardModel(this.mUserInfoKS, this.getServiceManager(), this.mDialogLinkManager);
            this.mShareModel.setShareStyleAB(this.getCardStyleTest());
        }
        this.mShareModel.startGetShareData(this.mContext, this);
        this.mShareModel.setChannelId(this.mChannelId);
        this.mShareModel.setPageType("invitefriend");
    }

    @Override
    public void getShareDataSuccess(boolean isSuccess) {
        this.dismissLoadingDialog();
        if (!isSuccess) {
            return;
        }
        if (this.mShareModel != null) {
            this.mImageUrl = this.mShareModel.getShareImageUrl();
            this.mShortUrl = this.mShareModel.getShareShortUrl();
            this.mImagePath = this.mShareModel.getShareImagePath();
            ShareCardInfo info = new ShareCardInfo(this.mShortUrl, this.mShareModel.getShareTitle(false), this.mShareModel.getShareSubtitle(false), this.mImageUrl, this.mImagePath);
            this.sendMessage(BaseMsgDef.SHARE_CARD_INFO, -1, -1, info);
            MLog.info((Object)TAG, (String)"getShareDataSuccess, imageUrl: %s, shortUrl: %s, imagePath: %s", (Object[])new Object[]{this.mImageUrl, this.mShortUrl, this.mImagePath});
            if (this.mShareModel instanceof ProfileCardModel && this.mGetShortUrlCallback != null) {
                this.mProfileShortUrl = this.mShareModel.getShareShortUrl();
                this.mGetShortUrlCallback.onResult((Object)this.mProfileShortUrl);
            }
        }
        this.startShare();
    }

    private String getShareTitle() {
        if (this.mShareModel == null) {
            return "";
        }
        return this.mShareModel.getShareTitle(false);
    }

    private String getShareText() {
        if (this.mShareModel == null) {
            return "";
        }
        return this.mShareModel.getShareSubtitle(false);
    }

    private void startShare() {
        if (this.mChannelId == -1) {
            return;
        }
        MLog.info((Object)TAG, (String)("shart to share\uff1a" + this.mChannelId), (Object[])new Object[0]);
        switch (this.mChannelId) {
            case 9: {
                this.shareVK(this.mImageUrl, this.mShortUrl);
                break;
            }
            case 5: {
                this.shareFacebook(this.mShortUrl);
                break;
            }
            case 2: {
                this.shareWhatsapp(this.mImagePath, this.mShortUrl);
                break;
            }
            case 10: {
                this.shareCopyLink(this.mChannelId, this.mShortUrl);
                break;
            }
            case 0: {
                this.shareOthers(this.mChannelId, this.mShortUrl);
                break;
            }
            case 3: {
                this.shareInstagram(this.mImagePath, this.mShortUrl);
                break;
            }
            case 1: {
                this.shareLine(this.mShortUrl);
                break;
            }
            case 6: {
                this.shareMessenger(this.mImageUrl, this.mShortUrl);
                break;
            }
            case 11: {
                this.shareZalo(this.mShortUrl);
                break;
            }
            case 7: {
                this.shareSnapchat(this.mImagePath, this.mShortUrl);
                break;
            }
        }
    }

    private void shareOthers(final int channelId, String shortUrl) {
        String title = this.getShareTitle();
        shortUrl = URLUtils.replaceUrl((String)shortUrl);
        final ShareData shareData = ShareData.builder().text(title + "\n" + this.getShareText() + " " + shortUrl).imgPath(this.mImagePath).build();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IIntlShareService)ShareCardTypeController.this.getServiceManager().getService(IIntlShareService.class)).share(channelId, shareData);
            }
        });
        this.reportShareChannelHiidoEvent("5");
    }

    private void shareCopyLink(final int channelId, String shortUrl) {
        String title = this.getShareTitle();
        shortUrl = URLUtils.replaceUrl((String)shortUrl);
        final ShareData shareData = ShareData.builder().text(title + "\n" + this.getShareText() + " " + shortUrl).build();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IIntlShareService)ShareCardTypeController.this.getServiceManager().getService(IIntlShareService.class)).share(channelId, shareData);
            }
        });
        this.reportShareChannelHiidoEvent("9");
    }

    private void shareFacebook(String url) {
        ShareData shareData = ShareData.builder().type(2).to(2).title(this.getShareTitle()).text(this.getShareText()).gotoUrl(url).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(5, shareData);
        this.reportShareChannelHiidoEvent("1");
    }

    private void shareVK(String imageUrl, String url) {
        ShareData shareData = ShareData.builder().type(2).to(2).title(this.getShareTitle()).text(this.getShareText()).gotoUrl(url).imgPath(imageUrl).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(9, shareData);
        this.reportShareChannelHiidoEvent("6");
    }

    private void shareWhatsapp(String imagePath, String url) {
        url = URLUtils.replaceUrl((String)url);
        ShareData shareData = ShareData.builder().type(1).to(2).text(this.getShareTitle() + "\n" + this.getShareText() + "\n" + url).imgPath(imagePath).systemShare(true).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(2, shareData);
        this.reportShareChannelHiidoEvent("3");
    }

    private void shareInstagram(final String imagePath, String url) {
        if (!((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).checkAppNeedInstalledOrToast(3)) {
            return;
        }
        final String replaceUrl = URLUtils.replaceUrl((String)url);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ShareData shareData = ShareData.builder().type(1).title(ShareCardTypeController.this.getShareTitle()).text(ShareCardTypeController.this.getShareTitle() + "\n" + ShareCardTypeController.this.getShareText() + "\n" + replaceUrl).imgPath(imagePath).systemShare(true).build();
                ((IIntlShareService)ShareCardTypeController.this.getServiceManager().getService(IIntlShareService.class)).share(3, shareData);
            }
        });
        this.reportShareChannelHiidoEvent("4");
    }

    private void shareLine(String url) {
        url = URLUtils.replaceUrl((String)url);
        ShareData shareData = ShareData.builder().type(0).to(1).title(this.getShareTitle()).text(this.getShareText() + "\n" + url).systemShare(true).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(1, shareData);
        this.reportShareChannelHiidoEvent("2");
    }

    private void shareMessenger(String imageUrl, String url) {
        url = URLUtils.replaceUrl((String)url);
        ShareData shareData = ShareData.builder().to(1).title(this.getShareTitle()).imgPath(imageUrl).text(this.getShareText() + "\n" + url).gotoUrl(url).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(6, shareData);
        this.reportShareChannelHiidoEvent("7");
    }

    private void shareZalo(String url) {
        ShareData shareData = null;
        url = URLUtils.replaceUrl((String)url);
        if (this.mShareTo == 1) {
            shareData = ShareData.builder().type(2).to(1).title(this.getShareTitle()).text(this.getShareText()).gotoUrl(url).build();
        } else if (this.mShareTo == 2) {
            shareData = ShareData.builder().type(2).to(2).title(this.getShareTitle()).text(this.getShareText()).gotoUrl(url).build();
        }
        if (shareData != null) {
            ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(11, shareData);
            if (this.mShareTo == 1) {
                this.reportShareChannelHiidoEvent("10");
            } else if (this.mShareTo == 2) {
                this.reportShareChannelHiidoEvent("11");
            }
        }
    }

    private void shareSnapchat(String imagePath, String url) {
        ShareData shareData = ShareData.builder().type(1).to(2).gotoUrl(url).imgPath(imagePath).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(7, shareData);
        this.reportShareChannelHiidoEvent("13");
    }

    private void reportShareChannelHiidoEvent(String shareChannelId) {
        if (this.mPageId < 0) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("page_id", String.valueOf(this.mPageId)).put("function_id", "1").put("share_channel", shareChannelId));
    }

    public String getPageName() {
        return "profile_share";
    }

    private void resetData() {
        this.mShortUrl = "";
        this.mImageUrl = "";
        this.mImagePath = "";
        this.mChannelId = -1;
        this.isVietnamShare = false;
    }

    protected void showLoadingDialog() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressDialog progressDialog = new ProgressDialog("", true, false, null);
                ShareCardTypeController.this.mDialogLinkManager.showDialog((BaseDialog)progressDialog);
            }
        });
    }

    protected void dismissLoadingDialog() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ShareCardTypeController.this.mDialogLinkManager.dismissDialog();
            }
        });
    }
}

