/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.DebugTestUriProvider;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.honor.HonorInfo;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnGetLatestHonorCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import com.yy.hiyo.share.sharetype.ProfileShareCardViewNew;
import okhttp3.Call;

public class ProfileCardModel
extends AbstractShareModel {
    private static final String TAG = "ProfileCardDataModel";
    private static final String SHARE_PAGE_HOST = "https://www.ihago.net";
    private static final String SHARE_PAGE_TEST_HOST = DebugTestUriProvider.TEST_OLA_PARTY_HOST;
    private static final String SHARE_PAGE_PATH = "/a/profilecardlanding/index.html";
    private static final String LANG = SystemUtils.getLangAndCountry();
    private static final int IDC = UriProvider.getIdc();
    private Context mContext;
    private int mHonorType;
    private String mHonorName;
    private String mHonorIconUrl;

    public ProfileCardModel(UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        super(userInfoKS, serviceManager, dialogLinkManager);
    }

    private String getShareTitle(int shareChannel) {
        if (shareChannel == 7) {
            if (StringUtils.equal((String)this.mPageType, (String)"playwithfriend")) {
                return ResourceUtils.getString((int)R.string.share_play_with_friend_main_content);
            }
            return ResourceUtils.getString((int)R.string.share_personal_profile_main_content);
        }
        return ResourceUtils.getString((int)R.string.share_personal_profile_content_other);
    }

    private String getShareSubTitle(int shareChannel) {
        if (shareChannel == 7) {
            if (StringUtils.equal((String)this.mPageType, (String)"playwithfriend")) {
                return ResourceUtils.getString((int)R.string.share_play_with_friend_second_content);
            }
            return ResourceUtils.getString((int)R.string.share_personal_profile_second_content);
        }
        return ResourceUtils.getString((int)R.string.tip_meet_me_in_hago);
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        String content = this.getShareTitle(this.mChannelId);
        if (needEncode) {
            return this.urlEncoderStr(content);
        }
        return content;
    }

    private String subNickname(String str) {
        String tempStr = str;
        if (str.length() > 10) {
            tempStr = str.substring(0, 10) + "...";
        }
        return tempStr;
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        String content = this.getShareSubTitle(this.mChannelId);
        if (needEncode) {
            return this.urlEncoderStr(content);
        }
        return content;
    }

    @Override
    protected String getShareUrl() {
        return this.getProfileShareUrl(this.mHonorType, this.mHonorName);
    }

    @Override
    protected void startGetShareData(Context context) {
        this.mContext = context;
        this.getLatestHonor();
    }

    private void getLatestHonor() {
        ((IUserInfoService)this.mServiceManager.getService(IUserInfoService.class)).getLatestHonor(AccountUtil.getUid(), new OnGetLatestHonorCallback(){

            public void onLatestHonorSuccess(HonorInfo honorInfo) {
                MLog.info((Object)ProfileCardModel.TAG, (String)"get latest honor success", (Object[])new Object[0]);
                if (honorInfo == null) {
                    ProfileCardModel.this.mHonorType = -1;
                    ProfileCardModel.this.mHonorName = "";
                    ProfileCardModel.this.mHonorIconUrl = "";
                    ProfileCardModel.this.generateImage();
                    return;
                }
                MLog.info((Object)ProfileCardModel.TAG, (String)("get latest honor success\uff1a" + honorInfo.getId()), (Object[])new Object[0]);
                ProfileCardModel.this.mHonorType = (int)honorInfo.getId();
                ProfileCardModel.this.mHonorName = honorInfo.getName();
                ProfileCardModel.this.mHonorIconUrl = honorInfo.getSicon();
                ProfileCardModel.this.generateImage();
            }

            public void onLatestHonorError() {
                MLog.info((Object)ProfileCardModel.TAG, (String)"get latest honor onError OnLatestHonorError", (Object[])new Object[0]);
                ProfileCardModel.this.mHonorType = -1;
                ProfileCardModel.this.mHonorName = "";
                ProfileCardModel.this.mHonorIconUrl = "";
                ProfileCardModel.this.generateImage();
            }

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)ProfileCardModel.TAG, (String)"get latest honor onError", (Object[])new Object[0]);
                ProfileCardModel.this.mHonorType = -1;
                ProfileCardModel.this.mHonorName = "";
                ProfileCardModel.this.mHonorIconUrl = "";
                ProfileCardModel.this.generateImage();
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.info((Object)ProfileCardModel.TAG, (String)"get latest honor onResponseError", (Object[])new Object[0]);
                ProfileCardModel.this.mHonorType = -1;
                ProfileCardModel.this.mHonorName = "";
                ProfileCardModel.this.mHonorIconUrl = "";
                ProfileCardModel.this.generateImage();
            }
        });
    }

    private void generateImage() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)ProfileCardModel.TAG, (String)"start load image", (Object[])new Object[0]);
                if (Build.VERSION.SDK_INT <= 19) {
                    try {
                        ProfileCardModel.this.genImageReal();
                    }
                    catch (Exception e) {
                        MLog.error((Object)ProfileCardModel.TAG, (String)"genImageReal exception", (Throwable)e, (Object[])new Object[0]);
                    }
                } else {
                    ProfileCardModel.this.genImageReal();
                }
            }
        });
    }

    private void genImageReal() {
        final ProfileShareCardViewNew shareCardViewNew = new ProfileShareCardViewNew(this.mContext, this.mChannelId, this.mPageType);
        shareCardViewNew.setStyleTest(this.mStyleABTest);
        try {
            this.mDialogLinkManager.showDialog(new BaseDialog(){

                public void init(final Dialog dialog) {
                    if (dialog != null) {
                        dialog.setCancelable(true);
                        dialog.setCanceledOnTouchOutside(true);
                        shareCardViewNew.setVisibility(4);
                        dialog.setContentView((View)shareCardViewNew);
                        shareCardViewNew.updateUserProfile(ProfileCardModel.this.mUserInfoKS.avatar, ProfileCardModel.this.mUserInfoKS.nick, ProfileCardModel.this.mUserInfoKS.vid, ProfileCardModel.this.mUserInfoKS.sex, ProfileCardModel.this.getShareTitle(false), ProfileCardModel.this.getShareSubtitle(false), new IShareCardImageFinishLoadedCallback(){

                            @Override
                            public void onImageFinishLoaded(String imagePath) {
                                MLog.info((Object)ProfileCardModel.TAG, (String)"image save path: %s", (Object[])new Object[]{imagePath});
                                ProfileCardModel.this.mImagePath = imagePath;
                                dialog.dismiss();
                                ProfileCardModel.this.uploadImageForShare();
                            }
                        });
                    }
                }

                public int getId() {
                    return 0;
                }
            });
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"genImageReal error", (Throwable)ex, (Object[])new Object[0]);
            this.mImagePath = null;
            this.uploadImageForShare();
        }
    }

    private String getProfileShareUrl(int honorType, String honorName) {
        long uid = 0L;
        long vid = 0L;
        String nick = "";
        if (this.mUserInfoKS != null && !TextUtils.isEmpty((CharSequence)this.mUserInfoKS.nick)) {
            uid = this.mUserInfoKS.uid;
            vid = this.mUserInfoKS.vid;
            nick = this.mUserInfoKS.nick;
        }
        String url = this.generateShareHost() + SHARE_PAGE_PATH + "?uid=" + uid + "&vid=" + vid + "&medalid=" + honorType + "&medalUrl=" + this.mHonorIconUrl + "&medalName=" + honorName + "&bgImg=" + this.mImageUrl + "&nick=" + this.subNickname(nick) + "&lang=" + LANG + "&fromPage=" + this.mPageType + "&h=" + IDC;
        return url;
    }

    private String generateShareHost() {
        String host = SHARE_PAGE_HOST;
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        if (type == EnvSettingType.Product) {
            host = SHARE_PAGE_HOST;
        } else if (type == EnvSettingType.Test) {
            host = SHARE_PAGE_TEST_HOST;
        }
        return URLUtils.replaceHost((String)host);
    }
}

