/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import com.yy.hiyo.share.sharetype.PKGameCardView;

public class PkGameCardModel
extends AbstractShareModel {
    private static final String TAG = "PkGameCardModel";
    private PKGameCardView mPkGameCardView;
    private String mGameIconUrl;

    public PkGameCardModel(String gameIconUrl, UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        super(userInfoKS, serviceManager, dialogLinkManager);
        this.mGameIconUrl = gameIconUrl;
    }

    @Override
    protected void startGetShareData(final Context context) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT <= 19) {
                    try {
                        PkGameCardModel.this.genImageReal(context);
                    }
                    catch (Exception e) {
                        MLog.error((Object)PkGameCardModel.TAG, (String)"genImageReal exception", (Throwable)e, (Object[])new Object[0]);
                    }
                } else {
                    PkGameCardModel.this.genImageReal(context);
                }
            }
        });
    }

    private void genImageReal(Context context) {
        this.mPkGameCardView = new PKGameCardView(context);
        this.mPkGameCardView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mPkGameCardView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        this.mPkGameCardView.layout(0, 0, this.mPkGameCardView.getMeasuredWidth(), this.mPkGameCardView.getMeasuredHeight());
        this.mPkGameCardView.updatePkGameCard(this.mUserInfoKS, this.mGameIconUrl, new IShareCardImageFinishLoadedCallback(){

            @Override
            public void onImageFinishLoaded(String imagePath) {
                PkGameCardModel.this.mImagePath = imagePath;
                PkGameCardModel.this.uploadImageForShare();
                PkGameCardModel.this.mPkGameCardView = null;
            }
        });
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.title_invite_share_pk_game_title));
        }
        return ResourceUtils.getString((int)R.string.title_invite_share_pk_game_title);
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.title_invite_share_pk_game_text));
        }
        return ResourceUtils.getString((int)R.string.title_invite_share_pk_game_text);
    }

    @Override
    protected String getShareUrl() {
        return this.generateFindFriendShareUrl();
    }
}

