/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;

public class PKGameCardView
extends YYRelativeLayout {
    private Context mContext;
    private RoundConerImageView mIvGameIcon;
    private CircleImageView mIvAvatar;
    private YYTextView mTvNickname;
    private YYTextView mTvCardTitle;
    private IShareCardImageFinishLoadedCallback mCallback;
    private boolean mAvatarFinishLoaded;
    private boolean mGameIconFinishLoaded;
    private boolean mHadDraw;

    public PKGameCardView(Context context) {
        super(context);
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.layout_pk_game_share_card, (ViewGroup)this, true);
        this.mIvGameIcon = (RoundConerImageView)this.findViewById(R.id.rciv_game_icon);
        this.mIvAvatar = (CircleImageView)this.findViewById(R.id.cciv_avatar);
        this.mTvNickname = (YYTextView)this.findViewById(R.id.tv_nick_name);
        this.mTvCardTitle = (YYTextView)this.findViewById(R.id.tv_card_title);
        this.mTvCardTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
    }

    public void updatePkGameCard(UserInfoKS userInfoKS, String gameIconUrl, IShareCardImageFinishLoadedCallback callback) {
        if (userInfoKS == null || callback == null) {
            return;
        }
        this.mHadDraw = false;
        this.mCallback = callback;
        this.mTvNickname.setText((CharSequence)userInfoKS.nick);
        String avatarUrl = userInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75);
        ImageLoader.loadImage((ImageView)this.mIvAvatar, (String)avatarUrl, (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex), (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                PKGameCardView.this.mAvatarFinishLoaded = true;
                PKGameCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                PKGameCardView.this.mAvatarFinishLoaded = true;
                PKGameCardView.this.hadImageFinishLoaded();
            }
        });
        ImageLoader.loadImage((ImageView)this.mIvGameIcon, (String)gameIconUrl, (int)R.drawable.icon_default_photo, (int)R.drawable.icon_default_photo, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                PKGameCardView.this.mGameIconFinishLoaded = true;
                PKGameCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                PKGameCardView.this.mGameIconFinishLoaded = true;
                PKGameCardView.this.hadImageFinishLoaded();
            }
        });
        this.invalidate();
    }

    private void hadImageFinishLoaded() {
        if (this.mCallback != null && this.mAvatarFinishLoaded && this.mGameIconFinishLoaded && !this.mHadDraw) {
            this.mHadDraw = true;
            this.genImageAndSaveToAlbum();
        }
    }

    private void genImageAndSaveToAlbum() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)PKGameCardView.this);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PKGameCardView.this.mCallback.onImageFinishLoaded("");
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String imageName = "pkGameShare";
                final String saveResult = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PKGameCardView.this.mCallback.onImageFinishLoaded(saveResult);
                    }
                });
            }
        });
    }
}

