/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.os.Build;
import android.view.View;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.DebugTestUriProvider;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import com.yy.hiyo.share.sharetype.InviteCardView;
import java.util.Map;

public class InviteCardModel
extends AbstractShareModel {
    private static final String TAG = "InviteCardModel";
    private static final String SHARE_PAGE_HOST = "https://www.ihago.net";
    private static final String SHARE_PAGE_TEST_HOST = DebugTestUriProvider.TEST_OLA_PARTY_HOST;
    private static final String SHARE_PAGE_PATH = "/a/invite-share/blank.html?img=%s&inviteUid=%d&title=%s&desc=%s&h=%d&lang=%s";
    private static final String DRAWER_INVITE_FRIEND_CARD_BG = "share_card_bg";

    public InviteCardModel(UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        super(userInfoKS, serviceManager, dialogLinkManager);
    }

    @Override
    protected void startGetShareData(Context context) {
        this.fetchInviteBossConfig(context);
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        String content = this.getShareTitle(this.mChannelId);
        if (needEncode) {
            return this.urlEncoderStr(content);
        }
        return content;
    }

    private String getShareTitle(int shareChannel) {
        if (shareChannel == 7) {
            return ResourceUtils.getString((int)R.string.share_invite_friend_main_content);
        }
        return ResourceUtils.getString((int)R.string.share_personal_profile_content_other);
    }

    private String getShareSubTitle(int shareChannel) {
        if (shareChannel == 7) {
            return ResourceUtils.getString((int)R.string.share_invite_friend_second_content);
        }
        return ResourceUtils.getString((int)R.string.tip_meet_me_in_hago);
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        String content = this.getShareSubTitle(this.mChannelId);
        if (needEncode) {
            return this.urlEncoderStr(content);
        }
        return content;
    }

    @Override
    protected String getShareUrl() {
        return this.generateShareHost() + StringUtils.formatWitUSLocal((String)SHARE_PAGE_PATH, (Object[])new Object[]{this.mImageUrl, this.mUserInfoKS.uid, this.getShareTitle(true), this.getShareSubtitle(true), UriProvider.getIdc(), SystemUtils.getLangAndCountry()});
    }

    private void fetchInviteBossConfig(Context context) {
        if (this.mServiceManager != null && this.mServiceManager.getService(IIntlShareService.class) != null) {
            Map shareConfig = ((IIntlShareService)this.mServiceManager.getService(IIntlShareService.class)).getShareConfigByPage("drawer_invite_friend");
            if (!FP.empty((Map)shareConfig)) {
                String cardBg = (String)shareConfig.get(DRAWER_INVITE_FRIEND_CARD_BG);
                this.generateImage(cardBg, context);
            } else {
                this.generateImage("", context);
            }
        } else {
            this.generateImage("", context);
        }
    }

    private void generateImage(final String cardBgUrl, final Context context) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT <= 19) {
                    try {
                        InviteCardModel.this.genImageReal(cardBgUrl, context);
                    }
                    catch (Exception e) {
                        FeatureLog.e((String)"FTSHAREDrawerInvite", (String)"genImageReal exception: %s", (Object[])new Object[]{e});
                    }
                } else {
                    InviteCardModel.this.genImageReal(cardBgUrl, context);
                }
            }
        });
    }

    private void genImageReal(String cardBgUrl, Context context) {
        InviteCardView inviteCardView = new InviteCardView(context, this.mChannelId);
        inviteCardView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        inviteCardView.layout(0, 0, inviteCardView.getMeasuredWidth(), inviteCardView.getMeasuredHeight());
        inviteCardView.updateCardViewUI(cardBgUrl, this.mUserInfoKS.avatar, this.mUserInfoKS.nick, this.mUserInfoKS.vid, this.mUserInfoKS.sex, this.getShareTitle(false), this.getShareSubtitle(false), new IShareCardImageFinishLoadedCallback(){

            @Override
            public void onImageFinishLoaded(String imagePath) {
                FeatureLog.i((String)"FTSHAREDrawerInvite", (String)"image save path: %s", (Object[])new Object[]{imagePath});
                InviteCardModel.this.mImagePath = imagePath;
                InviteCardModel.this.uploadImageForShare();
            }
        });
    }

    private String generateShareHost() {
        String host = SHARE_PAGE_HOST;
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        if (type == EnvSettingType.Product) {
            host = SHARE_PAGE_HOST;
        } else if (type == EnvSettingType.Test) {
            host = SHARE_PAGE_TEST_HOST;
        }
        return URLUtils.replaceHost((String)host);
    }
}

