/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.download.task;

import com.yy.appbase.http.HttpUtil;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.download.DownloadInfo;
import com.yy.hiyo.share.download.task.DownloadTaskLifecycle;
import com.yy.hiyo.share.download.task.DownloadTaskLifecycleListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DownloadTask
implements DownloadTaskLifecycle {
    private static final String TAG = "DownloadTask";
    private DownloadInfo downloadInfo;
    private String tmpFilePath;
    private List<DownloadCallback> downloadCallbackList = new ArrayList<DownloadCallback>();
    private DownloadTaskLifecycleListener taskLifecyleListener;

    public DownloadTask(DownloadInfo downloadInfo) {
        this.downloadInfo = downloadInfo;
        this.onCreate();
    }

    public void addCallback(DownloadCallback callback) {
        if (callback == null) {
            return;
        }
        this.downloadCallbackList.add(callback);
    }

    public void download() {
        MLog.info((Object)TAG, (String)"download start, %s", (Object[])new Object[]{this.downloadInfo});
        this.onStart();
        if (this.checkDownloadInfoComplete()) {
            HttpUtil.downloadFile((String)this.downloadInfo.getUrl(), (String)this.tmpFilePath, (Callback)new Callback<File>(){

                public void onResponse(Call<File> call, Response<File> response) {
                    MLog.info((Object)DownloadTask.TAG, (String)"download success, %s", (Object[])new Object[]{DownloadTask.this.downloadInfo});
                    FeatureLog.e((String)"FTQuicFileDownload", (String)("share download task success, downloadInfo = " + DownloadTask.this.downloadInfo), (Object[])new Object[0]);
                    DownloadTask.this.onDownloadResponse();
                }

                public void onFailure(Call<File> call, Throwable e) {
                    MLog.error((Object)DownloadTask.TAG, (String)"download error, %s", (Object[])new Object[]{DownloadTask.this.downloadInfo});
                    FeatureLog.e((String)"FTQuicFileDownload", (String)("share download task error e = " + e), (Object[])new Object[0]);
                    DownloadTask.this.onDownloadError();
                }
            });
        } else {
            MLog.error((Object)TAG, (String)"download error, download info incomplete", (Object[])new Object[0]);
            this.onDownloadInfoIncomplete();
        }
    }

    private boolean checkDownloadInfoComplete() {
        return this.downloadInfo != null && !FP.empty((CharSequence)this.downloadInfo.getUrl()) && !FP.empty((CharSequence)this.downloadInfo.getPath()) && !FP.empty((CharSequence)this.tmpFilePath);
    }

    private void onDownloadInfoIncomplete() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DownloadCallback callback : DownloadTask.this.downloadCallbackList) {
                    callback.onFail(DownloadTask.this.downloadInfo.getUrl());
                }
                DownloadTask.this.onFinish();
            }
        });
    }

    private void onDownloadError() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                YYFileUtils.removeFile((String)DownloadTask.this.tmpFilePath);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (DownloadCallback callback : DownloadTask.this.downloadCallbackList) {
                            callback.onFail(DownloadTask.this.downloadInfo.getUrl());
                        }
                        DownloadTask.this.onFinish();
                    }
                });
            }
        });
    }

    private void onDownloadResponse() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (YYFileUtils.isPathExist((String)DownloadTask.this.tmpFilePath)) {
                    YYFileUtils.renameFile((String)DownloadTask.this.tmpFilePath, (String)DownloadTask.this.downloadInfo.getPath());
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (DownloadCallback callback : DownloadTask.this.downloadCallbackList) {
                                callback.onSuccess(DownloadTask.this.downloadInfo.getUrl(), DownloadTask.this.downloadInfo.getPath());
                            }
                            DownloadTask.this.onFinish();
                        }
                    });
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (DownloadCallback callback : DownloadTask.this.downloadCallbackList) {
                                callback.onFail(DownloadTask.this.downloadInfo.getUrl());
                            }
                            DownloadTask.this.onFinish();
                        }
                    });
                }
            }
        });
    }

    public void setTaskLifecyleListener(DownloadTaskLifecycleListener taskLifecyleListener) {
        this.taskLifecyleListener = taskLifecyleListener;
    }

    public DownloadInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    @Override
    public void onCreate() {
        File downloadFile;
        File parent;
        if (this.downloadInfo != null && (parent = (downloadFile = new File(this.downloadInfo.getPath())).getParentFile()) != null) {
            File tmpFile = new File(parent, StringUtils.format((String)"%s_%d", (Object[])new Object[]{MD5Utils.getMD5String((String)this.downloadInfo.getUrl()), System.currentTimeMillis()}));
            this.tmpFilePath = tmpFile.getAbsolutePath();
        }
    }

    @Override
    public void onStart() {
        if (this.taskLifecyleListener != null) {
            this.taskLifecyleListener.onStart(this);
        }
    }

    @Override
    public void onFinish() {
        this.downloadCallbackList.clear();
        if (this.taskLifecyleListener != null) {
            this.taskLifecyleListener.onFinish(this);
        }
    }
}

