/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.download;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.base.common.ThreadUtils;
import com.yy.hiyo.share.download.DownloadInfo;
import com.yy.hiyo.share.download.request.DownloadRequest;
import com.yy.hiyo.share.download.task.DownloadTask;
import com.yy.hiyo.share.download.task.DownloadTaskLifecycleListener;
import java.util.HashMap;
import java.util.Map;

public class DownloadManager {
    private static final String TAG = "DownloadManager";
    private Map<DownloadInfo, DownloadTask> downloadTaskMap = new HashMap<DownloadInfo, DownloadTask>();
    private DownloadTaskLifecycleListener taskLifecycleListener;

    private DownloadManager() {
    }

    public void download(final DownloadRequest request) {
        if (!this.checkRequestComplete(request)) {
            MLog.error((Object)TAG, (String)"download request incomplete", (Object[])new Object[0]);
            return;
        }
        final String downloadPath = request.getDownloadPath();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (YYFileUtils.isPathExist((String)downloadPath)) {
                    ThreadUtils.executeInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.info((Object)DownloadManager.TAG, (String)"file exist, %s", (Object[])new Object[]{request.getDownloadInfo()});
                            DownloadCallback callback = request.getDownloadCallback();
                            if (callback != null) {
                                callback.onSuccess(request.getUrl(), downloadPath);
                            }
                        }
                    });
                } else {
                    ThreadUtils.executeInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DownloadInfo downloadInfo = request.getDownloadInfo();
                            DownloadTask task = (DownloadTask)DownloadManager.this.downloadTaskMap.get(downloadInfo);
                            if (task == null) {
                                task = new DownloadTask(downloadInfo);
                                task.setTaskLifecyleListener(DownloadManager.this.getTaskLifecycleListener());
                                task.download();
                                DownloadManager.this.downloadTaskMap.put(downloadInfo, task);
                            }
                            task.addCallback(request.getDownloadCallback());
                        }
                    });
                }
            }
        });
    }

    private boolean checkRequestComplete(DownloadRequest request) {
        return request != null && !FP.empty((CharSequence)request.getUrl()) && !FP.empty((CharSequence)request.getDownloadPath());
    }

    private DownloadTaskLifecycleListener getTaskLifecycleListener() {
        if (this.taskLifecycleListener == null) {
            this.taskLifecycleListener = new DownloadTaskLifecycleListener(){

                @Override
                public void onStart(DownloadTask downloadTask) {
                }

                @Override
                public void onFinish(DownloadTask downloadTask) {
                    DownloadInfo downloadInfo = downloadTask.getDownloadInfo();
                    DownloadManager.this.downloadTaskMap.remove(downloadInfo);
                }
            };
        }
        return this.taskLifecycleListener;
    }

    public static DownloadManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static DownloadManager INSTANCE = new DownloadManager();

        private InstanceHolder() {
        }
    }
}

