/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.dataprovider;

import android.graphics.Bitmap;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.IShareViewProvider;
import com.yy.hiyo.share.base.OnViewReadyCallback;
import com.yy.hiyo.share.base.dataprovider.DataCallback;
import com.yy.hiyo.share.base.dataprovider.IImageLinkDataProvider;
import com.yy.hiyo.share.dataprovider.ShareDataProvider;
import com.yy.hiyo.share.dir.ShareDirManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ImageLinkDataProvider
extends ShareDataProvider
implements IImageLinkDataProvider {
    private static final String TAG = "ImageLinkDataProvider";
    private static final String IMAGE_SAVE_NAME = "share_image.jpg";
    private static final String DEFAULT_IMG_PARAM_KEY = "img";
    private String mKey;
    private IOOSService mOOSService;
    private String mBaseText;
    private String mBaseUrl;
    private Map<String, String> mUrlParams;
    private IShareViewProvider mShareViewProvider;
    private String mImgParamKey = "img";

    public ImageLinkDataProvider(String key, IOOSService oosService) {
        this.mKey = key;
        this.mOOSService = oosService;
    }

    public void setBaseText(String text) {
        this.mBaseText = text;
        this.reset();
    }

    public void setBaseUrl(String url) {
        this.mBaseUrl = url;
        this.reset();
    }

    public void setUrlParams(Map<String, String> urlParams) {
        this.mUrlParams = urlParams;
        this.reset();
    }

    public void addUrlParam(String key, String value) {
        if (this.mUrlParams == null) {
            this.mUrlParams = new HashMap<String, String>();
        }
        this.mUrlParams.put(key, value);
        this.reset();
    }

    public void setShareViewProvider(IShareViewProvider shareViewProvider) {
        this.mShareViewProvider = shareViewProvider;
        this.reset();
    }

    public void setImgParamKey(String imgParamKey) {
        this.mImgParamKey = imgParamKey;
        this.reset();
    }

    @Override
    protected void buildImage(final DataCallback<String> callback) {
        if (this.mShareViewProvider == null) {
            callback.onData(null);
            return;
        }
        this.mShareViewProvider.waitViewReady(new OnViewReadyCallback(){

            public void onViewReady(final View view2) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Bitmap bmp = ViewImage.getViewBitmap((View)view2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                            String dirPath = ShareDirManager.getInstance().getShareTmpDir().getAbsolutePath();
                            String imgName = StringUtils.format((String)"%s_%s", (Object[])new Object[]{ImageLinkDataProvider.this.mKey, ImageLinkDataProvider.IMAGE_SAVE_NAME});
                            String expectPath = dirPath + File.separator + imgName;
                            if (YYFileUtils.isPathExist((String)expectPath)) {
                                YYFileUtils.removeFile((String)expectPath);
                            }
                            String imgPath = ViewImage.saveImgToLocal((Bitmap)bmp, (String)imgName, (String)dirPath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                            callback.onData((Object)imgPath);
                        }
                        catch (Exception e) {
                            MLog.error((Object)ImageLinkDataProvider.TAG, (String)("build image error, " + e.getMessage()), (Object[])new Object[0]);
                            callback.onData(null);
                        }
                    }
                });
            }
        });
    }

    @Override
    protected void buildUrl(final DataCallback<String> callback) {
        if (FP.empty((CharSequence)this.mBaseUrl)) {
            callback.onData(null);
            return;
        }
        String imagePath = this.getShareBundle().getImagePath();
        if (!FP.empty((CharSequence)imagePath) && YYFileUtils.isFileExisted((String)imagePath)) {
            if (this.mOOSService != null) {
                String key = StringUtils.format((String)"%s_%d_%d_%s", (Object[])new Object[]{this.mKey, AccountUtil.getUid(), System.currentTimeMillis(), IMAGE_SAVE_NAME});
                this.mOOSService.uploadFile(key, imagePath, new IUploadObjectCallBack(){

                    public void onSuccess(UploadObjectRequest request) {
                        String imgUrl = request.mUrl;
                        ImageLinkDataProvider.this.buildUrlWithImgUrl(imgUrl, (DataCallback<String>)callback);
                    }

                    public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                        ImageLinkDataProvider.this.buildUrlWithImgUrl(null, (DataCallback<String>)callback);
                        MLog.error((Object)ImageLinkDataProvider.TAG, (String)"build url upload image fail, code = %d, msg = %s", (Object[])new Object[]{errorCode, exception.getMessage()});
                    }
                });
            } else {
                callback.onData(null);
            }
        } else {
            callback.onData(null);
        }
    }

    private void buildUrlWithImgUrl(String imgUrl, final DataCallback<String> callback) {
        StringBuilder originalUrlBuilder = new StringBuilder();
        originalUrlBuilder.append(this.mBaseUrl);
        originalUrlBuilder.append("?");
        originalUrlBuilder.append(UriProvider.appendCommonWebUrlParams());
        if (!FP.empty((CharSequence)imgUrl)) {
            originalUrlBuilder.append(this.createParamString(this.mImgParamKey, URLUtils.encode((String)imgUrl)));
        }
        if (this.mUrlParams != null) {
            for (Map.Entry<String, String> entry : this.mUrlParams.entrySet()) {
                originalUrlBuilder.append(this.createParamString(entry.getKey(), entry.getValue()));
            }
        }
        String originalUrl = originalUrlBuilder.toString();
        ShortUrlUtil.getShortUrl((String)originalUrl, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                callback.onData((Object)shortUrl);
            }

            public void onError(String input, int code, String msg) {
                callback.onData((Object)input);
                MLog.error((Object)ImageLinkDataProvider.TAG, (String)"gen short url error, code = %d, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    private String createParamString(String key, String value) {
        return String.format("&%s=%s", key, value);
    }

    @Override
    protected void buildText(DataCallback<String> callback) {
        if (FP.empty((CharSequence)this.mBaseText)) {
            callback.onData(null);
            return;
        }
        String text = this.mBaseText + " " + this.getShareBundle().getUrl();
        callback.onData((Object)text);
    }

    @Override
    protected ShareDataProvider.BuildTaskType[] getOrderedBuildTasks() {
        return new ShareDataProvider.BuildTaskType[]{ShareDataProvider.BuildTaskType.TASK_IMAGE, ShareDataProvider.BuildTaskType.TASK_URL, ShareDataProvider.BuildTaskType.TASK_TEXT};
    }
}

