/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.dataprovider;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.ShareConfig;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.share.DR;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.base.dataprovider.DataCallback;
import com.yy.hiyo.share.dataprovider.ShareDataProvider;
import com.yy.hiyo.share.download.DownloadManager;
import com.yy.hiyo.share.download.request.ImageDownloadRequest;
import org.jetbrains.annotations.NotNull;

public class DefaultShareDataProvider
extends ShareDataProvider {
    private static final String DEFAULT_URL = "https://www.ihago.net/m/download.html";
    private static final String DEFAULT_TITLE = ResourceUtils.getString((int)R.string.share_default_title);
    private static final String DEFAULT_TEXT = ResourceUtils.getString((int)R.string.share_default_content);

    @Override
    protected void buildTitle(DataCallback<String> callback) {
        callback.onData((Object)DEFAULT_TITLE);
    }

    @Override
    protected void buildText(DataCallback<String> callback) {
        String text = DEFAULT_TEXT;
        ShareConfig.ShareConfigData shareConfigData = this.getShareConfig();
        if (shareConfigData != null && !FP.empty((CharSequence)shareConfigData.getContent())) {
            text = shareConfigData.getContent();
        }
        callback.onData((Object)text);
    }

    @Override
    protected void buildImage(final DataCallback<String> callback) {
        ShareConfig.ShareConfigData shareConfigData = this.getShareConfig();
        if (shareConfigData != null && !FP.empty((CharSequence)shareConfigData.getImageUrl())) {
            String shareImageUrl = shareConfigData.getImageUrl();
            ImageDownloadRequest request = ImageDownloadRequest.builder().url(shareImageUrl).callback(new DownloadCallback(){

                public void onSuccess(String url, String path) {
                    callback.onData((Object)path);
                }

                public void onFail(String url) {
                    callback.onData(null);
                }
            }).build();
            YYTaskExecutor.execute(() -> DownloadManager.getInstance().download(request));
        } else {
            DyResLoader.INSTANCE.getResFilePath(DR.default_share_img, new IDRCallback(){

                public void onSucceed(@NotNull String filePath) {
                    callback.onData((Object)filePath);
                }

                public void onFailed(@NotNull String msg) {
                    callback.onData(null);
                }
            });
        }
    }

    @Override
    protected void buildUrl(DataCallback<String> callback) {
        String url = DEFAULT_URL;
        ShareConfig.ShareConfigData shareConfigData = this.getShareConfig();
        if (shareConfigData != null && !FP.empty((CharSequence)shareConfigData.getDownloadUrl())) {
            url = shareConfigData.getDownloadUrl();
        }
        callback.onData((Object)url);
    }

    private ShareConfig.ShareConfigData getShareConfig() {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.SHARE_CONFIG);
        if (config != null && config instanceof ShareConfig) {
            return ((ShareConfig)config).getShareConfigByLang(SystemUtils.getLang());
        }
        return null;
    }
}

