/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share;

import android.content.DialogInterface;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.share.DefaultShareHelper;
import com.yy.hiyo.share.ShareChannelManager;
import com.yy.hiyo.share.ShareDelegate;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.IShareDialogViewProvider;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.IShareResultCallback;
import com.yy.hiyo.share.base.IShareTemplate;
import com.yy.hiyo.share.base.IStartShareCallback;
import com.yy.hiyo.share.base.ShareBundle;
import com.yy.hiyo.share.base.ShareCardData;
import com.yy.hiyo.share.base.ShareItemClickListener;
import com.yy.hiyo.share.base.bean.SharePersonBean;
import com.yy.hiyo.share.base.dataprovider.IImageLinkDataProvider;
import com.yy.hiyo.share.dataprovider.ImageLinkDataProvider;
import com.yy.hiyo.share.dir.ShareDirManager;
import com.yy.hiyo.share.download.DownloadManager;
import com.yy.hiyo.share.download.request.ImageDownloadRequest;
import com.yy.hiyo.share.report.ShareFrom;
import com.yy.hiyo.share.report.ShareReporter;
import com.yy.hiyo.share.ui.CenterDialog;
import com.yy.hiyo.share.ui.ShareCardPage;
import com.yy.hiyo.share.ui.ShareDialog;
import com.yy.hiyo.share.ui.ShareDialogWithRecentChat;
import com.yy.socialplatformbase.callback.IShareDataBuilder;
import com.yy.socialplatformbase.data.ShareData;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ShareService
extends DefaultController
implements IIntlShareService {
    private ShareDelegate shareDelegate;
    private ShareChannelManager shareChannelManager;
    private DefaultShareHelper defaultShareHelper;
    private HashMap<String, String> lastShareInfo = new HashMap();

    public ShareService(Environment env) {
        super(env);
        this.shareChannelManager = new ShareChannelManager();
        this.shareDelegate = new ShareDelegate(env.getContext());
        this.defaultShareHelper = new DefaultShareHelper();
    }

    public boolean isShowDialog() {
        return this.mDialogLinkManager.isDialogShowing();
    }

    public List<BaseShareChannel> getChannelsByPage(ISharePage sharePage) {
        return this.shareChannelManager.getChannelsByPage(sharePage);
    }

    public List<BaseShareChannel> getVietnamInviteFriendChannels(ISharePage sharePage) {
        List<BaseShareChannel> channelList = this.shareChannelManager.getVitenamInviteFriendChannels();
        if (!FP.empty(channelList)) {
            return channelList;
        }
        return this.getChannelsByPage(sharePage);
    }

    public Map<String, String> getShareConfigByPage(String key) {
        return this.shareDelegate.getShareSetting(key);
    }

    public void showShareBottomDialog(ISharePage sharePage, ShareItemClickListener itemClickListener) {
        this.showShareBottomDialog(sharePage, itemClickListener, null);
    }

    public void showShareBottomDialog(ISharePage sharePage, ShareItemClickListener itemClickListener, DialogInterface.OnDismissListener dismissListener) {
        List<BaseShareChannel> channels = this.shareChannelManager.getChannelsByPage(sharePage);
        ShareDialog shareDialog = new ShareDialog(channels);
        shareDialog.setItemClickListener(itemClickListener);
        shareDialog.setOnDismissListener(dismissListener);
        this.mDialogLinkManager.showDialog((BaseDialog)shareDialog);
    }

    public void showShareBottomDialog(ISharePage sharePage, IShareDataBuilder dataBuilder) {
        List<BaseShareChannel> channels = this.shareChannelManager.getChannelsByPage(sharePage);
        ShareDialogWithRecentChat shareDialog = new ShareDialogWithRecentChat(sharePage, channels, this, dataBuilder);
        this.mDialogLinkManager.showDialog((BaseDialog)shareDialog);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20036879").put("function_id", "system_share_show"));
    }

    public void showShareCenterDialog(IShareDialogViewProvider viewProvider, DialogInterface.OnDismissListener dismissListener) {
        if (viewProvider == null) {
            return;
        }
        CenterDialog centerDialog = new CenterDialog();
        centerDialog.setContentView(viewProvider.getContentView());
        centerDialog.setShareImage(viewProvider.getShareImage());
        centerDialog.setOnDismissListener(dismissListener);
        centerDialog.setCanceledOnTouchOutside(true);
        this.mDialogLinkManager.showDialog((BaseDialog)centerDialog);
    }

    public void showShareCardDialog(ShareCardData data, IStartShareCallback callback, DialogInterface.OnDismissListener dismissListener) {
        ShareCardPage mSharePage = new ShareCardPage(this.mContext, callback);
        mSharePage.updateProfileInfo(data);
        CenterDialog centerDialog = new CenterDialog();
        centerDialog.setContentView(mSharePage.getContentView());
        centerDialog.setOnDismissListener(dismissListener);
        centerDialog.setCanceledOnTouchOutside(true);
        this.mDialogLinkManager.showDialog((BaseDialog)centerDialog);
    }

    public void closeShareDialog() {
        if (this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    public boolean checkAppInstalled(int channelId) {
        return this.shareDelegate.checkAppInstall(channelId);
    }

    public boolean checkAppNeedInstalledOrToast(int channelId) {
        return this.shareDelegate.needAppInstallOrToast(channelId);
    }

    public void share(int channelId, ShareData shareData, @Nullable IShareResultCallback callback) {
        FeatureLog.i((String)"FTSHAREBase", (String)"share, channelId:%d, %s", (Object[])new Object[]{channelId, shareData});
        this.shareDelegate.share(channelId, shareData, callback);
        if (!FP.empty((CharSequence)shareData.getGotoUrl())) {
            ShareReporter.INSTANCE.linkShare(shareData.getGotoUrl(), ShareFrom.FROM_APP);
        }
    }

    public void share(int channelId, ShareData shareData) {
        this.share(channelId, shareData, null);
    }

    public void share(int channelId, ShareBundle shareBundle) {
        this.share(channelId, shareBundle, (IShareResultCallback)null);
    }

    public void share(int channelId, ShareBundle shareBundle, @Nullable IShareResultCallback callback) {
        if (shareBundle == null) {
            FeatureLog.e((String)"FTSHAREBase", (String)"share error, shareBundle is null", (Object[])new Object[0]);
            return;
        }
        IShareTemplate shareTemplate = this.defaultShareHelper.getDefaultShareTemplate();
        ShareData shareData = shareTemplate.createShareData(channelId, shareBundle);
        this.share(channelId, shareData, callback);
    }

    public void share(int channelId, ShareBundle shareBundle, IShareTemplate shareTemplate) {
        if (shareBundle == null) {
            FeatureLog.e((String)"FTSHAREBase", (String)"share error, shareBundle is null", (Object[])new Object[0]);
            return;
        }
        if (shareTemplate == null) {
            FeatureLog.e((String)"FTSHAREBase", (String)"share error, shareTemplate is null", (Object[])new Object[0]);
            return;
        }
        ShareData shareData = shareTemplate.createShareData(channelId, shareBundle);
        this.share(channelId, shareData);
    }

    public void shareDefault(final int channelId, Map<String, String> shareUrlArgs) {
        this.defaultShareHelper.buildShareData(channelId, shareUrlArgs, new DefaultShareHelper.OnShareDataCallback(){

            @Override
            public void onShareDataReady(ShareData shareData) {
                ShareService.this.share(channelId, shareData);
            }
        });
    }

    public void webShare(int channelId, String title, String content, String image, String webUrl) {
        this.shareDelegate.webShare(channelId, title, content, image, webUrl);
        if (!FP.empty((CharSequence)webUrl)) {
            ShareReporter.INSTANCE.linkShare(webUrl, ShareFrom.FROM_H5);
        }
    }

    public void commonWebShare(int channelId, ShareData shareData, IShareResultCallback callback) {
        this.shareDelegate.commonWebShare(channelId, shareData, callback);
        if (!FP.empty((CharSequence)shareData.getGotoUrl())) {
            ShareReporter.INSTANCE.linkShare(shareData.getGotoUrl(), ShareFrom.FROM_H5);
        }
    }

    public void showNativeShareDialog(SharePersonBean sharePersonBean, ShareData shareData, IShareResultCallback callback) {
        this.shareDelegate.showNativeShareDialog(sharePersonBean, shareData, callback);
    }

    public void preload() {
        this.defaultShareHelper.preload();
    }

    public void downloadShareImage(String imageUrl, final DownloadCallback callback) {
        ImageDownloadRequest request = ImageDownloadRequest.builder().url(imageUrl).callback(new DownloadCallback(){

            public void onSuccess(String url, String path) {
                if (callback != null) {
                    callback.onSuccess(url, path);
                }
            }

            public void onFail(String url) {
                if (callback != null) {
                    callback.onFail(url);
                }
            }
        }).build();
        DownloadManager.getInstance().download(request);
    }

    public IImageLinkDataProvider createAImageLinkDataProvider(String key) {
        return new ImageLinkDataProvider(key, (IOOSService)ServiceManagerProxy.getService(IOOSService.class));
    }

    public String getShareTmpDir() {
        return ShareDirManager.getInstance().getShareTmpDir().getAbsolutePath();
    }

    public String getLashShareLocalPath(String key) {
        if (this.lastShareInfo != null && this.lastShareInfo.containsKey(key)) {
            return this.lastShareInfo.get(key);
        }
        return null;
    }

    public String saveLashShareLocalPath(String key, String value) {
        if (this.lastShareInfo != null) {
            if (this.lastShareInfo.size() > 3) {
                this.lastShareInfo.clear();
            }
            this.lastShareInfo.put(key, value);
        }
        return null;
    }

    public void shareReport(String url) {
        if (!FP.empty((CharSequence)url)) {
            ShareReporter.INSTANCE.linkShare(url, ShareFrom.FROM_APP);
        }
    }

    public ShareData createShareData(int channel, ShareBundle shareBundle) {
        IShareTemplate shareTemplate = this.defaultShareHelper.getDefaultShareTemplate();
        return shareTemplate.createShareData(channel, shareBundle);
    }
}

