/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.common.Callback;
import com.yy.appbase.hagoactivity.ActivityConstant;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.appbase.unifyconfig.config.ShareConfig;
import com.yy.base.HagoFileProvider;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ClipboardUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.bbs.BBSNotificationDef;
import com.yy.hiyo.bbs.PublishNotificationObj;
import com.yy.hiyo.bbs.base.PostDefine;
import com.yy.hiyo.bbs.base.bean.BBSConfig;
import com.yy.hiyo.bbs.base.bean.LiveRoomPostBean;
import com.yy.hiyo.bbs.base.bean.NormalRoomPostBean;
import com.yy.hiyo.bbs.base.bean.postinfo.BasePostInfo;
import com.yy.hiyo.bbs.base.service.IBbsService;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.ShareChannel;
import com.yy.hiyo.share.ShareMsgDef;
import com.yy.hiyo.share.ShowShareNativeDialogHelper;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.IShareResultCallback;
import com.yy.hiyo.share.base.bean.SharePersonBean;
import com.yy.hiyo.share.download.DownloadManager;
import com.yy.hiyo.share.download.request.ImageDownloadRequest;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.PlatformMsgDef;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IShareCallBack;
import com.yy.socialplatformbase.data.HagoShareData;
import com.yy.socialplatformbase.data.ShareData;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ShareDelegate {
    private static final String TAG = "ShareDelegate";
    private Context context;
    private final INotify shareToPostNotify = notification -> {
        PublishNotificationObj obj = (PublishNotificationObj)notification.extObj;
        if (obj.getPostAttachPage() == 30 && obj.getState() == 2) {
            String cid;
            BasePostInfo info = obj.getPostInfo();
            if (info != null && !TextUtils.isEmpty((CharSequence)(cid = info.getShareChannelId()))) {
                SettingFlags.setLongValue((String)("key_share_room_timestamp_" + cid), (long)System.currentTimeMillis());
            }
            ToastUtils.showToast((Context)this.context, (int)R.string.title_bbs_share_success);
        }
    };

    public ShareDelegate(Context context) {
        this.context = context;
    }

    public boolean needAppInstallOrToast(int channelId) {
        if (channelId == -1) {
            return false;
        }
        if (channelId == 10 || channelId == 5 || channelId == 9) {
            return true;
        }
        if (channelId == 6) {
            if (ThirdPartyPlatformHelper.appInstalled((Context)this.context, (String)"com.facebook.orca")) {
                return true;
            }
            this.appUninstallTips(this.context, ResourceUtils.getString((int)R.string.share_platform_messenger));
            return false;
        }
        AbsPlatformAdapter adapter2 = ThirdPartyPlatformHelper.getInstance().getPlatform(this.getPlatformId(channelId));
        if (adapter2 != null) {
            boolean result = adapter2.isPlatformInstall();
            if (!result) {
                this.appUninstallTips(this.context, adapter2.getPlatformAppName());
            }
            return result;
        }
        return false;
    }

    public boolean checkAppInstall(int channelId) {
        if (channelId == -1) {
            return false;
        }
        if (channelId == 10) {
            return true;
        }
        if (channelId == 6) {
            return ThirdPartyPlatformHelper.appInstalled((Context)this.context, (String)"com.facebook.orca");
        }
        AbsPlatformAdapter adapter2 = ThirdPartyPlatformHelper.getInstance().getPlatform(this.getPlatformId(channelId));
        if (adapter2 != null) {
            return adapter2.isPlatformInstall();
        }
        return false;
    }

    public void share(int channelId, ShareData shareData, final IShareResultCallback callback) {
        if (channelId == 10) {
            String copyContent = shareData.getText();
            ClipboardUtils.copyLink((String)copyContent);
            ToastUtils.showToast((Context)this.context, (String)ResourceUtils.getString((int)R.string.tips_copylink_ok), (int)0);
            if (callback != null) {
                callback.onResult(1, "success");
            }
            return;
        }
        if (channelId == 0) {
            this.downloadImgOnNeed(shareData, (Callback<ShareData>)((Callback)data -> this.shareOthers((ShareData)data, callback)));
            return;
        }
        if (channelId == 13) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_SHARE_SELECT_PAGE;
            msg.obj = callback;
            Bundle bundle = new Bundle();
            bundle.putParcelable("share_data", (Parcelable)shareData);
            msg.setData(bundle);
            MsgDispatcher.getInstance().sendMessage(msg);
            return;
        }
        if (channelId == 16) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_SHARE_NATIVE_DIRECTLY;
            msg.obj = callback;
            Bundle bundle = new Bundle();
            bundle.putParcelable("share_data", (Parcelable)shareData);
            msg.setData(bundle);
            MsgDispatcher.getInstance().sendMessage(msg);
            return;
        }
        if (channelId == 14) {
            Message msg = Message.obtain();
            msg.what = ShareMsgDef.MSG_SHOW_BBS_SHARE_DIALOG;
            msg.obj = shareData;
            MsgDispatcher.getInstance().sendMessage(msg);
            return;
        }
        if (channelId == 17) {
            Object roomPostBean = null;
            HagoShareData hagoShareData = shareData.getHagoShareData();
            if (hagoShareData != null) {
                BBSConfig bbsConfig;
                String cid = hagoShareData.getId();
                String gid = hagoShareData.getPluginId();
                if (cid == null || gid == null) {
                    MLog.info((Object)TAG, (String)"cid or gid is null", (Object[])new Object[0]);
                    return;
                }
                HiidoEvent event = HiidoEvent.obtain().eventId("20028823").put("function_id", "channel_post_share_click").put("room_id", cid).put("gid", gid);
                HiidoStatis.reportEvent((HiidoEvent)event);
                long shareTimestamp = SettingFlags.getLongValue((String)("key_share_room_timestamp_" + cid), (long)0L);
                long retryMin = 60L;
                IBbsService bbsService = (IBbsService)ServiceManagerProxy.getService(IBbsService.class);
                if (bbsService != null && (bbsConfig = (BBSConfig)bbsService.getBbsConfig().getValue()) != null) {
                    retryMin = bbsConfig.getChannelShareIntervalSecond() / 60L;
                }
                if (shareTimestamp + retryMin * 60L * 1000L >= System.currentTimeMillis()) {
                    ToastUtils.showToast((Context)this.context, (String)ResourceUtils.getString((int)R.string.share_room_to_post_to_frequent_try_after_one_hour, (Object[])new Object[]{retryMin}), (int)0);
                    return;
                }
                roomPostBean = "radio".equals(gid) ? new LiveRoomPostBean(Objects.requireNonNull(hagoShareData.getId()), hagoShareData.getChannelName(), gid, hagoShareData.getChannelOwnerId(), hagoShareData.getImage() == null ? "" : hagoShareData.getImage()) : new NormalRoomPostBean(Objects.requireNonNull(hagoShareData.getId()), hagoShareData.getChannelName(), gid, hagoShareData.getChannelMemberList(), hagoShareData.getChannelMemberSize());
            }
            Message msg = Message.obtain();
            HashMap<String, List<Object>> param = new HashMap<String, List<Object>>();
            param.put("types", Collections.singletonList(PostDefine.PublishType.TEXT));
            param.put("roomPostBean", (List<Object>)roomPostBean);
            msg.what = AppbaseMsgDef.MSG_OPEN_PUBLISH_WINDOW;
            msg.arg1 = 30;
            msg.obj = param;
            MsgDispatcher.getInstance().sendMessage(msg);
            NotificationCenter.getGlobalInstance().register(BBSNotificationDef.INSTANCE.getBBS_PUBLISH_NOTIFY(), this.shareToPostNotify);
            return;
        }
        if (channelId == 6) {
            if (!ThirdPartyPlatformHelper.appInstalled((Context)this.context, (String)"com.facebook.orca")) {
                this.appUninstallTips(this.context, ResourceUtils.getString((int)R.string.share_platform_messenger));
                ActivityConstant.setIsActivityShare((boolean)false);
                if (callback != null) {
                    callback.onResult(3, "uninstall");
                }
                return;
            }
            if (shareData.getTo() != 1) {
                shareData = ShareData.builder((ShareData)shareData).to(1).build();
            }
        }
        final AbsPlatformAdapter adapter2 = ThirdPartyPlatformHelper.getInstance().getPlatform(this.getPlatformId(channelId));
        if (!(channelId == 9 || channelId == 5 || channelId == 6 || adapter2 != null && adapter2.isPlatformInstall())) {
            String platformName = "Unknown";
            if (adapter2 == null) {
                ShareChannel channel = ShareChannel.createChannelById(channelId);
                if (channel.getNameResId() > 0) {
                    platformName = ResourceUtils.getString((int)channel.getNameResId());
                }
            } else {
                platformName = adapter2.getPlatformAppName();
            }
            this.appUninstallTips(this.context, platformName);
            ActivityConstant.setIsActivityShare((boolean)false);
            if (callback != null) {
                callback.onResult(3, "uninstall");
            }
            return;
        }
        final IShareCallBack shareCallBack = new IShareCallBack(){

            public void onShareSuccess(ShareData data) {
                if (callback != null) {
                    callback.onResult(1, "success");
                }
            }

            public void onShareCanceled(ShareData data) {
                if (callback != null) {
                    callback.onResult(2, "cancel");
                }
            }

            public void onShareError(ShareData data, Exception e) {
                if (callback != null) {
                    callback.onResult(0, e == null ? "unknown fail" : e.toString());
                }
            }
        };
        if (shareData.isSystemShare && shareData.getType() == 1 && !TextUtils.isEmpty((CharSequence)shareData.getImgPath()) && shareData.getImgPath() != null && shareData.getImgPath().startsWith("http")) {
            final ShareData originalShareData = shareData;
            ImageDownloadRequest request = ImageDownloadRequest.builder().url(shareData.getImgPath()).callback(new DownloadCallback(){

                public void onSuccess(String url, String path) {
                    ShareData localImgShareData = ShareData.builder((ShareData)originalShareData).imgPath(path).build();
                    ShareDelegate.this.realShare(adapter2, localImgShareData, shareCallBack);
                }

                public void onFail(String url) {
                    ShareDelegate.this.realShare(adapter2, originalShareData, shareCallBack);
                }
            }).build();
            DownloadManager.getInstance().download(request);
        } else {
            this.realShare(adapter2, shareData, shareCallBack);
        }
    }

    private void realShare(AbsPlatformAdapter adapter2, ShareData shareData, IShareCallBack callBack) {
        if (adapter2.getId() == 5) {
            Message message = Message.obtain();
            message.what = PlatformMsgDef.MSG_DISABLE_MESSENGER_SHARE;
            if (shareData.getTo() == 1) {
                CommonConfigData configData;
                boolean disableSdkMessengerShare = false;
                AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
                if (config instanceof CommonConfig && (configData = ((CommonConfig)config).getData()) != null) {
                    disableSdkMessengerShare = configData.disableSdkMessengerShare;
                }
                if (disableSdkMessengerShare) {
                    this.downloadImgOnNeed(shareData, (Callback<ShareData>)((Callback)data -> {
                        message.obj = true;
                        adapter2.handleMessageSync(message);
                        adapter2.share(data, callBack);
                    }));
                } else {
                    message.obj = false;
                    adapter2.handleMessageSync(message);
                    adapter2.share(shareData, callBack);
                }
            } else {
                message.obj = false;
                adapter2.handleMessageSync(message);
                adapter2.share(shareData, callBack);
            }
        } else {
            adapter2.share(shareData, callBack);
        }
    }

    public void share(int channelId, ShareData shareData) {
        this.share(channelId, shareData, null);
    }

    private void appUninstallTips(Context ctx, String name) {
        ToastUtils.showToast((Context)ctx, (String)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.app_uninstall_ips), (Object[])new Object[]{name}), (int)0);
    }

    public void shareOthers(ShareData shareData, IShareResultCallback callback) {
        block14: {
            if (shareData == null) {
                if (callback != null) {
                    callback.onResult(0, "shareData is null");
                }
                return;
            }
            Intent sendIntent = new Intent();
            sendIntent.setAction("android.intent.action.SEND");
            if (TextUtils.isEmpty((CharSequence)shareData.getImgPath()) && TextUtils.isEmpty((CharSequence)shareData.getVideoPath())) {
                sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                sendIntent.setType("text/*");
            } else {
                try {
                    File file = null;
                    file = shareData.getType() == 3 && !TextUtils.isEmpty((CharSequence)shareData.getVideoPath()) ? new File(shareData.getVideoPath()) : new File(shareData.getImgPath());
                    Uri imageUri = null;
                    if (Build.VERSION.SDK_INT >= 24) {
                        imageUri = HagoFileProvider.getUriForFile((Context)this.context, (String)(this.context.getPackageName() + ".fileprovider"), (File)file);
                        IIntlShareService shareService = (IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class);
                        if (shareService != null) {
                            shareService.saveLashShareLocalPath(imageUri.toString(), file.getAbsolutePath());
                        }
                    } else {
                        imageUri = Uri.fromFile((File)file);
                    }
                    sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imageUri);
                    sendIntent.setType("image/*");
                }
                catch (Exception e) {
                    MLog.info((Object)TAG, (String)("generate uri exception\uff1a" + e.toString()), (Object[])new Object[0]);
                    sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    sendIntent.setType("text/*");
                }
            }
            try {
                Intent chooser = Intent.createChooser((Intent)sendIntent, (CharSequence)ResourceUtils.getString((int)R.string.share_chooser_title));
                sendIntent.setFlags(0x10000001);
                if (sendIntent.resolveActivity(this.context.getPackageManager()) != null) {
                    if (!(this.context instanceof Activity)) {
                        chooser.addFlags(0x10000000);
                    }
                    this.context.startActivity(chooser);
                }
                if (callback != null) {
                    callback.onResult(1, "share to Other success");
                }
            }
            catch (Exception e) {
                MLog.info((Object)TAG, (String)("shareOthers exception\uff1a" + e.toString()), (Object[])new Object[0]);
                if (callback == null) break block14;
                callback.onResult(0, e.toString());
            }
        }
    }

    private void downloadImgOnNeed(final ShareData shareData, final Callback<ShareData> next) {
        if (shareData.getImgPath() != null && shareData.getImgPath().startsWith("http") && shareData.getType() == 1) {
            ImageDownloadRequest request = ImageDownloadRequest.builder().url(shareData.getImgPath()).callback(new DownloadCallback(){

                public void onSuccess(String url, String path) {
                    ShareData localImgShareData = ShareData.builder((ShareData)shareData).imgPath(path).build();
                    next.onResponse((Object)localImgShareData);
                }

                public void onFail(String url) {
                    next.onResponse((Object)shareData);
                }
            }).build();
            DownloadManager.getInstance().download(request);
        } else {
            next.onResponse((Object)shareData);
        }
    }

    private int getPlatformId(int channelId) {
        int platformId = 5;
        switch (channelId) {
            case 5: 
            case 6: {
                platformId = 5;
                break;
            }
            case 7: {
                platformId = 14;
                break;
            }
            case 1: {
                platformId = 1;
                break;
            }
            case 2: {
                platformId = 2;
                break;
            }
            case 3: {
                platformId = 3;
                break;
            }
            case 9: {
                platformId = 8;
                break;
            }
            case 11: {
                platformId = 9;
                break;
            }
        }
        return platformId;
    }

    public void webShare(int channelId, String title, String content, String image, String webUrl) {
        ActivityConstant.setIsActivityShare((boolean)true);
        ShareData.Builder shareDataBuilder = ShareData.builder();
        shareDataBuilder.title(title);
        shareDataBuilder.gotoUrl(webUrl);
        shareDataBuilder.imgPath(image);
        shareDataBuilder.text(content);
        switch (channelId) {
            case 1: {
                shareDataBuilder.systemShare(true);
                this.share(2, shareDataBuilder.build());
                break;
            }
            case 3: {
                shareDataBuilder.type(2);
                shareDataBuilder.to(2);
                this.share(5, shareDataBuilder.build());
                break;
            }
            case 4: {
                shareDataBuilder.systemShare(true);
                shareDataBuilder.to(1);
                shareDataBuilder.type(0);
                this.share(1, shareDataBuilder.build());
                break;
            }
            case 5: {
                shareDataBuilder.to(1);
                shareDataBuilder.type(2);
                this.share(6, shareDataBuilder.build());
                break;
            }
        }
    }

    public void commonWebShare(int channelId, ShareData shareData, IShareResultCallback callback) {
        this.share(channelId, shareData, callback);
    }

    public void showNativeShareDialog(SharePersonBean sharePersonBean, ShareData shareData, IShareResultCallback callback) {
        ShowShareNativeDialogHelper.INSTANCE.showNativeShareDialog(this.context, sharePersonBean, shareData, callback);
    }

    @Nullable
    public ShareConfig.ShareConfigData getConfigByLang(@NonNull String lang) {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.SHARE_CONFIG);
        if (config != null && config instanceof ShareConfig && StringUtils.isNotEmpty((String)lang)) {
            return ((ShareConfig)config).getShareConfigByLang(lang);
        }
        return null;
    }

    @Nullable
    public ShareConfig.ShareConfigData getConfig() {
        return this.getConfigByLang(SystemUtils.getLang());
    }

    public Map<String, String> getShareSetting(String key) {
        ShareConfig.ShareConfigData shareConfigData = this.getConfig();
        if (shareConfigData == null) {
            return null;
        }
        return shareConfigData.getExtByKey(key);
    }
}

