/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.ShareChannelConfig;
import com.yy.appbase.unifyconfig.config.VietnamInviteFriendConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.hiyo.share.ShareChannel;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.hiyo.share.channelconfig.ConfigShareChannelConfig;
import com.yy.hiyo.share.channelconfig.DefaultShareChannelConfig;
import com.yy.hiyo.share.channelconfig.IShareChannelConfig;
import com.yy.hiyo.share.channelconfig.RussianShareChannelConfig;
import com.yy.hiyo.share.channelconfig.VietnameseShareChannelConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ShareChannelManager {
    private static final String TAG = "ShareChannelManager";
    private IShareChannelConfig mChannelConfig;

    private IShareChannelConfig getChannelConfig() {
        if (this.mChannelConfig == null) {
            IShareChannelConfig configChannelConfig = this.getConfigChannelConfig();
            this.mChannelConfig = configChannelConfig != null ? configChannelConfig : this.getLocalChannelConfig();
        }
        return this.mChannelConfig;
    }

    private IShareChannelConfig getConfigChannelConfig() {
        ShareChannelConfig configData = (ShareChannelConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.SHARE_CHANNEL_CONFIG);
        if (configData != null) {
            return new ConfigShareChannelConfig(configData.getConfigMap());
        }
        return null;
    }

    private IShareChannelConfig getLocalChannelConfig() {
        if (LanguageUtils.isRussian()) {
            return new RussianShareChannelConfig();
        }
        if (LanguageUtils.isVietnamese()) {
            return new VietnameseShareChannelConfig();
        }
        return new DefaultShareChannelConfig();
    }

    public List<BaseShareChannel> getChannelsByPage(ISharePage sharePage) {
        if (sharePage == null) {
            MLog.info((Object)TAG, (String)"getChannelsByPage, sharePage = null", (Object[])new Object[0]);
        } else {
            MLog.info((Object)TAG, (String)("getChannelsByPage, name = " + sharePage.getPageName()), (Object[])new Object[0]);
        }
        return this.getChannelConfig().getChannelsByPage(sharePage);
    }

    public List<BaseShareChannel> getVitenamInviteFriendChannels() {
        VietnamInviteFriendConfig config = (VietnamInviteFriendConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.VIETNAM_INVITE_FRIEND);
        if (config != null && !FP.empty((Collection)config.getPlatformList())) {
            ArrayList<BaseShareChannel> channelList = new ArrayList<BaseShareChannel>(config.getPlatformList().size());
            int size = config.getPlatformList().size();
            for (int i = 0; i < size; ++i) {
                String name = (String)config.getPlatformList().get(i);
                int channelId = ShareChannelIdDef.getChannelIdByName((String)name);
                if (channelId == -1) continue;
                channelList.add(ShareChannel.createChannelById(channelId));
            }
            return channelList;
        }
        return null;
    }
}

