/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.IShareTemplate;
import com.yy.hiyo.share.base.OnDataReadyCallback;
import com.yy.hiyo.share.base.ShareBundle;
import com.yy.hiyo.share.base.dataprovider.MutableShareBundle;
import com.yy.hiyo.share.base.template.DefaultShareTemplate;
import com.yy.hiyo.share.dataprovider.DefaultShareDataProvider;
import com.yy.socialplatformbase.data.ShareData;
import java.util.HashMap;
import java.util.Map;

public class DefaultShareHelper {
    private static final String TAG = "DefaultShareHelper";
    private static final String SHARE_LINK_ARG = "uid=%d&h=%d&lang=%s";
    private DefaultShareTemplate defaultShareTemplate;
    private DefaultShareDataProvider defaultShareDataProvider;
    private Map<String, String> shortUrlCache = new HashMap<String, String>();

    public DefaultShareHelper() {
        this.defaultShareTemplate = new DefaultShareTemplate();
        this.defaultShareDataProvider = new DefaultShareDataProvider();
    }

    public IShareTemplate getDefaultShareTemplate() {
        return this.defaultShareTemplate;
    }

    public void preload() {
        this.defaultShareDataProvider.preload();
    }

    public void buildShareData(int channelId, OnShareDataCallback callback) {
        this.buildShareData(channelId, null, callback);
    }

    public void buildShareData(final int channelId, final Map<String, String> shareUrlArgs, final OnShareDataCallback callback) {
        this.defaultShareDataProvider.waitDataReady(new OnDataReadyCallback(){

            public void onDataReady(ShareBundle shareBundle) {
                DefaultShareHelper.this.buildShareUrl(shareBundle, channelId, shareUrlArgs, callback);
            }
        });
    }

    private void buildShareUrl(final ShareBundle shareBundle, final int channelId, Map<String, String> shareUrlArgs, final OnShareDataCallback callback) {
        final MutableShareBundle mutableShareBundle = new MutableShareBundle();
        mutableShareBundle.setTitle(shareBundle.getTitle());
        mutableShareBundle.setImagePath(shareBundle.getImagePath());
        String url = this.appenUrlArgs(shareBundle.getUrl(), shareUrlArgs);
        FeatureLog.i((String)"FTSHAREBase", (String)("DefaultShareHelper, build share url with args, url:" + url), (Object[])new Object[0]);
        String cacheShortUrl = this.shortUrlCache.get(url);
        if (cacheShortUrl != null) {
            mutableShareBundle.setUrl(cacheShortUrl);
            mutableShareBundle.setText(StringUtils.format((String)"%s %s", (Object[])new Object[]{shareBundle.getText(), cacheShortUrl}));
            this.handleResult(channelId, (ShareBundle)mutableShareBundle, callback);
        } else {
            ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                public void onSuccess(String input, String shortUrl) {
                    DefaultShareHelper.this.shortUrlCache.put(input, shortUrl);
                    mutableShareBundle.setUrl(shortUrl);
                    mutableShareBundle.setText(StringUtils.format((String)"%s %s", (Object[])new Object[]{shareBundle.getText(), shortUrl}));
                    DefaultShareHelper.this.handleResult(channelId, (ShareBundle)mutableShareBundle, callback);
                }

                public void onError(String input, int code, String msg) {
                    mutableShareBundle.setUrl(input);
                    mutableShareBundle.setText(StringUtils.format((String)"%s %s", (Object[])new Object[]{shareBundle.getText(), input}));
                    DefaultShareHelper.this.handleResult(channelId, (ShareBundle)mutableShareBundle, callback);
                }
            });
        }
    }

    private void handleResult(int channelId, ShareBundle shareBundle, OnShareDataCallback callback) {
        ShareData shareData = this.defaultShareTemplate.createShareData(channelId, shareBundle);
        if (callback != null) {
            callback.onShareDataReady(shareData);
        }
    }

    private String appenUrlArgs(String url, Map<String, String> args) {
        if (FP.empty((CharSequence)url)) {
            return url;
        }
        if (FP.empty(args)) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        if (url.contains("?")) {
            builder.append("?");
        } else {
            builder.append("&");
        }
        builder.append(StringUtils.format((String)SHARE_LINK_ARG, (Object[])new Object[]{AccountUtil.getUid(), UriProvider.getIdc(), SystemUtils.getLangAndCountry()}));
        for (Map.Entry<String, String> entry : args.entrySet()) {
            builder.append("&" + entry.getKey() + "=" + entry.getValue());
        }
        return builder.toString();
    }

    public static interface OnShareDataCallback {
        public void onShareDataReady(ShareData var1);
    }
}

