/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IShareDialogViewProvider;
import com.yy.hiyo.share.base.IStartShareCallback;
import com.yy.hiyo.share.base.ShareCardData;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import java.util.List;

public class ShareCardPage
extends YYRelativeLayout
implements IShareDialogViewProvider,
View.OnClickListener {
    private Context mContext;
    private YYImageView mIvCardBg;
    private CircleImageView mIvIcon;
    private YYTextView mTvTitle;
    private YYTextView mTvSubtitle;
    private YYTextView mTvShareTip;
    private YYLinearLayout mLLytChannel;
    private IStartShareCallback mStartShareCallback;

    public ShareCardPage(Context context, IStartShareCallback callback) {
        super(context);
        this.mContext = context;
        this.mStartShareCallback = callback;
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.page_share_card, (ViewGroup)this);
        this.mIvCardBg = (YYImageView)this.findViewById(R.id.iv_card_bg);
        this.mIvIcon = (CircleImageView)this.findViewById(R.id.iv_icon);
        this.mTvTitle = (YYTextView)this.findViewById(R.id.tv_title);
        this.mTvSubtitle = (YYTextView)this.findViewById(R.id.tv_subtitle);
        this.mTvShareTip = (YYTextView)this.findViewById(R.id.tv_share_tip);
        this.mLLytChannel = (YYLinearLayout)this.findViewById(R.id.llyt_channel);
    }

    public void updateProfileInfo(ShareCardData shareCardData) {
        if (shareCardData == null) {
            return;
        }
        this.mTvTitle.setText((CharSequence)shareCardData.title);
        ImageLoader.loadImage((ImageView)this.mIvIcon, (String)shareCardData.iconUrl, (int)shareCardData.defaultIcon);
        this.mIvCardBg.setImageResource(shareCardData.cardBg);
        this.mTvSubtitle.setText((CharSequence)shareCardData.subtitle);
        this.mTvShareTip.setText((CharSequence)shareCardData.shareTip);
        this.initShareChannels(shareCardData.shareChannelList);
    }

    public void initShareChannels(List<BaseShareChannel> shareChannelList) {
        if (shareChannelList == null) {
            return;
        }
        for (int i = 0; i < shareChannelList.size(); ++i) {
            BaseShareChannel shareChannel = shareChannelList.get(i);
            YYImageView ivIcon = new YYImageView(this.mContext);
            int iconSize = ResolutionUtils.dip2Px((float)40.0f);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(iconSize, iconSize);
            int marginValue = ResolutionUtils.dip2Px((float)16.0f);
            if (i == shareChannelList.size() - 1) {
                if (LanguageUtils.isRtl()) {
                    lp.leftMargin = 0;
                } else {
                    lp.rightMargin = 0;
                }
            } else if (LanguageUtils.isRtl()) {
                lp.leftMargin = marginValue;
            } else {
                lp.rightMargin = marginValue;
            }
            int idResId = 0;
            int iconResId = 0;
            switch (shareChannel.getId()) {
                case 5: {
                    idResId = R.id.share_platform_facebook;
                    iconResId = R.drawable.ico_share_facebook;
                    break;
                }
                case 9: {
                    idResId = R.id.share_platform_vk;
                    iconResId = R.drawable.ico_share_vk;
                    break;
                }
                case 2: {
                    idResId = R.id.share_platform_whatsapp;
                    iconResId = R.drawable.ico_share_whatsapp;
                    break;
                }
                case 0: {
                    idResId = R.id.share_system;
                    iconResId = R.drawable.selector_share_others;
                    break;
                }
                case 10: {
                    idResId = R.id.share_copy_link;
                    iconResId = R.drawable.selector_share_copylink;
                    break;
                }
                case 3: {
                    idResId = R.id.share_platform_instagram;
                    iconResId = R.drawable.ico_share_ins;
                    break;
                }
                case 1: {
                    idResId = R.id.share_platform_line;
                    iconResId = R.drawable.ico_share_line;
                    break;
                }
                case 6: {
                    idResId = R.id.share_platform_messenger;
                    iconResId = R.drawable.ico_share_messenger;
                    break;
                }
                case 11: {
                    idResId = R.id.share_platform_zalo;
                    iconResId = R.drawable.ico_share_zalo;
                    break;
                }
                case 7: {
                    idResId = R.id.share_platform_snapchat;
                    iconResId = R.drawable.ico_share_snapchat;
                    break;
                }
            }
            ivIcon.setId(idResId);
            ivIcon.setImageResource(iconResId);
            this.mLLytChannel.addView((View)ivIcon, (ViewGroup.LayoutParams)lp);
            ivIcon.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        int shareChannelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
        if (shareChannelId != -1 && this.mStartShareCallback != null) {
            this.mStartShareCallback.onStartShare(shareChannelId);
        }
    }

    public View getContentView() {
        return this;
    }

    public View getShareImage() {
        return null;
    }
}

