/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.TextAppearanceSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.game.base.bean.StreakWinLevelDef;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import java.util.List;

public class StreakWinCardView
extends YYFrameLayout {
    private Context mContext;
    private ConstraintLayout mClCardBg;
    private CircleImageView mCivAvatar;
    private RoundConerImageView mRcivGameLeft;
    private RoundConerImageView mRcivGameRight;
    private YYTextView mTvGameLeft;
    private YYTextView mTvGameRight;
    private YYTextView mTvContent;
    private YYTextView mTvTip;
    private YYImageView mTrophy;
    private IShareCardImageFinishLoadedCallback mCallback;
    private boolean mAvatarFinishLoaded;
    private boolean mIcon1FinishLoaded;
    private boolean mIcon2FinishLoaded;
    private boolean mHadDraw = true;

    public StreakWinCardView(Context context) {
        super(context);
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.layout_streak_win_share_card, (ViewGroup)this, true);
        this.mClCardBg = (ConstraintLayout)this.findViewById(R.id.cl_card_bg);
        this.mCivAvatar = (CircleImageView)this.findViewById(R.id.civ_avatar);
        this.mRcivGameLeft = (RoundConerImageView)this.findViewById(R.id.rciv_game_left);
        this.mRcivGameRight = (RoundConerImageView)this.findViewById(R.id.rciv_game_right);
        this.mTvGameLeft = (YYTextView)this.findViewById(R.id.tv_game_name_left);
        this.mTvGameRight = (YYTextView)this.findViewById(R.id.tv_game_name_right);
        this.mTvContent = (YYTextView)this.findViewById(R.id.tv_content);
        this.mTvTip = (YYTextView)this.findViewById(R.id.tv_tip);
        this.mTrophy = (YYImageView)this.findViewById(R.id.iv_trophy);
        this.mTvContent.setDrawingCacheEnabled(true);
        this.mTvTip.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
    }

    public void updateStreakWinShareCard(int streakWinCount, UserInfoKS userInfoKS, List<GameHistoryBean> list, IShareCardImageFinishLoadedCallback callback) {
        if (userInfoKS == null || callback == null) {
            return;
        }
        this.mHadDraw = false;
        String icon1Url = "";
        String icon2Url = "";
        this.updateUIForStreakWinLevel(streakWinCount);
        this.setStreakWinSpannableStyle(this.mTvContent, streakWinCount + "");
        if (list != null && list.size() == 1) {
            GameHistoryBean gameHistoryBean = list.get(0);
            this.setGamesSpannableStyle(this.mTvGameLeft, ResourceUtils.getString((int)R.string.play), " " + gameHistoryBean.totalCount);
            icon1Url = gameHistoryBean == null ? "" : gameHistoryBean.iconUrl;
        } else if (list != null && list.size() >= 2) {
            GameHistoryBean gameHistoryBean = list.get(0);
            this.setGamesSpannableStyle(this.mTvGameLeft, ResourceUtils.getString((int)R.string.play), " " + gameHistoryBean.totalCount);
            icon1Url = gameHistoryBean == null ? "" : gameHistoryBean.iconUrl;
            gameHistoryBean = list.get(1);
            this.setGamesSpannableStyle(this.mTvGameRight, ResourceUtils.getString((int)R.string.play), " " + gameHistoryBean.totalCount);
            icon2Url = gameHistoryBean == null ? "" : gameHistoryBean.iconUrl;
        }
        this.mCallback = callback;
        ImageLoader.loadImage((ImageView)this.mCivAvatar, (String)(userInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex), (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                StreakWinCardView.this.mAvatarFinishLoaded = true;
                StreakWinCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                StreakWinCardView.this.mAvatarFinishLoaded = true;
                StreakWinCardView.this.hadImageFinishLoaded();
            }
        });
        ImageLoader.loadImage((ImageView)this.mRcivGameLeft, (String)icon1Url, (int)R.drawable.ico_share_game_sheep, (int)R.drawable.ico_share_game_sheep, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                StreakWinCardView.this.mIcon1FinishLoaded = true;
                StreakWinCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                StreakWinCardView.this.mIcon1FinishLoaded = true;
                StreakWinCardView.this.hadImageFinishLoaded();
            }
        });
        ImageLoader.loadImage((ImageView)this.mRcivGameRight, (String)icon2Url, (int)R.drawable.ico_share_game_knife, (int)R.drawable.ico_share_game_knife, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                StreakWinCardView.this.mIcon2FinishLoaded = true;
                StreakWinCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                StreakWinCardView.this.mIcon2FinishLoaded = true;
                StreakWinCardView.this.hadImageFinishLoaded();
            }
        });
        this.invalidate();
    }

    private void updateUIForStreakWinLevel(int winCount) {
        int level = StreakWinLevelDef.getStreakWinLevel((int)winCount);
        switch (level) {
            case 3: {
                this.mClCardBg.setBackgroundResource(R.drawable.bg_streak_win_share_card_level1);
                this.mCivAvatar.setBorderColor(ResourceUtils.getColor((int)R.color.color_7eda4c));
                this.mTvContent.setBackgroundResource(R.drawable.icon_streak_win_share_banner_level1);
                this.mTrophy.setImageResource(R.drawable.icon_trophy_level1);
                break;
            }
            case 5: {
                this.mClCardBg.setBackgroundResource(R.drawable.bg_streak_win_share_card_level2);
                this.mCivAvatar.setBorderColor(ResourceUtils.getColor((int)R.color.color_68b1de));
                this.mTvContent.setBackgroundResource(R.drawable.icon_streak_win_share_banner_level2);
                this.mTrophy.setImageResource(R.drawable.icon_trophy_level2);
                break;
            }
            case 10: {
                this.mClCardBg.setBackgroundResource(R.drawable.bg_streak_win_share_card_level3);
                this.mCivAvatar.setBorderColor(ResourceUtils.getColor((int)R.color.color_f8a300f));
                this.mTvContent.setBackgroundResource(R.drawable.icon_streak_win_share_banner_level3);
                this.mTrophy.setImageResource(R.drawable.icon_trophy_level3);
                break;
            }
            case 20: {
                this.mClCardBg.setBackgroundResource(R.drawable.bg_streak_win_share_card_level4);
                this.mCivAvatar.setBorderColor(ResourceUtils.getColor((int)R.color.color_fff26b));
                this.mTvContent.setBackgroundResource(R.drawable.icon_streak_win_share_banner_level4);
                this.mTrophy.setImageResource(R.drawable.icon_trophy_level4);
                break;
            }
        }
    }

    private void hadImageFinishLoaded() {
        if (this.mCallback != null && this.mAvatarFinishLoaded && this.mIcon1FinishLoaded && this.mIcon2FinishLoaded && !this.mHadDraw) {
            this.mHadDraw = true;
            this.genImageAndSaveToAlbum();
        }
    }

    private void setGamesSpannableStyle(YYTextView tv, String frontStr, String backStr) {
        SpannableStringBuilder style2 = new SpannableStringBuilder((CharSequence)(frontStr + backStr));
        style2.setSpan((Object)new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.white)), 0, frontStr.length(), 33);
        tv.setText((CharSequence)style2);
    }

    private void setStreakWinSpannableStyle(YYTextView tv, String winCount) {
        String content = String.format(ResourceUtils.getString((int)R.string.short_summary_streak_win_share), winCount);
        SpannableStringBuilder style2 = new SpannableStringBuilder((CharSequence)content);
        style2.setSpan((Object)new TextAppearanceSpan(this.mContext, R.style.style_streak_win_count), 0, winCount.length(), 33);
        tv.setText((CharSequence)style2);
        tv.setHorizontallyScrolling(false);
    }

    private void genImageAndSaveToAlbum() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)StreakWinCardView.this);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StreakWinCardView.this.mCallback.onImageFinishLoaded("");
                        }
                    });
                    return;
                }
                String imagePath = FileStorageUtils.getInstance().getExternalCacheDir("temp").getAbsolutePath();
                String imageName = "streakwinshare";
                final String saveResult = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        StreakWinCardView.this.mCallback.onImageFinishLoaded(saveResult);
                    }
                });
            }
        });
    }
}

