/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.game.service.IGameResultShareService;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import com.yy.hiyo.share.sharetype.StreakWinCardView;
import java.util.List;
import okhttp3.Call;

public class StreakWinCardModel
extends AbstractShareModel {
    private static final String TAG = "StreakWinCardModel";
    private Context mContext;
    private StreakWinCardView mSteakWinCardView;
    private int mStreakWinCount;
    private boolean mIsNewUser;

    public StreakWinCardModel(int streakWinCount, boolean isNewUser, UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        super(userInfoKS, serviceManager, dialogLinkManager);
        this.mStreakWinCount = streakWinCount;
        this.mIsNewUser = isNewUser;
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(String.format(ResourceUtils.getString((int)R.string.title_share_streak_win), this.mUserInfoKS.nick));
        }
        return String.format(ResourceUtils.getString((int)R.string.title_share_streak_win), this.mUserInfoKS.nick);
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.subtitle_share_streak_win));
        }
        return ResourceUtils.getString((int)R.string.subtitle_share_streak_win);
    }

    @Override
    protected void startGetShareData(Context context) {
        this.mContext = context;
        this.getFavouriteGames();
    }

    @Override
    protected String getShareUrl() {
        return ((IGameResultShareService)ServiceManagerProxy.getService(IGameResultShareService.class)).generateShareLink(this.mUserInfoKS.uid, this.mStreakWinCount, this.mIsNewUser, this.mImageUrl, this.subNickname(this.mUserInfoKS.nick));
    }

    private String subNickname(String str) {
        String tempStr = str;
        if (str.length() > 10) {
            tempStr = str.substring(0, 10) + "...";
        }
        return tempStr;
    }

    private void getFavouriteGames() {
        ((IUserInfoService)this.mServiceManager.getService(IUserInfoService.class)).getGameHistoryWithLimit(AccountUtil.getUid(), 2, new OnGameHistoryCallback(){

            public void onUISuccess(List<GameHistoryBean> list, int id2) {
                MLog.info((Object)StreakWinCardModel.TAG, (String)("get game history success:" + list.size()), (Object[])new Object[0]);
                StreakWinCardModel.this.generateImage(list);
            }

            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)StreakWinCardModel.TAG, (String)"get game history onError", (Object[])new Object[0]);
                StreakWinCardModel.this.generateImage(null);
            }

            public void onResponseError(int id2, String message, String response) {
                MLog.info((Object)StreakWinCardModel.TAG, (String)"get game history onResponseError", (Object[])new Object[0]);
                StreakWinCardModel.this.generateImage(null);
            }
        });
    }

    private void generateImage(final List<GameHistoryBean> list) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)StreakWinCardModel.TAG, (String)"start load image", (Object[])new Object[0]);
                if (Build.VERSION.SDK_INT <= 19) {
                    try {
                        StreakWinCardModel.this.genImageReal(list);
                    }
                    catch (Exception e) {
                        MLog.error((Object)StreakWinCardModel.TAG, (String)"genImageReal exception", (Throwable)e, (Object[])new Object[0]);
                    }
                } else {
                    StreakWinCardModel.this.genImageReal(list);
                }
            }
        });
    }

    private void genImageReal(List<GameHistoryBean> list) {
        this.mSteakWinCardView = new StreakWinCardView(this.mContext);
        this.mSteakWinCardView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mSteakWinCardView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        this.mSteakWinCardView.layout(0, 0, this.mSteakWinCardView.getMeasuredWidth(), this.mSteakWinCardView.getMeasuredHeight());
        this.mSteakWinCardView.updateStreakWinShareCard(this.mStreakWinCount, this.mUserInfoKS, list, new IShareCardImageFinishLoadedCallback(){

            @Override
            public void onImageFinishLoaded(String imagePath) {
                MLog.info((Object)StreakWinCardModel.TAG, (String)("on image finish loader:" + imagePath), (Object[])new Object[0]);
                StreakWinCardModel.this.mImagePath = imagePath;
                StreakWinCardModel.this.uploadImageForShare();
                StreakWinCardModel.this.mSteakWinCardView = null;
            }
        });
    }
}

