/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import com.yy.hiyo.share.sharetype.SingleGameCardView;

public class SingleGameCardModel
extends AbstractShareModel {
    private static final String TAG = "SingleGameCardModel";
    private SingleGameCardView mSingleGameCardView;
    private String mGameIconUrl;
    private long mGameRecord;
    private String mGameName;

    public SingleGameCardModel(String gameIconUrl, long gameRecord, String gameName, UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        super(userInfoKS, serviceManager, dialogLinkManager);
        this.mGameIconUrl = gameIconUrl;
        this.mGameRecord = gameRecord;
        this.mGameName = gameName;
    }

    @Override
    protected void startGetShareData(final Context context) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT <= 19) {
                    try {
                        SingleGameCardModel.this.genImageReal(context);
                    }
                    catch (Exception e) {
                        MLog.error((Object)SingleGameCardModel.TAG, (String)"genImageReal exception", (Throwable)e, (Object[])new Object[0]);
                    }
                } else {
                    SingleGameCardModel.this.genImageReal(context);
                }
            }
        });
    }

    private void genImageReal(Context context) {
        this.mSingleGameCardView = new SingleGameCardView(context);
        this.mSingleGameCardView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mSingleGameCardView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        this.mSingleGameCardView.layout(0, 0, this.mSingleGameCardView.getMeasuredWidth(), this.mSingleGameCardView.getMeasuredHeight());
        this.mSingleGameCardView.updateSingleGameCard(this.mUserInfoKS, this.mGameIconUrl, this.mGameRecord, new IShareCardImageFinishLoadedCallback(){

            @Override
            public void onImageFinishLoaded(String imagePath) {
                SingleGameCardModel.this.mImagePath = imagePath;
                SingleGameCardModel.this.uploadImageForShare();
                SingleGameCardModel.this.mSingleGameCardView = null;
            }
        });
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(String.format(ResourceUtils.getString((int)R.string.title_invite_share_single_game_title), this.mGameName));
        }
        return String.format(ResourceUtils.getString((int)R.string.title_invite_share_single_game_title), this.mGameName);
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.title_invite_share_single_game_text));
        }
        return ResourceUtils.getString((int)R.string.title_invite_share_single_game_text);
    }

    @Override
    protected String getShareUrl() {
        return this.generateFindFriendShareUrl();
    }
}

