/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.IProfileShareCardUICallback;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import java.io.File;

@SuppressLint(value={"ViewConstructor"})
public class ProfileShareCardViewNew
extends YYConstraintLayout
implements IProfileShareCardUICallback {
    private RecycleImageView mCardBgImageView;
    private RecycleImageView mUserAvatarImageView;
    private YYTextView mUserNickTextView;
    private YYTextView mUserUidTextView;
    private YYTextView mTitleView;
    private YYTextView mSubTitleView;
    private int mShareChannel;
    private String mPageType;
    private IAB mCardStyleTest = null;

    public ProfileShareCardViewNew(Context context, int shareChannel, String pageType) {
        super(context);
        this.mShareChannel = shareChannel;
        this.mPageType = pageType;
        this.createShareCardView(context);
    }

    public void setStyleTest(IAB abTest) {
        this.mCardStyleTest = abTest;
    }

    private void initLayout(Context context, int shareChannel) {
        switch (shareChannel) {
            case 5: {
                View.inflate((Context)context, (int)R.layout.layout_profile_share_card_horizontal, (ViewGroup)this);
                this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
                break;
            }
            case 7: {
                View.inflate((Context)context, (int)R.layout.layout_share_card_snapchat, (ViewGroup)this);
                View body = this.findViewById(R.id.cl_profile_body);
                ViewGroup.LayoutParams layoutParams = body.getLayoutParams();
                if (layoutParams != null) {
                    layoutParams.width = ResolutionUtils.getScreenWidth();
                    body.setLayoutParams(layoutParams);
                }
                this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
                break;
            }
            default: {
                View.inflate((Context)context, (int)R.layout.layout_profile_share_card_vertical, (ViewGroup)this);
                this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
        }
    }

    private void createShareCardView(Context context) {
        this.initLayout(context, this.mShareChannel);
        this.mCardBgImageView = (RecycleImageView)this.findViewById(R.id.iv_profile_share_bg);
        this.mUserAvatarImageView = (RecycleImageView)this.findViewById(R.id.iv_profile_share_avatar);
        this.mUserNickTextView = (YYTextView)this.findViewById(R.id.tv_profile_user_nick);
        this.mUserUidTextView = (YYTextView)this.findViewById(R.id.tv_profile_user_id);
        this.mTitleView = (YYTextView)this.findViewById(R.id.tv_profile_share_title);
        this.mSubTitleView = (YYTextView)this.findViewById(R.id.tv_profile_share_subtitle);
        if (this.mUserNickTextView != null) {
            FontUtils.setFontType((TextView)this.mUserNickTextView, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        }
        if (this.mUserUidTextView != null) {
            FontUtils.setFontType((TextView)this.mUserUidTextView, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        }
    }

    private String getAvatarUrl(String avatarUrl, int shareChannel) {
        switch (shareChannel) {
            case 5: {
                return avatarUrl + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)150.0f));
            }
            case 7: {
                return avatarUrl + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)70.0f));
            }
        }
        return avatarUrl + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)100.0f));
    }

    private int getShareCardBackgroundResource(int shareChannel, String pageType) {
        switch (shareChannel) {
            case 5: {
                if (NAB.A.equals((Object)this.mCardStyleTest)) {
                    return R.drawable.ico_profile_page_share_bg_horizontal_a;
                }
                return R.drawable.ico_profile_page_share_bg_horizontal_b;
            }
            case 7: {
                return R.drawable.bg_share_card_snapchat;
            }
        }
        if (NAB.A.equals((Object)this.mCardStyleTest)) {
            return R.drawable.ico_profile_page_share_bg_vertical_a;
        }
        return R.drawable.ico_profile_page_share_bg_vertical_b;
    }

    @Override
    public void updateUserProfile(String avatar, String nick, long vid, int sex, String title, String subTitle, final IShareCardImageFinishLoadedCallback callback) {
        if (this.mUserNickTextView != null) {
            this.mUserNickTextView.setText((CharSequence)nick);
        }
        if (this.mUserUidTextView != null) {
            this.mUserUidTextView.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_profile_share_user_id, (Object[])new Object[]{vid}));
        }
        if (this.mTitleView != null) {
            this.mTitleView.setText((CharSequence)title);
        }
        if (this.mSubTitleView != null) {
            this.mSubTitleView.setText((CharSequence)subTitle);
        }
        if (this.mCardBgImageView != null) {
            this.mCardBgImageView.setImageResource(this.getShareCardBackgroundResource(this.mShareChannel, this.mPageType));
        }
        if (this.mUserAvatarImageView != null) {
            ImageLoader.loadImage((ImageView)this.mUserAvatarImageView, (String)this.getAvatarUrl(avatar, this.mShareChannel), (int)AvatarUtils.getDefaultAvatar((int)sex), (int)AvatarUtils.getDefaultAvatar((int)sex), (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

                public void onLoadFailed(Exception e) {
                    FeatureLog.e((String)"FTSHAREProfile", (String)"profile share load avatar failed: %s", (Object[])new Object[]{e});
                    ProfileShareCardViewNew.this.generateImageAndSave(callback);
                }

                public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                    ProfileShareCardViewNew.this.generateImageAndSave(callback);
                }
            });
        } else {
            this.generateImageAndSave(callback);
        }
    }

    private void generateImageAndSave(final IShareCardImageFinishLoadedCallback callback) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)ProfileShareCardViewNew.this);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onImageFinishLoaded("");
                            }
                        }
                    });
                    return;
                }
                String lastProfileShareImagePath = SettingFlags.getStringValue((String)"last_profile_share_image_name", (String)"");
                if (StringUtils.isNotEmpty((String)lastProfileShareImagePath) && YYFileUtils.isFileExisted((String)lastProfileShareImagePath)) {
                    File file = new File(lastProfileShareImagePath);
                    YYFileUtils.delete((File)file);
                    SettingFlags.setStringValue((String)"last_profile_share_image_name", (String)"");
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String fileName = System.currentTimeMillis() + "profile_share";
                final String savePath = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)fileName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                SettingFlags.setStringValue((String)"last_profile_share_image_name", (String)savePath);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onImageFinishLoaded(savePath);
                        }
                    }
                });
            }
        });
    }
}

