/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import java.io.File;

public class InviteCardView
extends YYConstraintLayout {
    private RecycleImageView mCardBgImageView;
    private RecycleImageView mUserAvatarImageView;
    private YYTextView mUserNickTextView;
    private YYTextView mUserUidTextView;
    private YYTextView mTitleView;
    private YYTextView mSubTitleView;
    private boolean isCardBgLoadFinished = false;
    private boolean isUserAvatarLoadFinished = false;
    private int mShareChannel = -1;
    private IAB mCardStyleTest = null;

    public InviteCardView(Context context) {
        super(context);
        this.createView(context);
    }

    public InviteCardView(Context context, int shareChannel) {
        super(context);
        this.mShareChannel = shareChannel;
        this.createView(context);
    }

    public void setCardStyleTest(IAB abTest) {
        this.mCardStyleTest = abTest;
    }

    private void initLayout(Context context, int shareChannel) {
        if (shareChannel == 7) {
            View.inflate((Context)context, (int)R.layout.layout_share_card_snapchat, (ViewGroup)this);
            View body = this.findViewById(R.id.cl_profile_body);
            ViewGroup.LayoutParams layoutParams = body.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = ResolutionUtils.getScreenWidth();
                body.setLayoutParams(layoutParams);
            }
        } else {
            View.inflate((Context)context, (int)R.layout.layout_profile_share_card_horizontal, (ViewGroup)this);
        }
        this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
    }

    private void createView(Context context) {
        this.initLayout(context, this.mShareChannel);
        this.mCardBgImageView = (RecycleImageView)this.findViewById(R.id.iv_profile_share_bg);
        this.mUserAvatarImageView = (RecycleImageView)this.findViewById(R.id.iv_profile_share_avatar);
        this.mUserNickTextView = (YYTextView)this.findViewById(R.id.tv_profile_user_nick);
        this.mUserUidTextView = (YYTextView)this.findViewById(R.id.tv_profile_user_id);
        this.mTitleView = (YYTextView)this.findViewById(R.id.tv_profile_share_title);
        this.mSubTitleView = (YYTextView)this.findViewById(R.id.tv_profile_share_subtitle);
    }

    private String getCardBgUrl(String cardBgUrl, int shareChannel) {
        if (shareChannel == 7) {
            return cardBgUrl + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)210.0f), (int)ResolutionUtils.dip2Px((float)75.0f), (boolean)false);
        }
        return cardBgUrl + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)300.0f), (int)ResolutionUtils.dip2Px((float)157.0f), (boolean)false);
    }

    private int getCardBackgroundResource(int shareChannel) {
        if (shareChannel == 7) {
            return R.drawable.bg_share_card_snapchat;
        }
        if (NAB.A.equals((Object)this.mCardStyleTest)) {
            return R.drawable.ico_profile_page_share_bg_horizontal_a;
        }
        return R.drawable.ico_profile_page_share_bg_horizontal_b;
    }

    public void updateCardViewUI(String cardBgUrl, String avatar, String nick, long vid, int sex, @Nullable String title, @Nullable String subTitle, final IShareCardImageFinishLoadedCallback callback) {
        if (callback == null) {
            return;
        }
        int backgroundResource = this.getCardBackgroundResource(this.mShareChannel);
        if (StringUtils.isNotEmpty((String)cardBgUrl)) {
            ImageLoader.loadImage((ImageView)this.mCardBgImageView, (String)this.getCardBgUrl(cardBgUrl, this.mShareChannel), (int)backgroundResource, (int)backgroundResource, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

                public void onLoadFailed(Exception e) {
                    FeatureLog.e((String)"FTSHAREDrawerInvite", (String)"load card bg error: %s", (Object[])new Object[]{e});
                    InviteCardView.this.isCardBgLoadFinished = true;
                    InviteCardView.this.notifyImageLoadFinished(callback);
                }

                public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                    InviteCardView.this.isCardBgLoadFinished = true;
                    InviteCardView.this.notifyImageLoadFinished(callback);
                }
            });
        } else {
            this.mCardBgImageView.setImageResource(backgroundResource);
            this.isCardBgLoadFinished = true;
            this.notifyImageLoadFinished(callback);
        }
        if (this.mUserNickTextView != null) {
            this.mUserNickTextView.setText((CharSequence)nick);
        }
        if (this.mUserUidTextView != null) {
            this.mUserUidTextView.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_profile_share_user_id, (Object[])new Object[]{vid}));
        }
        if (this.mTitleView != null) {
            this.mTitleView.setText((CharSequence)title);
        }
        if (this.mSubTitleView != null) {
            this.mSubTitleView.setText((CharSequence)subTitle);
        }
        if (this.mUserAvatarImageView != null) {
            ImageLoader.loadImage((ImageView)this.mUserAvatarImageView, (String)(avatar + YYImageUtils.getThumbnailPostfix((int)120)), (int)AvatarUtils.getDefaultAvatar((int)sex), (int)AvatarUtils.getDefaultAvatar((int)sex), (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

                public void onLoadFailed(Exception e) {
                    FeatureLog.e((String)"FTSHAREDrawerInvite", (String)"load card avatar error: %s", (Object[])new Object[]{e});
                    InviteCardView.this.isUserAvatarLoadFinished = true;
                    InviteCardView.this.notifyImageLoadFinished(callback);
                }

                public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                    InviteCardView.this.isUserAvatarLoadFinished = true;
                    InviteCardView.this.notifyImageLoadFinished(callback);
                }
            });
        } else {
            this.isCardBgLoadFinished = true;
            this.notifyImageLoadFinished(callback);
        }
    }

    private void notifyImageLoadFinished(IShareCardImageFinishLoadedCallback callback) {
        if (this.isCardBgLoadFinished && this.isUserAvatarLoadFinished) {
            this.generateImageAndSave(callback);
        }
    }

    private void generateImageAndSave(final IShareCardImageFinishLoadedCallback callback) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)InviteCardView.this);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onImageFinishLoaded("");
                            }
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getRootDir() + "/share" + File.separator;
                String fileName = "invite_share";
                final String savePath = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)fileName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onImageFinishLoaded(savePath);
                        }
                    }
                });
            }
        });
    }
}

