/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yy.appbase.DR;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import org.jetbrains.annotations.NotNull;

public class GameMasterView
extends YYConstraintLayout {
    private static String TAG = "GameMasterView";
    private Context mContext;
    private RecycleImageView mCardBgImageView;
    private RecycleImageView iconMaster;
    private DResource resourceKey = DR.icon_master_tag;

    public GameMasterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.createView();
    }

    public GameMasterView(Context mContext) {
        super(mContext);
        this.mContext = mContext;
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_share_game_master, (ViewGroup)this, true);
        this.mCardBgImageView = (RecycleImageView)this.findViewById(R.id.iv_share_bg);
        this.iconMaster = (RecycleImageView)this.findViewById(R.id.icon_master);
    }

    private void genImageAndSaveToAlbum(final IShareCardImageFinishLoadedCallback callback) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)GameMasterView.this);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.onImageFinishLoaded("");
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String imageName = "master_share";
                final String saveResult = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onImageFinishLoaded(saveResult);
                    }
                });
            }
        });
        this.invalidate();
    }

    public void updateMaster(UserInfoKS mUserInfoKS, int iconId, IShareCardImageFinishLoadedCallback iShareCardImageFinishLoadedCallback) {
        if (iconId == 2) {
            this.resourceKey = DR.icon_master_tag;
        } else if (iconId == 1) {
            this.resourceKey = DR.icon_super_master_tag;
        }
        DyResLoader.INSTANCE.getResFilePath(this.resourceKey, new IDRCallback(){

            public void onFailed(@NotNull String msg) {
            }

            public void onSucceed(@NotNull String filePath) {
                if (!FP.empty((CharSequence)filePath)) {
                    Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)filePath, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)false);
                    if (bitmap == null) {
                        MLog.info((Object)TAG, (String)"DyResLoader.updateMaster bitmap is null", (Object[])new Object[0]);
                        return;
                    }
                    BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                    GameMasterView.this.iconMaster.setImageDrawable((Drawable)drawable2);
                }
            }
        });
        this.genImageAndSaveToAlbum(iShareCardImageFinishLoadedCallback);
    }

    public void updateShareCardViewBackground(int drawableResId) {
        if (this.mCardBgImageView != null) {
            ImageLoader.loadImage((ImageView)this.mCardBgImageView, (int)drawableResId);
        }
    }
}

