/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.DebugTestUriProvider;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.sharetype.IGetShareDataCallback;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public abstract class AbstractShareModel {
    private static final String TAG = "AbstractShareModel";
    private static final String SHARE_URL = "share_url";
    private static final String IMG_URL_NO_GUIDE = "img_url_no_guide";
    private static final String AF_URL_NO_GUIDE = "af_url_no_guide";
    private static final String IMG_URL_NEW_USER = "img_url_new_user";
    private static final String AF_URL_NEW_USER = "af_url_new_user";
    private static final String IMG_URL_LIMIT_ONLINE = "img_url_limit_online";
    private static final String AF_URL_LIMIT_ONLINE = "af_url_limit_online";
    private static final String DEFAULT_FIND_FRIEND_AF_URL = "https://olaparty.onelink.me/vYP0?pid=User_invite&c=PlaywithFriends&af_web_dp=http%3A%2F%2Fwww.ihago.net%2F&af_dp=olaparty%3A%2F%2Fdp_olaparty%2FhomePage";
    private static final String SINGLE_GAME_FIND_FRIEND_AF_URL = "https://olaparty.onelink.me/vYP0?pid=User_invite&c=PlaywithFriends&af_web_dp=http%3A%2F%2Fwww.ihago.net%2F&af_dp=olaparty%3A%2F%2Fdp_olaparty%2FhomePage";
    private static final String PK_GAME_FIND_FRIEND_AF_URL = "https://olaparty.onelink.me/vYP0?pid=User_invite&c=PlaywithFriends&af_web_dp=http%3A%2F%2Fwww.ihago.net%2F&af_dp=olaparty%3A%2F%2Fdp_olaparty%2FhomePage";
    protected DialogLinkManager mDialogLinkManager;
    protected UserInfoKS mUserInfoKS;
    protected IServiceManager mServiceManager;
    protected IGetShareDataCallback mIGetShareDataCallback;
    protected String mImagePath;
    protected String mImageUrl;
    protected String mShortUrl;
    protected String mPageType;
    protected int mFindFriendGuideType;
    protected int mChannelId;
    protected IAB mStyleABTest;

    public AbstractShareModel(UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        this.mUserInfoKS = userInfoKS;
        this.mServiceManager = serviceManager;
        this.mDialogLinkManager = dialogLinkManager;
    }

    public void startGetShareData(Context context, IGetShareDataCallback iGetShareDataCallback) {
        this.mIGetShareDataCallback = iGetShareDataCallback;
        this.startGetShareData(context);
    }

    public void setShareStyleAB(IAB abTest) {
        this.mStyleABTest = abTest;
    }

    public void setPageType(String pageType) {
        MLog.debug((Object)TAG, (String)"setPageType: %s", (Object[])new Object[]{pageType});
        this.mPageType = pageType;
    }

    public void setChannelId(int channelId) {
        this.mChannelId = channelId;
    }

    public void setFindFriendGuideType(int guideType) {
        this.mFindFriendGuideType = guideType;
    }

    protected String getConfigImage() {
        Map configs = ((IIntlShareService)this.mServiceManager.getService(IIntlShareService.class)).getShareConfigByPage("play_with_friends");
        if (configs == null) {
            return "";
        }
        String imageUrl = (String)configs.get(IMG_URL_NO_GUIDE);
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            imageUrl = (String)configs.get(IMG_URL_NEW_USER);
        }
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            imageUrl = (String)configs.get(IMG_URL_LIMIT_ONLINE);
        }
        return imageUrl;
    }

    public String generateFindFriendShareUrl() {
        EnvSettingType type;
        String mAfUrl = null;
        Map configs = ((IIntlShareService)this.mServiceManager.getService(IIntlShareService.class)).getShareConfigByPage("play_with_friends");
        String shareUrl = "";
        if (configs != null) {
            shareUrl = URLUtils.replaceUrl((String)((String)configs.get(SHARE_URL)));
        }
        if ((type = EnvSettings.instance().getUriSettingValue()) == EnvSettingType.Test || FP.empty((CharSequence)shareUrl)) {
            shareUrl = URLUtils.replaceUrl((String)(DebugTestUriProvider.TEST_OLA_PARTY_HOST + "/a/invitefriendlanding/index.html"));
        }
        switch (this.mFindFriendGuideType) {
            case 0: 
            case 3: 
            case 4: {
                mAfUrl = "https://olaparty.onelink.me/vYP0?pid=User_invite&c=PlaywithFriends&af_web_dp=http%3A%2F%2Fwww.ihago.net%2F&af_dp=olaparty%3A%2F%2Fdp_olaparty%2FhomePage";
                break;
            }
            case 2: {
                mAfUrl = "https://olaparty.onelink.me/vYP0?pid=User_invite&c=PlaywithFriends&af_web_dp=http%3A%2F%2Fwww.ihago.net%2F&af_dp=olaparty%3A%2F%2Fdp_olaparty%2FhomePage";
                break;
            }
            case 1: {
                mAfUrl = "https://olaparty.onelink.me/vYP0?pid=User_invite&c=PlaywithFriends&af_web_dp=http%3A%2F%2Fwww.ihago.net%2F&af_dp=olaparty%3A%2F%2Fdp_olaparty%2FhomePage";
                break;
            }
            default: {
                mAfUrl = "https://olaparty.onelink.me/vYP0?pid=User_invite&c=PlaywithFriends&af_web_dp=http%3A%2F%2Fwww.ihago.net%2F&af_dp=olaparty%3A%2F%2Fdp_olaparty%2FhomePage";
            }
        }
        if (FP.empty((CharSequence)this.mImageUrl)) {
            this.mImageUrl = URLUtils.replaceUrl((String)this.getConfigImage());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(shareUrl);
        if (shareUrl.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        String args = String.format("uid=%d&h=%d&lang=%s&img=%s&jumpUrl=%s&title=%s&desc=%s", AccountUtil.getUid(), UriProvider.getIdc(), this.urlEncoderStr(SystemUtils.getLangAndCountry()), this.mImageUrl, this.urlEncoderStr(mAfUrl), this.getShareTitle(true), this.getShareSubtitle(true));
        sb.append(args);
        return sb.toString();
    }

    protected void uploadImageForShare() {
        if (TextUtils.isEmpty((CharSequence)this.mImagePath)) {
            if (this.mIGetShareDataCallback != null) {
                this.mIGetShareDataCallback.getShareDataSuccess(false);
            }
            return;
        }
        String fileName = System.currentTimeMillis() + "profileshare.jpg";
        ((IOOSService)this.mServiceManager.getService(IOOSService.class)).uploadFile(fileName, this.mImagePath, new IUploadObjectCallBack(){

            public void onSuccess(UploadObjectRequest request) {
                AbstractShareModel.this.mImageUrl = URLUtils.replaceUrl((String)request.mUrl);
                AbstractShareModel.this.createShortUrl();
            }

            public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                MLog.info((Object)AbstractShareModel.TAG, (String)"upload image onFailure", (Object[])new Object[]{errorCode});
                AbstractShareModel.this.mImageUrl = "";
                AbstractShareModel.this.createShortUrl();
            }
        });
    }

    protected void createShortUrl() {
        String url = this.getShareUrl();
        ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

            public void onSuccess(String input, String shortUrl) {
                MLog.info((Object)AbstractShareModel.TAG, (String)("get short url success\uff1a" + shortUrl), (Object[])new Object[0]);
                AbstractShareModel.this.mShortUrl = shortUrl;
                if (AbstractShareModel.this.mIGetShareDataCallback != null) {
                    AbstractShareModel.this.mIGetShareDataCallback.getShareDataSuccess(true);
                }
            }

            public void onError(String input, int code, String msg) {
                AbstractShareModel.this.mShortUrl = AbstractShareModel.this.getShareUrl().replace(" ", "");
                MLog.info((Object)AbstractShareModel.TAG, (String)("get short url onFailure\uff1a" + AbstractShareModel.this.mShortUrl), (Object[])new Object[0]);
                if (AbstractShareModel.this.mIGetShareDataCallback != null) {
                    AbstractShareModel.this.mIGetShareDataCallback.getShareDataSuccess(true);
                }
            }
        });
    }

    protected String urlEncoderStr(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    protected void calLayoutParams(View view2) {
        if (view2 == null) {
            return;
        }
        view2.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        view2.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view2.layout(0, 0, view2.getMeasuredWidth(), view2.getMeasuredHeight());
    }

    protected String getShareShortUrl() {
        return this.mShortUrl;
    }

    protected String getShareImagePath() {
        return this.mImagePath;
    }

    protected String getShareImageUrl() {
        return this.mImageUrl;
    }

    public void cancelCallback() {
        this.mIGetShareDataCallback = null;
    }

    protected abstract void startGetShareData(Context var1);

    protected abstract String getShareTitle(boolean var1);

    protected abstract String getShareSubtitle(boolean var1);

    protected abstract String getShareUrl();
}

