/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.share;

import android.app.Activity;
import android.content.Context;
import android.net.wifi.WifiManager;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.permission.Action;
import com.yy.appbase.permission.AndPermission;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.share.ShareChannel;
import com.yy.hiyo.share.base.BaseShareChannel;
import java.util.List;

public class YYShareXender {
    private static INotify mForegroundChangedNotify;
    private static final String TAG = "YYShareXender";
    private static final String SHARE_KEY = "from_hago_hash";
    private static boolean isInit;

    private static void init(FragmentActivity activity) {
        if (!isInit) {
            isInit = true;
            if (YYShareXender.isEnableXender()) {
                // empty if block
            }
        }
    }

    public static void reportNewInstall(FragmentActivity activity) {
        if (RuntimeContext.isStartAtFirstInstalled()) {
            YYShareXender.init(activity);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (YYShareXender.isEnableXender()) {
                        // empty if block
                    }
                }
            });
        }
    }

    public void share(FragmentActivity activity) {
        if (YYShareXender.isEnableXender()) {
            YYShareXender.init(activity);
        }
    }

    public static boolean isEnableXender() {
        return false;
    }

    private void startRestoreWifiTask(final FragmentActivity activity) {
        boolean isFromWifi = NetworkUtils.isWifiActive((Context)activity);
        MLog.info((Object)TAG, (String)"startRestoreWifiTask \u662f\u5426\u9700\u8981\u6062\u590dwifi\uff0cisFromWifi %b", (Object[])new Object[]{isFromWifi});
        if (isFromWifi) {
            this.unregisterNotify();
            if (mForegroundChangedNotify == null) {
                mForegroundChangedNotify = new INotify(){

                    public void notify(Notification notification) {
                        MLog.info((Object)YYShareXender.TAG, (String)"notify obj %s, wifiActive %b, isNetworkAvailable %b, isWSConnected %b", (Object[])new Object[]{notification.extObj, NetworkUtils.isWifiActive((Context)activity), NetworkUtils.isNetworkAvailable((Context)activity), ProtoManager.getInstance().isWSConnected()});
                        if (notification.extObj instanceof Boolean && Boolean.TRUE.equals(notification.extObj) && !ProtoManager.getInstance().isWSConnected()) {
                            MLog.info((Object)YYShareXender.TAG, (String)"\u8bf7\u6c42\u5f00\u542f wifi \u6743\u9650", (Object[])new Object[0]);
                            AndPermission.with((Activity)activity).permission(new String[]{"android.permission.CHANGE_WIFI_STATE"}).onGranted(new Action(){

                                public void onAction(List<String> permissions) {
                                    MLog.info((Object)YYShareXender.TAG, (String)"\u6062\u590dwifi \u6388\u6743\u6210\u529f%s", (Object[])new Object[]{activity});
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            WifiManager wifiManager = SystemServiceUtils.getWifiManager((Context)activity.getApplicationContext());
                                            wifiManager.setWifiEnabled(true);
                                            MLog.info((Object)YYShareXender.TAG, (String)"setWifiEnabled %s", (Object[])new Object[]{activity});
                                        }
                                    }, (long)1500L);
                                    YYShareXender.this.unregisterNotify();
                                }
                            }).onDenied(new Action(){

                                public void onAction(List<String> permissions) {
                                    MLog.error((Object)YYShareXender.TAG, (String)"\u6062\u590dwifi \u6388\u6743 \u5931\u8d25", (Object[])new Object[0]);
                                    YYShareXender.this.unregisterNotify();
                                }
                            }).start();
                        }
                    }
                };
            }
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, mForegroundChangedNotify);
        } else {
            this.unregisterNotify();
        }
    }

    public BaseShareChannel createXenderChannel() {
        return ShareChannel.createChannelById(12);
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        this.unregisterNotify();
        mForegroundChangedNotify = null;
    }

    private void unregisterNotify() {
        if (mForegroundChangedNotify != null) {
            NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, mForegroundChangedNotify);
        }
    }

    static {
        isInit = false;
    }
}

