/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.invite;

import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IInviteFriendService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.relation.base.friend.IFriendServices;
import com.yy.hiyo.relation.base.friend.data.FriendInfo;
import com.yy.hiyo.relation.base.friend.data.FriendInfoList;
import common.Header;
import ikxd.apigateway.ApiGateway;
import ikxd.apigateway.GetHFAFriendsReq;
import ikxd.apigateway.GetHFAFriendsRes;
import ikxd.apigateway.Uri;
import ikxd.apigateway.UserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InviteFriendService
implements IInviteFriendService {
    public void requestList(final @NotNull IInviteFriendService.IInviteFriendCallback callback, String gid) {
        GetHFAFriendsReq req = new GetHFAFriendsReq.Builder().game_id(gid).need_bifollow(Boolean.valueOf(true)).need_is_follow(Boolean.valueOf(true)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_apigateway_d");
        ApiGateway gateway = new ApiGateway.Builder().header(header).get_hfa_friends_req(req).uri(Uri.kUriGetHFAFriendsReq).build();
        ProtoManager.getInstance().send((AndroidMessage)gateway, (IProtoCallback)new IProtoCallback<ApiGateway>(){

            public void onResponse(@Nullable ApiGateway apiGateway) {
                if (apiGateway == null) {
                    FeatureLog.i((String)"FTInvite", (String)"\u83b7\u53d6\u597d\u53cb\u5217\u8868 error, proto is null", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.loadFail();
                        }
                    });
                    return;
                }
                GetHFAFriendsRes getHFAFriendsRes = apiGateway.get_hfa_friends_res;
                List userInfos = getHFAFriendsRes.users;
                ArrayList<InviteFriendData> list = new ArrayList<InviteFriendData>();
                ArrayList<Long> uidList = new ArrayList<Long>();
                for (UserInfo userInfo : userInfos) {
                    FindFriend friend = FindFriend.transform((UserInfo)userInfo);
                    InviteFriendData inviteFriendData = new InviteFriendData(friend);
                    if (!friend.isOnline()) {
                        inviteFriendData.inviteState = 3;
                    }
                    list.add(inviteFriendData);
                    uidList.add(friend.getUid());
                }
                InviteFriendService.this.appendLocalHagoFriends(list, callback);
                FeatureLog.i((String)"FTInvite", (String)"\u83b7\u53d6\u597d\u53cb\u5217\u8868 success, size:%d, uids:%s", (Object[])new Object[]{list.size(), uidList});
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTInvite", (String)("\u83b7\u53d6\u597d\u53cb\u5217\u8868 timeout:" + canRetry), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.loadFail();
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.i((String)"FTInvite", (String)"\u83b7\u53d6\u597d\u53cb\u5217\u8868 error:%s ,code:%d", (Object[])new Object[]{reason, code});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.loadFail();
                    }
                });
                return false;
            }
        });
    }

    private void removeFriends(List<FriendInfo> localHagoFriends, long uid) {
        for (FriendInfo friendData : localHagoFriends) {
            if (friendData.getUserInfo().uid != uid) continue;
            localHagoFriends.remove(friendData);
            break;
        }
    }

    private void appendLocalHagoFriends(final @NotNull List<InviteFriendData> remoteList, final @NotNull IInviteFriendService.IInviteFriendCallback callback) {
        FeatureLog.i((String)"FTInvite", (String)"\u9080\u8bf7\u5217\u8868\u8865\u5145\u672c\u5730\u901a\u8baf\u5f55\u7684Hago\u597d\u53cb", (Object[])new Object[0]);
        UserInfoModule userInfoModule = (UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class);
        FriendInfoList localHagoFriends = ((IFriendServices)ServiceManagerProxy.getInstance().getService(IFriendServices.class)).reqFriendList(false);
        List friendInfos = localHagoFriends.getFriendList();
        if (FP.empty((Collection)localHagoFriends.getFriendList())) {
            callback.loadSuccess(remoteList);
            return;
        }
        for (InviteFriendData friendData : remoteList) {
            if (friendData == null || friendData.mFriend == null) continue;
            long uid = friendData.mFriend.getUid();
            this.removeFriends(friendInfos, uid);
        }
        FeatureLog.i((String)"FTInvite", (String)"remote list size:%d, local list size:%d", (Object[])new Object[]{remoteList.size(), friendInfos.size()});
        for (FriendInfo friendInfo : friendInfos) {
            FindFriend findFriend = FindFriend.transform((UserInfoKS)friendInfo.getUserInfo());
            InviteFriendData inviteFriendData = new InviteFriendData(findFriend);
            inviteFriendData.inviteState = 3;
            remoteList.add(inviteFriendData);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                callback.loadSuccess(remoteList);
                FeatureLog.i((String)"FTInvite", (String)"\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u6570\u636e\u6210\u529f", (Object[])new Object[0]);
            }
        });
    }
}

