/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.hiyo.share.base.ShareItemClickListener;
import java.util.List;

public class ShareDialog
implements BaseDialog,
View.OnClickListener {
    private View rootView;
    protected LinearLayout llShareContainer;
    private ShareItemClickListener itemClickListener;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private Dialog dialog;
    private List<BaseShareChannel> shareChannelList;

    public ShareDialog(List<BaseShareChannel> shareChannelList) {
        this.shareChannelList = shareChannelList;
    }

    public void init(Dialog dialog) {
        this.dialog = dialog;
        this.rootView = LayoutInflater.from((Context)dialog.getContext()).inflate(this.getLayoutId(), null);
        this.llShareContainer = (LinearLayout)this.rootView.findViewById(R.id.ll_share_container);
        this.initChannels();
        dialog.setContentView(this.rootView);
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        if (this.mOnDismissListener != null) {
            dialog.setOnDismissListener(this.mOnDismissListener);
        }
        Window window = dialog.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        params.gravity = 80;
        params.height = -2;
        params.width = -1;
        window.setAttributes(params);
        window.setWindowAnimations(R.style.DialogAnimation);
    }

    protected View getRootView() {
        return this.rootView;
    }

    protected int getLayoutId() {
        return R.layout.dialog_share;
    }

    private void initChannels() {
        if (this.shareChannelList == null) {
            return;
        }
        for (BaseShareChannel channel : this.shareChannelList) {
            View itemView = LayoutInflater.from((Context)this.llShareContainer.getContext()).inflate(R.layout.share_channel_item, (ViewGroup)this.llShareContainer, false);
            ImageView ivIcon = (ImageView)itemView.findViewById(R.id.icon);
            TextView textView = (TextView)itemView.findViewById(R.id.text);
            if (this.shareChannelList.indexOf(channel) == 0) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)itemView.getLayoutParams();
                lp.leftMargin = ResolutionUtils.dip2Px((float)5.0f);
                lp.setMarginStart(lp.leftMargin);
            }
            int iconResId = 0;
            int idResId = 0;
            int textResId = 0;
            switch (channel.getId()) {
                case 5: {
                    iconResId = R.drawable.share_facebook_icon_selector;
                    idResId = R.id.share_platform_facebook;
                    textResId = R.string.share_platform_facebook;
                    break;
                }
                case 3: {
                    iconResId = R.drawable.share_ins_icon_selector;
                    idResId = R.id.share_platform_instagram;
                    textResId = R.string.share_platform_instagram;
                    break;
                }
                case 1: {
                    iconResId = R.drawable.share_line_icon_selector;
                    idResId = R.id.share_platform_line;
                    textResId = R.string.share_platform_line;
                    break;
                }
                case 2: {
                    iconResId = R.drawable.share_whatspp_icon_selector;
                    idResId = R.id.share_platform_whatsapp;
                    textResId = R.string.share_platform_whatsapp;
                    break;
                }
                case 6: {
                    iconResId = R.drawable.share_messenger_icon_selector;
                    idResId = R.id.share_platform_messenger;
                    textResId = R.string.share_platform_messenger;
                    break;
                }
                case 9: {
                    iconResId = R.drawable.share_vk_icon_selector;
                    idResId = R.id.share_platform_vk;
                    textResId = R.string.share_platform_vk;
                    break;
                }
                case 11: {
                    iconResId = R.drawable.ico_share_zalo;
                    idResId = R.id.share_platform_zalo;
                    textResId = R.string.share_platform_zalo;
                    break;
                }
                case 13: {
                    iconResId = R.drawable.share_native;
                    idResId = R.id.share_native;
                    textResId = R.string.friends;
                    break;
                }
                case 0: {
                    iconResId = R.drawable.selector_share_others;
                    idResId = R.id.share_others;
                    textResId = R.string.share_platform_other;
                    break;
                }
                case 10: {
                    idResId = R.id.share_copy_link;
                    iconResId = R.drawable.selector_share_copylink;
                    textResId = R.string.title_share_copy_link;
                    break;
                }
            }
            if (textResId <= 0) continue;
            ivIcon.setImageResource(iconResId);
            ivIcon.setId(idResId);
            textView.setText(textResId);
            this.llShareContainer.addView(itemView);
            ivIcon.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setItemClickListener(ShareItemClickListener listener) {
        this.itemClickListener = listener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public int getId() {
        return 0;
    }

    public void onClick(View v) {
        int shareChannelId = ShareChannelIdDef.getChannelIdByViewId((int)v.getId());
        if (shareChannelId != -1 && this.itemClickListener != null) {
            this.itemClickListener.onShareItemClick(shareChannelId);
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    protected void dismiss() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }
}

