/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.cardview.widget.CardView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.share.R;

public class CenterDialog
implements BaseDialog,
View.OnClickListener,
DialogInterface.OnDismissListener {
    private Dialog mDialog;
    private View mRootView;
    private CardView mContentContainer;
    private FrameLayout mShareImageContainer;
    private View mCancelBtn;
    private View mContentView;
    private View mShareImage;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private boolean isCancelOnTouchOutside = false;

    public void init(Dialog dialog) {
        this.mDialog = dialog;
        this.mRootView = LayoutInflater.from((Context)dialog.getContext()).inflate(R.layout.dialog_center_share, null);
        this.mRootView.setOnClickListener((View.OnClickListener)this);
        this.mContentContainer = (CardView)this.mRootView.findViewById(R.id.cv_content);
        this.mShareImageContainer = (FrameLayout)this.mRootView.findViewById(R.id.share_image_container);
        this.mCancelBtn = this.mRootView.findViewById(R.id.iv_cancel);
        this.mCancelBtn.setOnClickListener((View.OnClickListener)this);
        if (this.mContentView != null) {
            if (this.mContentView.getParent() instanceof ViewGroup) {
                if (this.mContentView.getParent() != this.mContentContainer) {
                    ((ViewGroup)this.mContentView.getParent()).removeView(this.mContentView);
                    this.mContentContainer.addView(this.mContentView);
                }
            } else {
                this.mContentContainer.addView(this.mContentView);
            }
        }
        if (this.mShareImage != null) {
            if (this.mShareImage.getParent() instanceof ViewGroup) {
                if (this.mShareImage.getParent() != this.mShareImageContainer) {
                    ((ViewGroup)this.mShareImage.getParent()).removeView(this.mShareImage);
                    this.mShareImageContainer.addView(this.mShareImage);
                }
            } else {
                this.mShareImageContainer.addView(this.mShareImage);
            }
        }
        dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        dialog.setCanceledOnTouchOutside(this.isCancelOnTouchOutside);
        dialog.setContentView(this.mRootView);
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.width = ResolutionUtils.getScreenWidth((Context)dialog.getContext());
        dialog.getWindow().setAttributes(lp);
    }

    public void setContentView(View contentView) {
        this.mContentView = contentView;
    }

    public void setShareImage(View shareImage) {
        this.mShareImage = shareImage;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.isCancelOnTouchOutside = canceledOnTouchOutside;
        if (this.mDialog != null) {
            this.mDialog.setCanceledOnTouchOutside(this.isCancelOnTouchOutside);
        }
    }

    public int getId() {
        return DialogId.CenterDialog;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_cancel) {
            this.dismiss();
        } else if (v == this.mRootView && this.isCancelOnTouchOutside) {
            this.dismiss();
        }
    }

    private void dismiss() {
        if (this.mDialog == null) {
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.mContentView != null) {
            this.mContentContainer.removeView(this.mContentView);
            this.mContentView = null;
        }
        if (this.mShareImage != null) {
            this.mShareImageContainer.removeView(this.mShareImage);
            this.mShareImage = null;
        }
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }
}

