/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.VietnamInviteFriendConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.InviteCardModel;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;

public class VietnamInviteCardModel
extends InviteCardModel {
    private static final String TAG = "VietnamInviteCardModel";
    private String defaultBgUrl = "https://o-sg.ihago.net/ikxd/2fd0d9fa21dd05d7dfab35a7067b9c7e/vietnam_share_bg.png";

    public VietnamInviteCardModel(UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        super(userInfoKS, serviceManager, dialogLinkManager);
    }

    @Override
    protected void startGetShareData(Context context) {
        this.checkShareBg(context);
    }

    private void checkShareBg(Context context) {
        String shareBgUrl = this.defaultBgUrl;
        VietnamInviteFriendConfig config = (VietnamInviteFriendConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.VIETNAM_INVITE_FRIEND);
        if (config != null && !FP.empty((CharSequence)config.getShareBg())) {
            shareBgUrl = config.getShareBg();
        }
        shareBgUrl = URLUtils.replaceUrl((String)shareBgUrl);
        this.checkFileIsExist(context, shareBgUrl);
    }

    private void checkFileIsExist(Context context, String url) {
        String fileName = MD5Utils.getMD5String((String)url) + ".png";
        String imageDirPath = YYFileUtils.getRootDir() + "/share" + File.separator;
        String imagePath = imageDirPath + fileName;
        File file = new File(imagePath);
        if (file.exists()) {
            this.onReadyData(url, imagePath);
            return;
        }
        MLog.info((Object)TAG, (String)"checkFileIsExit need to download : %s", (Object[])new Object[]{url});
        this.downloadFile(url, imageDirPath, fileName);
    }

    private void downloadFile(final String url, String parentPath, String fileName) {
        Downloader.Builder builder = new Downloader.Builder(url, parentPath, fileName);
        int priority = 100;
        builder.setPriority(priority);
        builder.setSupportContinueTransfer(true);
        builder.setCallBack(new IDownloadCallback(){

            public void onComplete(Downloader downloader) {
                MLog.info((Object)VietnamInviteCardModel.TAG, (String)"downloadFile onComplete onResourceReady", (Object[])new Object[0]);
                VietnamInviteCardModel.this.onReadyData(url, downloader.getFilePath());
            }

            public void onError(Downloader downloader, int errorType, String errorInfo) {
                MLog.info((Object)VietnamInviteCardModel.TAG, (String)"downloadFile onError errorType: %s errorInfo: %s", (Object[])new Object[]{errorType, errorInfo});
                VietnamInviteCardModel.this.onReadyData(url, url);
            }

            public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
            }

            public void onStart(Downloader downloader) {
                MLog.info((Object)VietnamInviteCardModel.TAG, (String)"download onStart!! : %s", (Object[])new Object[]{downloader.getFilePath()});
            }
        });
        Downloader downloader = builder.build();
        downloader.start();
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.title_vietnam_invite));
        }
        return ResourceUtils.getString((int)R.string.title_vietnam_invite);
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.tip_vietnam_invite_content));
        }
        return ResourceUtils.getString((int)R.string.tip_vietnam_invite_content);
    }

    private void onReadyData(String url, String imagePath) {
        this.mImagePath = imagePath;
        this.mImageUrl = url;
        MLog.info((Object)TAG, (String)"onReadyData imagePath: %s  url: %s", (Object[])new Object[]{imagePath, url});
        this.createShortUrl();
    }
}

