/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.IShareCardImageFinishLoadedCallback;
import java.util.List;

public class ProfileShareCardView
extends YYRelativeLayout {
    private Context mContext;
    private RoundConerImageView mIvAvatar;
    private RoundConerImageView mIvFavGameIcon1;
    private RoundConerImageView mIvFavGameIcon2;
    private YYTextView mTvFavGamePlay1;
    private YYTextView mTvFavGamePlay2;
    private YYTextView mTvUserID;
    private IShareCardImageFinishLoadedCallback mCallback;
    private boolean mAvatarFinishLoaded;
    private boolean mIcon1FinishLoaded;
    private boolean mIcon2FinishLoaded;
    private boolean mHadDraw;

    public ProfileShareCardView(Context context) {
        super(context);
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.layout_profile_share_card, (ViewGroup)this, true);
        this.mIvAvatar = (RoundConerImageView)this.findViewById(R.id.iv_avatar);
        this.mIvFavGameIcon1 = (RoundConerImageView)this.findViewById(R.id.iv_favgame_icon1);
        this.mIvFavGameIcon2 = (RoundConerImageView)this.findViewById(R.id.iv_favgame_icon2);
        this.mTvFavGamePlay1 = (YYTextView)this.findViewById(R.id.tv_favgame_play1);
        this.mTvFavGamePlay2 = (YYTextView)this.findViewById(R.id.tv_favgame_play2);
        this.mTvUserID = (YYTextView)this.findViewById(R.id.tv_user_id);
        this.mTvFavGamePlay1.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mTvFavGamePlay2.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mTvUserID.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
    }

    public void updateProfileShareCard(UserInfoKS userInfoKS, List<GameHistoryBean> list, IShareCardImageFinishLoadedCallback callback) {
        if (userInfoKS == null || callback == null) {
            return;
        }
        this.mHadDraw = false;
        String icon1Url = "";
        String icon2Url = "";
        if (list != null && list.size() == 1) {
            GameHistoryBean gameHistoryBean = list.get(0);
            this.setSpannableStyleText(this.mTvFavGamePlay1, ResourceUtils.getString((int)R.string.play), " " + gameHistoryBean.totalCount);
            icon1Url = gameHistoryBean.iconUrl;
        } else if (list != null && list.size() >= 2) {
            GameHistoryBean gameHistoryBean = list.get(0);
            this.setSpannableStyleText(this.mTvFavGamePlay1, ResourceUtils.getString((int)R.string.play), " " + gameHistoryBean.totalCount);
            icon1Url = gameHistoryBean.iconUrl;
            gameHistoryBean = list.get(1);
            this.setSpannableStyleText(this.mTvFavGamePlay2, ResourceUtils.getString((int)R.string.play), " " + gameHistoryBean.totalCount);
            icon2Url = gameHistoryBean.iconUrl;
        }
        this.mCallback = callback;
        this.mTvUserID.setText((CharSequence)(ResourceUtils.getString((int)R.string.short_summary_id) + userInfoKS.vid));
        ImageLoader.loadImage((ImageView)this.mIvAvatar, (String)(userInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex), (int)AvatarUtils.getDefaultAvatar((int)userInfoKS.sex), (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                ProfileShareCardView.this.mAvatarFinishLoaded = true;
                ProfileShareCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                ProfileShareCardView.this.mAvatarFinishLoaded = true;
                ProfileShareCardView.this.hadImageFinishLoaded();
            }
        });
        ImageLoader.loadImage((ImageView)this.mIvFavGameIcon1, (String)icon1Url, (int)R.drawable.ico_share_game_sheep, (int)R.drawable.ico_share_game_sheep, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                ProfileShareCardView.this.mIcon1FinishLoaded = true;
                ProfileShareCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                ProfileShareCardView.this.mIcon1FinishLoaded = true;
                ProfileShareCardView.this.hadImageFinishLoaded();
            }
        });
        ImageLoader.loadImage((ImageView)this.mIvFavGameIcon2, (String)icon2Url, (int)R.drawable.ico_share_game_knife, (int)R.drawable.ico_share_game_knife, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
                ProfileShareCardView.this.mIcon2FinishLoaded = true;
                ProfileShareCardView.this.hadImageFinishLoaded();
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                ProfileShareCardView.this.mIcon2FinishLoaded = true;
                ProfileShareCardView.this.hadImageFinishLoaded();
            }
        });
        this.invalidate();
    }

    private void hadImageFinishLoaded() {
        if (this.mCallback != null && this.mAvatarFinishLoaded && this.mIcon1FinishLoaded && this.mIcon2FinishLoaded && !this.mHadDraw) {
            this.mHadDraw = true;
            this.genImageAndSaveToAlbum();
        }
    }

    private void setSpannableStyleText(YYTextView tv, String frontStr, String backStr) {
        SpannableStringBuilder style2 = new SpannableStringBuilder((CharSequence)(frontStr + backStr));
        style2.setSpan((Object)new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.white)), 0, frontStr.length(), 33);
        tv.setText((CharSequence)style2);
    }

    private void genImageAndSaveToAlbum() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ViewImage.getViewBitmap((View)ProfileShareCardView.this);
                if (bitmap == null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProfileShareCardView.this.mCallback.onImageFinishLoaded("");
                        }
                    });
                    return;
                }
                String imagePath = YYFileUtils.getYYTempDir();
                String imageName = "profileshare";
                final String saveResult = ViewImage.saveImgToLocal((Bitmap)bitmap, (String)imageName, (String)imagePath, (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProfileShareCardView.this.mCallback.onImageFinishLoaded(saveResult);
                    }
                });
            }
        });
    }
}

