/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.sharetype;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.sharetype.AbstractShareModel;
import java.io.File;

public class AdPictureCardModel
extends AbstractShareModel {
    private static final String SHARE_IMG_DIR = "share_img";
    private static final String SHARE_IMG_FILE_TMP = "share_img_tmp";
    private boolean mIsNeedDownloadImage;

    public AdPictureCardModel(boolean isNeedDownloadImage, UserInfoKS userInfoKS, IServiceManager serviceManager, DialogLinkManager dialogLinkManager) {
        super(userInfoKS, serviceManager, dialogLinkManager);
        this.mIsNeedDownloadImage = isNeedDownloadImage;
    }

    @Override
    protected void startGetShareData(Context context) {
        if (!this.mIsNeedDownloadImage) {
            this.createShortUrl();
            return;
        }
        YYTaskExecutor.execute(() -> {
            this.mImageUrl = this.getConfigImage();
            String imgPath = this.getPath(this.mImageUrl);
            if (YYFileUtils.isFileExisted((String)imgPath)) {
                this.mImagePath = imgPath;
                this.createShortUrl();
            } else {
                String tmpFilePath = this.getTmpPath();
                if (YYFileUtils.isPathExist((String)tmpFilePath)) {
                    YYFileUtils.removeFile((String)tmpFilePath);
                } else {
                    this.downloadFile(tmpFilePath, imgPath);
                }
            }
        });
    }

    private void downloadFile(String tmpFilePath, final String imgPath) {
        HttpUtil.downloadFile((String)this.mImageUrl, (String)tmpFilePath, (Callback)new Callback<File>(){

            public void onResponse(Call<File> call, Response<File> response) {
                FeatureLog.e((String)"FTQuicFileDownload", (String)"AdPictureCardModel sucess", (Object[])new Object[0]);
                YYTaskExecutor.execute(() -> {
                    YYFileUtils.renameFile((String)((File)response.body()).getAbsolutePath(), (String)imgPath);
                    AdPictureCardModel.this.mImagePath = ((File)response.body()).getAbsolutePath();
                }, AdPictureCardModel.this::createShortUrl);
            }

            public void onFailure(Call<File> call, Throwable e) {
                FeatureLog.e((String)"FTQuicFileDownload", (String)("AdPictureCardModel error e = " + e), (Object[])new Object[0]);
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.network_error), (int)0);
                if (AdPictureCardModel.this.mIGetShareDataCallback != null) {
                    AdPictureCardModel.this.mIGetShareDataCallback.getShareDataSuccess(false);
                }
            }
        });
    }

    private String getPath(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String extensionName = ".jpg";
        int index = url.lastIndexOf(".");
        if (index != -1) {
            extensionName = url.substring(index);
        }
        String fileName = "";
        if (Build.VERSION.SDK_INT <= 21 && SettingFlags.getBoolean((String)"md5string", (boolean)true)) {
            url = url.replace(".", "");
            String urlFixed = FileUtils.fixFileName((String)url);
            fileName = urlFixed + extensionName;
        } else {
            fileName = MD5Utils.getMD5String((String)url) + extensionName;
        }
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + SHARE_IMG_DIR + File.separator + fileName;
    }

    private String getTmpPath() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + SHARE_IMG_DIR + File.separator + SHARE_IMG_FILE_TMP;
    }

    @Override
    protected String getShareTitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.title_invite_share_title));
        }
        return ResourceUtils.getString((int)R.string.title_invite_share_title);
    }

    @Override
    protected String getShareSubtitle(boolean needEncode) {
        if (needEncode) {
            return this.urlEncoderStr(ResourceUtils.getString((int)R.string.title_invite_share_text));
        }
        return ResourceUtils.getString((int)R.string.title_invite_share_text);
    }

    @Override
    protected String getShareUrl() {
        return this.generateFindFriendShareUrl();
    }
}

