/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.invite;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.share.R;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.invite.IShareSelectListCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class ShareSelectListPage
extends YYLinearLayout
implements View.OnClickListener {
    private IShareSelectListCallback mIShareCallback;
    private LinearLayout platformContainer;
    private SimpleTitleBar mTitleBar;
    private View otherPlatform;
    private YYLinearLayout mLlContentView;

    public ShareSelectListPage(Context context, IShareSelectListCallback callback) {
        super(context);
        ShareSelectListPage.inflate((Context)context, (int)R.layout.share_select_list_page, (ViewGroup)this);
        this.mIShareCallback = callback;
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.stb);
        this.platformContainer = (LinearLayout)this.findViewById(R.id.ll_platform_container);
        this.otherPlatform = this.findViewById(R.id.platform_other);
        this.mLlContentView = (YYLinearLayout)this.findViewById(R.id.ll_content_view);
        this.otherPlatform.setOnClickListener((View.OnClickListener)this);
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.share_platform_title));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View view2) {
                if (ShareSelectListPage.this.mIShareCallback != null) {
                    ShareSelectListPage.this.mIShareCallback.onBack();
                }
            }
        });
        this.initChannels();
    }

    public View getOffsetView() {
        return this.mLlContentView;
    }

    private void initChannels() {
        if (this.mIShareCallback == null) {
            return;
        }
        List<BaseShareChannel> shareChannelList = this.mIShareCallback.isVietnam() ? this.mIShareCallback.getVietnamInviteFriendChannels() : this.mIShareCallback.getChannels();
        if (shareChannelList == null) {
            return;
        }
        if (this.mIShareCallback.isVietnam()) {
            shareChannelList = this.mIShareCallback.getVietnamPlatforms(shareChannelList);
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mTitleBar.getLayoutParams();
            layoutParams.bottomMargin = 0;
            this.mTitleBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addVietnamTipsView();
        }
        for (BaseShareChannel shareChannel : shareChannelList) {
            View platformView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.share_select_list_page_item, (ViewGroup)this.platformContainer, false);
            int idResId = 0;
            int iconResId = 0;
            switch (shareChannel.getId()) {
                case 2: {
                    idResId = R.id.share_platform_whatsapp;
                    iconResId = R.drawable.ico_share_whatsapp_small;
                    break;
                }
                case 5: {
                    idResId = R.id.share_platform_facebook;
                    iconResId = R.drawable.ico_share_facebook_small;
                    break;
                }
                case 7: {
                    idResId = R.id.share_platform_snapchat;
                    iconResId = R.drawable.ico_share_snapchat;
                    break;
                }
                case 3: {
                    idResId = R.id.share_platform_instagram;
                    iconResId = R.drawable.ico_share_ins_small;
                    break;
                }
                case 1: {
                    idResId = R.id.share_platform_line;
                    iconResId = R.drawable.ico_share_line_small;
                    break;
                }
                case 6: {
                    idResId = R.id.share_platform_messenger;
                    iconResId = R.drawable.ico_share_messenger;
                    break;
                }
                case 9: {
                    idResId = R.id.share_platform_vk;
                    iconResId = R.drawable.ico_share_vk;
                    break;
                }
                case 11: {
                    idResId = R.id.share_platform_zalo;
                    iconResId = R.drawable.ico_share_zalo_small;
                    break;
                }
                case 12: {
                    idResId = R.id.share_platform_xender;
                    iconResId = R.drawable.ico_share_xender_small;
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "4").put("page_id", "1"));
                    break;
                }
                case 10: {
                    idResId = R.id.share_copy_link;
                    iconResId = R.drawable.ico_share_copy_link;
                    break;
                }
            }
            TextView tvPlatform = (TextView)platformView.findViewById(R.id.tv_platform);
            YYImageView ivPlatform = (YYImageView)platformView.findViewById(R.id.iv_platform);
            tvPlatform.setText(shareChannel.getNameResId());
            platformView.setId(idResId);
            platformView.setOnClickListener((View.OnClickListener)this);
            ivPlatform.setImageResource(iconResId);
            ViewGroup.LayoutParams lp = ivPlatform.getLayoutParams();
            if (lp != null) {
                int size;
                lp.width = size = ResolutionUtils.dip2Px((float)30.0f);
                lp.height = size;
                ivPlatform.setLayoutParams(lp);
            }
            if (this.mIShareCallback.isVietnam()) {
                YYTextView hotText = (YYTextView)platformView.findViewById(R.id.tv_hot);
                for (int i = 0; i < this.mIShareCallback.getVietnamHotPlatform().size(); ++i) {
                    if (!StringUtils.equalsIgnoreCase((String)ResourceUtils.getString((int)shareChannel.getNameResId()), (String)this.mIShareCallback.getVietnamHotPlatform().get(i))) continue;
                    hotText.setVisibility(0);
                    break;
                }
            }
            this.platformContainer.addView(platformView);
        }
    }

    private void addVietnamTipsView() {
        YYTextView tipsView = new YYTextView(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = ResolutionUtils.dip2Px((float)15.0f);
        layoutParams.rightMargin = ResolutionUtils.dip2Px((float)15.0f);
        layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)3.0f);
        layoutParams.topMargin = ResolutionUtils.dip2Px((float)3.0f);
        tipsView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        tipsView.setTextColor(ColorUtils.parseColor((String)"#999999"));
        tipsView.setTextSize(2, 11.0f);
        tipsView.setLineSpacing(10.0f, 1.0f);
        tipsView.setText((CharSequence)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_vietnam_invite_platform), (Object[])new Object[]{this.mIShareCallback.getVietnamTipsPlatform()}));
        this.platformContainer.addView((View)tipsView);
    }

    public void onClick(View view2) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                }
            }
        });
        if (view2.getId() == R.id.share_platform_whatsapp) {
            this.share(2);
            this.reportShare("3");
        } else if (view2.getId() == R.id.share_platform_vk) {
            this.share(9);
            this.reportShare("6");
        } else if (view2.getId() == R.id.share_platform_facebook) {
            this.share(5);
            this.reportShare("1");
        } else if (view2.getId() == R.id.share_platform_messenger) {
            this.share(6);
        } else if (view2.getId() == R.id.share_platform_instagram) {
            this.share(3);
            this.reportShare("4");
        } else if (view2.getId() == R.id.share_platform_line) {
            this.share(1);
            this.reportShare("2");
        } else if (view2.getId() == R.id.platform_other) {
            this.share(0);
            this.reportShare("5");
        } else if (view2.getId() == R.id.share_platform_zalo) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "3").put("page_id", "1"));
            this.share(11);
        } else if (view2.getId() == R.id.share_platform_xender) {
            this.share(12);
            this.reportShare("12");
        } else if (view2.getId() == R.id.share_copy_link) {
            this.share(10);
        } else if (view2.getId() == R.id.share_platform_snapchat) {
            this.share(7);
            this.reportShare("13");
        }
    }

    private void share(int channelId) {
        if (this.mIShareCallback != null) {
            this.mIShareCallback.onShare(channelId, "invitefriend");
        }
    }

    private void reportShare(String channel) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "1").put("share_channel", channel));
    }
}

