/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.download.request;

import android.os.Build;
import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.download.request.DownloadRequest;
import java.io.File;

public class ImageDownloadRequest
extends DownloadRequest {
    private ImageDownloadRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String SHARE_IMG_DIR = "share_img";
        private ImageDownloadRequest downloadRequest = new ImageDownloadRequest();

        public Builder url(String url) {
            this.downloadRequest.downloadInfo.setUrl(url);
            this.downloadRequest.downloadInfo.setPath(this.getPathByUrl(url));
            return this;
        }

        public Builder callback(DownloadCallback callback) {
            this.downloadRequest.downloadCallback = callback;
            return this;
        }

        public ImageDownloadRequest build() {
            return this.downloadRequest;
        }

        private String getPathByUrl(String url) {
            String fileName;
            if (TextUtils.isEmpty((CharSequence)url)) {
                return null;
            }
            String extensionName = ".jpg";
            int index = url.lastIndexOf(".");
            if (index != -1) {
                extensionName = url.substring(index);
            }
            if (Build.VERSION.SDK_INT <= 21 && SettingFlags.getBoolean((String)"md5string", (boolean)true)) {
                url = url.replace(".", "");
                String urlFixed = FileUtils.fixFileName((String)url);
                fileName = "image" + urlFixed + extensionName;
            } else {
                fileName = MD5Utils.getMD5String((String)url) + extensionName;
            }
            String dir = FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + SHARE_IMG_DIR + File.separator + fileName;
            MLog.debug((Object)ImageDownloadRequest.class.getSimpleName(), (String)"ImageDownloadRequest dir %s", (Object[])new Object[]{dir});
            return dir;
        }
    }
}

