/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.dir;

import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.File;

public class ShareDirManager {
    private static final String SHARE_DIR_NAME = "share";
    private static final String TMP_DIR_NAME = "tmp";
    private File mShareDir;
    private File mTmpDir;

    private ShareDirManager() {
    }

    public File getShareDir() {
        if (this.mShareDir == null) {
            this.mShareDir = FileStorageUtils.getInstance().getDir(false, SHARE_DIR_NAME);
            if (!this.mShareDir.exists()) {
                this.mShareDir.mkdirs();
            }
        }
        return this.mShareDir;
    }

    public File getShareTmpDir() {
        if (this.mTmpDir == null) {
            File parent = this.getShareDir();
            this.mTmpDir = new File(parent, TMP_DIR_NAME);
            if (!this.mTmpDir.exists()) {
                this.mTmpDir.mkdirs();
            }
        }
        return this.mTmpDir;
    }

    public static ShareDirManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    static class InstanceHolder {
        public static ShareDirManager INSTANCE = new ShareDirManager();

        InstanceHolder() {
        }
    }
}

