/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.dataprovider;

import androidx.annotation.MainThread;
import com.yy.base.logger.MLog;
import com.yy.hiyo.share.base.IShareDataProvider;
import com.yy.hiyo.share.base.OnDataReadyCallback;
import com.yy.hiyo.share.base.ShareBundle;
import com.yy.hiyo.share.base.common.ThreadUtils;
import com.yy.hiyo.share.base.dataprovider.DataCallback;
import com.yy.hiyo.share.base.dataprovider.DataProgressListener;
import com.yy.hiyo.share.base.dataprovider.DataTask;
import com.yy.hiyo.share.base.dataprovider.MutableShareBundle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ShareDataProvider
implements IShareDataProvider {
    private static final String TAG = "ShareDataProvider";
    private long mVersion = 0L;
    private MutableShareBundle mShareBundle = new MutableShareBundle();
    private Queue<DataTask> mBuildTaskQueue = new LinkedList<DataTask>();
    private int mStatus = 0;
    private List<OnDataReadyCallback> mDataReadyCallbacks = new ArrayList<OnDataReadyCallback>();
    private DataProgressListener mBuildProgressListener;

    public ShareDataProvider() {
        this.reset();
    }

    public void reset() {
        ThreadUtils.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ShareDataProvider.this.mVersion > 0L && ShareDataProvider.this.mStatus == 0) {
                    return;
                }
                ShareDataProvider.this.mVersion++;
                ShareDataProvider.this.mShareBundle.reset();
                ShareDataProvider.this.mDataReadyCallbacks.clear();
                ShareDataProvider.this.mBuildTaskQueue.clear();
                BuildTaskType[] buildTasks = ShareDataProvider.this.getOrderedBuildTasks();
                if (buildTasks != null) {
                    for (BuildTaskType taskType : buildTasks) {
                        DataTask task;
                        if (taskType == null || (task = ShareDataProvider.this.createBuildTask(ShareDataProvider.this.mVersion, taskType)) == null) continue;
                        ShareDataProvider.this.mBuildTaskQueue.offer(task);
                    }
                }
                ShareDataProvider.this.mStatus = 0;
            }
        });
    }

    public void setDataBuildProgressListener(DataProgressListener dataBuildProgressListener) {
        this.mBuildProgressListener = dataBuildProgressListener;
    }

    public DataProgressListener getDataBuildProgressListener() {
        return this.mBuildProgressListener;
    }

    public void preload() {
        this.waitDataReady(null);
    }

    public void waitDataReady(final OnDataReadyCallback callback) {
        ThreadUtils.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ShareDataProvider.this.mStatus == 2) {
                    if (callback != null) {
                        callback.onDataReady((ShareBundle)ShareDataProvider.this.mShareBundle);
                    }
                } else if (ShareDataProvider.this.mStatus == 1) {
                    if (callback != null) {
                        ShareDataProvider.this.mDataReadyCallbacks.add(callback);
                    }
                } else {
                    if (callback != null) {
                        ShareDataProvider.this.mDataReadyCallbacks.add(callback);
                    }
                    ShareDataProvider.this.startBuildData();
                }
            }
        });
    }

    private void startBuildData() {
        this.mStatus = 1;
        this.onDataBuildStart();
        this.nextBuildTask();
    }

    private void nextBuildTask() {
        DataTask task = this.mBuildTaskQueue.poll();
        if (task == null) {
            this.onDataReady();
        } else {
            task.run();
        }
    }

    public ShareBundle getShareBundle() {
        return this.mShareBundle;
    }

    protected void onDataBuildStart() {
        if (this.mBuildProgressListener != null) {
            this.mBuildProgressListener.onStart();
        }
    }

    protected void onDataBuildEnd() {
        if (this.mBuildProgressListener != null) {
            this.mBuildProgressListener.onEnd();
        }
    }

    @MainThread
    protected void buildTitle(DataCallback<String> callback) {
        callback.onData(null);
    }

    @MainThread
    protected void buildText(DataCallback<String> callback) {
        callback.onData(null);
    }

    @MainThread
    protected void buildImage(DataCallback<String> callback) {
        callback.onData(null);
    }

    @MainThread
    protected void buildUrl(DataCallback<String> callback) {
        callback.onData(null);
    }

    private void onTitleReady(final long version, final String title) {
        ThreadUtils.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onTitleReady, title:%s", (Object[])new Object[]{title});
                ShareDataProvider.this.mShareBundle.setTitle(title);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onTextReady(final long version, final String text) {
        ThreadUtils.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onTextReady, text:%s", (Object[])new Object[]{text});
                ShareDataProvider.this.mShareBundle.setText(text);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onImageReady(final long version, final String path) {
        ThreadUtils.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onImageReady, image path:%s", (Object[])new Object[]{path});
                ShareDataProvider.this.mShareBundle.setImagePath(path);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onUrlReady(final long version, final String url) {
        ThreadUtils.executeInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onUrlReady, url:%s", (Object[])new Object[]{url});
                ShareDataProvider.this.mShareBundle.setUrl(url);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onDataReady() {
        this.mStatus = 2;
        this.onDataBuildEnd();
        for (OnDataReadyCallback callback : this.mDataReadyCallbacks) {
            callback.onDataReady((ShareBundle)this.mShareBundle);
        }
        this.mDataReadyCallbacks.clear();
    }

    protected BuildTaskType[] getOrderedBuildTasks() {
        return new BuildTaskType[]{BuildTaskType.TASK_TITLE, BuildTaskType.TASK_URL, BuildTaskType.TASK_TEXT, BuildTaskType.TASK_IMAGE};
    }

    private DataTask createBuildTask(long version, BuildTaskType taskType) {
        if (taskType == null) {
            return null;
        }
        DataTask task = null;
        switch (taskType) {
            case TASK_TITLE: {
                task = new DataTask<String>(version){

                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildTitle start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildTitle((DataCallback<String>)this);
                    }

                    public void onData(String data) {
                        ShareDataProvider.this.onTitleReady(this.getVersion(), data);
                    }
                };
                break;
            }
            case TASK_TEXT: {
                task = new DataTask<String>(version){

                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildText start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildText((DataCallback<String>)this);
                    }

                    public void onData(String data) {
                        ShareDataProvider.this.onTextReady(this.getVersion(), data);
                    }
                };
                break;
            }
            case TASK_IMAGE: {
                task = new DataTask<String>(version){

                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildImage start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildImage((DataCallback<String>)this);
                    }

                    public void onData(String data) {
                        ShareDataProvider.this.onImageReady(this.getVersion(), data);
                    }
                };
                break;
            }
            case TASK_URL: {
                task = new DataTask<String>(version){

                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildUrl start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildUrl((DataCallback<String>)this);
                    }

                    public void onData(String data) {
                        ShareDataProvider.this.onUrlReady(this.getVersion(), data);
                    }
                };
                break;
            }
        }
        return task;
    }

    public static enum BuildTaskType {
        TASK_TITLE,
        TASK_TEXT,
        TASK_IMAGE,
        TASK_URL;

    }
}

