/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.channelconfig;

import android.os.Build;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.CountryCodeUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.hiyo.bbs.base.bean.BBSConfig;
import com.yy.hiyo.bbs.base.service.IPostService;
import com.yy.hiyo.share.ShareChannel;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.channelconfig.IShareChannelConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseShareChannelConfig
implements IShareChannelConfig {
    private Map<String, List<BaseShareChannel>> mPageChannelConfigMap = new HashMap<String, List<BaseShareChannel>>();
    private volatile Boolean matchSharePostAbStatus = null;

    public BaseShareChannelConfig() {
        this.initConfig();
    }

    protected void initConfig() {
    }

    public void addPageChannelConfig(String pageName, int[] channelIds) {
        ArrayList<ShareChannel> channelList = null;
        if (channelIds != null) {
            channelList = new ArrayList<ShareChannel>(channelIds.length);
            for (int id2 : channelIds) {
                if (!this.checkChannelValid(id2)) continue;
                channelList.add(ShareChannel.createChannelById(id2));
            }
        }
        this.addPageChannelConfig(pageName, channelList);
    }

    public void addPageChannelConfig(String pageName, List<BaseShareChannel> channelList) {
        if (channelList == null) {
            channelList = Collections.emptyList();
        }
        if (!FP.empty((CharSequence)pageName)) {
            this.mPageChannelConfigMap.put(pageName, channelList);
        }
    }

    @Override
    public List<BaseShareChannel> getChannelsByPage(ISharePage sharePage) {
        if (sharePage == null) {
            return this.getDefaultChannelList();
        }
        List<BaseShareChannel> channelList = this.mPageChannelConfigMap.get(sharePage.getPageName());
        if (channelList == null) {
            channelList = this.getDefaultChannelList();
        }
        return channelList;
    }

    protected List<BaseShareChannel> getDefaultChannelList() {
        return Collections.emptyList();
    }

    public int[] channels(int ... channels) {
        return channels;
    }

    private boolean matchSharePostAb() {
        BBSConfig config;
        if (this.matchSharePostAbStatus != null) {
            return this.matchSharePostAbStatus;
        }
        IPostService postService = (IPostService)ServiceManagerProxy.getService(IPostService.class);
        if (postService != null && (config = (BBSConfig)postService.getBbsConfig().getValue()) != null) {
            this.matchSharePostAbStatus = config.isChannelShareGroup();
        }
        return this.matchSharePostAbStatus != null ? this.matchSharePostAbStatus : false;
    }

    protected boolean checkChannelValid(int channelId) {
        if (channelId != -1) {
            if (channelId == 11 && !CountryCodeUtils.isCountryVietnam()) {
                return false;
            }
            if (channelId == 7) {
                if (Build.VERSION.SDK_INT < 19) {
                    return false;
                }
                if (!(CountryCodeUtils.isCountryAmerica() || CountryCodeUtils.isCountryArabia() || LanguageUtils.isArab())) {
                    return EnvSettings.instance().isTestMode();
                }
            }
            if (channelId == 17) {
                return this.matchSharePostAb();
            }
            return true;
        }
        return false;
    }
}

