/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.base.viewprovider;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.share.base.IShareViewProvider;
import com.yy.hiyo.share.base.OnViewReadyCallback;
import com.yy.hiyo.share.base.common.ThreadUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ShareViewProvider
implements IShareViewProvider {
    private Context mContext;
    private View mShareView;
    private int mStatus = 0;
    private List<OnViewReadyCallback> mViewReadyCallbackList = new ArrayList<OnViewReadyCallback>();
    private List<Object> mViewRenderTaskList = new LinkedList<Object>();
    private Runnable mRenderDelayTask;

    public ShareViewProvider(@NotNull Context context) {
        this.mContext = context;
        this.mShareView = this.createView();
    }

    public Context getContext() {
        return this.mContext;
    }

    protected abstract View createView();

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void initView();

    private void renderView() {
        this.mShareView.setLayoutParams(new ViewGroup.LayoutParams(this.getWidth(), this.getHeight()));
        this.initView();
        this.mShareView.measure(View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000));
        this.mShareView.layout(0, 0, this.mShareView.getMeasuredWidth(), this.mShareView.getMeasuredHeight());
    }

    private void startRenderView() {
        ThreadUtils.executeInMain(new Runnable(){

            @Override
            public void run() {
                ShareViewProvider.this.mStatus = 1;
                Object mainRenderTaskFlag = new Object();
                ShareViewProvider.this.registerViewRenderTask(mainRenderTaskFlag);
                ShareViewProvider.this.renderView();
                ShareViewProvider.this.notifyViewRenderTaskFinish(mainRenderTaskFlag);
            }
        });
    }

    protected final void registerViewRenderTask(final Object taskFlag) {
        ThreadUtils.executeInMain(new Runnable(){

            @Override
            public void run() {
                ShareViewProvider.this.mViewRenderTaskList.add(taskFlag);
            }
        });
    }

    protected final void notifyViewRenderTaskFinish(final Object taskFlag) {
        ThreadUtils.executeInMain(new Runnable(){

            @Override
            public void run() {
                boolean isTaskContained = ShareViewProvider.this.mViewRenderTaskList.remove(taskFlag);
                if (!isTaskContained) {
                    return;
                }
                if (ShareViewProvider.this.mViewRenderTaskList.isEmpty()) {
                    ShareViewProvider.this.startRenderDelayTask();
                }
            }
        });
    }

    private void startRenderDelayTask() {
        if (this.mRenderDelayTask != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRenderDelayTask);
        }
        this.mRenderDelayTask = new Runnable(){

            @Override
            public void run() {
                ShareViewProvider.this.onViewReady();
                ShareViewProvider.this.mRenderDelayTask = null;
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)this.mRenderDelayTask, (long)300L);
    }

    private void cancelRenderDelayTask() {
        if (this.mRenderDelayTask == null) {
            return;
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRenderDelayTask);
        this.mRenderDelayTask = null;
    }

    @Override
    public void reset() {
        ThreadUtils.executeInMain(new Runnable(){

            @Override
            public void run() {
                ShareViewProvider.this.mStatus = 0;
                ShareViewProvider.this.mViewReadyCallbackList.clear();
                ShareViewProvider.this.mViewRenderTaskList.clear();
                ShareViewProvider.this.cancelRenderDelayTask();
            }
        });
    }

    @Override
    public void preRenderView() {
        this.waitViewReady(null);
    }

    private void onViewReady() {
        ThreadUtils.executeInMain(new Runnable(){

            @Override
            public void run() {
                ShareViewProvider.this.mStatus = 2;
                for (OnViewReadyCallback callback : ShareViewProvider.this.mViewReadyCallbackList) {
                    callback.onViewReady(ShareViewProvider.this.mShareView);
                }
                ShareViewProvider.this.mViewReadyCallbackList.clear();
            }
        });
    }

    @Override
    public void waitViewReady(final OnViewReadyCallback callback) {
        ThreadUtils.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (ShareViewProvider.this.mStatus == 2) {
                    if (callback != null) {
                        callback.onViewReady(ShareViewProvider.this.mShareView);
                    }
                } else if (ShareViewProvider.this.mStatus == 1) {
                    if (callback != null) {
                        ShareViewProvider.this.mViewReadyCallbackList.add(callback);
                    }
                } else {
                    if (callback != null) {
                        ShareViewProvider.this.mViewReadyCallbackList.add(callback);
                    }
                    ShareViewProvider.this.startRenderView();
                }
            }
        });
    }
}

