/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.share.base.dataprovider;

import androidx.annotation.MainThread;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.share.base.IShareDataProvider;
import com.yy.hiyo.share.base.OnDataReadyCallback;
import com.yy.hiyo.share.base.ShareBundle;
import com.yy.hiyo.share.base.dataprovider.DataCallback;
import com.yy.hiyo.share.base.dataprovider.DataProgressListener;
import com.yy.hiyo.share.base.dataprovider.DataTask;
import com.yy.hiyo.share.base.dataprovider.MutableShareBundle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class ShareDataProvider
implements IShareDataProvider {
    private static final String TAG = "ShareDataProvider";
    private long mVersion = 0L;
    private MutableShareBundle mShareBundle = new MutableShareBundle();
    private Queue<DataTask> mBuildTaskQueue = new LinkedList<DataTask>();
    private int mStatus = 0;
    private List<OnDataReadyCallback> mDataReadyCallbacks = new ArrayList<OnDataReadyCallback>();
    private DataProgressListener mBuildProgressListener;

    public ShareDataProvider() {
        this.reset();
    }

    @Override
    public void reset() {
        ShareDataProvider.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (ShareDataProvider.this.mVersion > 0L && ShareDataProvider.this.mStatus == 0) {
                    return;
                }
                ShareDataProvider.this.mVersion++;
                ShareDataProvider.this.mShareBundle.reset();
                ShareDataProvider.this.mDataReadyCallbacks.clear();
                ShareDataProvider.this.mBuildTaskQueue.clear();
                BuildTaskType[] buildTasks = ShareDataProvider.this.getOrderedBuildTasks();
                if (buildTasks != null) {
                    for (BuildTaskType taskType : buildTasks) {
                        DataTask task;
                        if (taskType == null || (task = ShareDataProvider.this.createBuildTask(ShareDataProvider.this.mVersion, taskType)) == null) continue;
                        ShareDataProvider.this.mBuildTaskQueue.offer(task);
                    }
                }
                ShareDataProvider.this.mStatus = 0;
            }
        });
    }

    @Override
    public void setDataBuildProgressListener(DataProgressListener dataBuildProgressListener) {
        this.mBuildProgressListener = dataBuildProgressListener;
    }

    public DataProgressListener getDataBuildProgressListener() {
        return this.mBuildProgressListener;
    }

    @Override
    public void preload() {
        this.waitDataReady(null);
    }

    @Override
    public void waitDataReady(final OnDataReadyCallback callback) {
        ShareDataProvider.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (ShareDataProvider.this.mStatus == 2) {
                    if (callback != null) {
                        callback.onDataReady(ShareDataProvider.this.mShareBundle);
                    }
                } else if (ShareDataProvider.this.mStatus == 1) {
                    if (callback != null) {
                        ShareDataProvider.this.mDataReadyCallbacks.add(callback);
                    }
                } else {
                    if (callback != null) {
                        ShareDataProvider.this.mDataReadyCallbacks.add(callback);
                    }
                    ShareDataProvider.this.startBuildData();
                }
            }
        });
    }

    private void startBuildData() {
        this.mStatus = 1;
        this.onDataBuildStart();
        this.nextBuildTask();
    }

    private void nextBuildTask() {
        DataTask task = this.mBuildTaskQueue.poll();
        if (task == null) {
            this.onDataReady();
        } else {
            task.run();
        }
    }

    public ShareBundle getShareBundle() {
        return this.mShareBundle;
    }

    protected void onDataBuildStart() {
        if (this.mBuildProgressListener != null) {
            this.mBuildProgressListener.onStart();
        }
    }

    protected void onDataBuildEnd() {
        if (this.mBuildProgressListener != null) {
            this.mBuildProgressListener.onEnd();
        }
    }

    @MainThread
    protected void buildTitle(DataCallback<String> callback) {
        callback.onData(null);
    }

    @MainThread
    protected void buildText(DataCallback<String> callback) {
        callback.onData(null);
    }

    @MainThread
    protected void buildImage(DataCallback<String> callback) {
        callback.onData(null);
    }

    @MainThread
    protected void buildUrl(DataCallback<String> callback) {
        callback.onData(null);
    }

    private void onTitleReady(final long version, final String title) {
        ShareDataProvider.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onTitleReady, title:%s", (Object[])new Object[]{title});
                ShareDataProvider.this.mShareBundle.setTitle(title);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onTextReady(final long version, final String text) {
        ShareDataProvider.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onTextReady, text:%s", (Object[])new Object[]{text});
                ShareDataProvider.this.mShareBundle.setText(text);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onImageReady(final long version, final String path) {
        ShareDataProvider.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onImageReady, image path:%s", (Object[])new Object[]{path});
                ShareDataProvider.this.mShareBundle.setImagePath(path);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onUrlReady(final long version, final String url) {
        ShareDataProvider.executeInMain(new Runnable(){

            @Override
            public void run() {
                if (version != ShareDataProvider.this.mVersion) {
                    return;
                }
                MLog.info((Object)"FTSHAREBase", (String)"onUrlReady, url:%s", (Object[])new Object[]{url});
                ShareDataProvider.this.mShareBundle.setUrl(url);
                ShareDataProvider.this.nextBuildTask();
            }
        });
    }

    private void onDataReady() {
        this.mStatus = 2;
        this.onDataBuildEnd();
        for (OnDataReadyCallback callback : this.mDataReadyCallbacks) {
            callback.onDataReady(this.mShareBundle);
        }
        this.mDataReadyCallbacks.clear();
    }

    protected BuildTaskType[] getOrderedBuildTasks() {
        return new BuildTaskType[]{BuildTaskType.TASK_TITLE, BuildTaskType.TASK_URL, BuildTaskType.TASK_TEXT, BuildTaskType.TASK_IMAGE};
    }

    private DataTask createBuildTask(long version, BuildTaskType taskType) {
        if (taskType == null) {
            return null;
        }
        DataTask<String> task = null;
        switch (taskType) {
            case TASK_TITLE: {
                task = new DataTask<String>(version){

                    @Override
                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildTitle start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildTitle(this);
                    }

                    @Override
                    public void onData(String data) {
                        ShareDataProvider.this.onTitleReady(this.getVersion(), data);
                    }
                };
                break;
            }
            case TASK_TEXT: {
                task = new DataTask<String>(version){

                    @Override
                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildText start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildText(this);
                    }

                    @Override
                    public void onData(String data) {
                        ShareDataProvider.this.onTextReady(this.getVersion(), data);
                    }
                };
                break;
            }
            case TASK_IMAGE: {
                task = new DataTask<String>(version){

                    @Override
                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildImage start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildImage(this);
                    }

                    @Override
                    public void onData(String data) {
                        ShareDataProvider.this.onImageReady(this.getVersion(), data);
                    }
                };
                break;
            }
            case TASK_URL: {
                task = new DataTask<String>(version){

                    @Override
                    public void run() {
                        MLog.info((Object)"FTSHAREBase", (String)"buildUrl start", (Object[])new Object[0]);
                        ShareDataProvider.this.buildUrl(this);
                    }

                    @Override
                    public void onData(String data) {
                        ShareDataProvider.this.onUrlReady(this.getVersion(), data);
                    }
                };
                break;
            }
        }
        return task;
    }

    public static void executeInMain(@NotNull Runnable runnable) {
        if (YYTaskExecutor.isMainThread()) {
            runnable.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)runnable);
        }
    }

    public static enum BuildTaskType {
        TASK_TITLE,
        TASK_TEXT,
        TASK_IMAGE,
        TASK_URL;

    }
}

