/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.turntable;

import android.content.Context;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenPresenter;
import com.yy.hiyo.channel.component.bigface.FaceNotifyDispatchService;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.tools.revenue.R;
import com.yy.hiyo.tools.revenue.turntable.TurnTableDialogManager;
import com.yy.hiyo.tools.revenue.turntable.TurnTableItem;
import com.yy.hiyo.tools.revenue.turntable.ui.TurnTableDialog;
import java.util.ArrayList;
import java.util.List;
import net.ihago.room.api.bigemoji.EmojiPush;
import net.ihago.room.api.bigemoji.GetRouletteConfigRequest;
import net.ihago.room.api.bigemoji.GetRouletteConfigResponse;
import net.ihago.room.api.bigemoji.RouletteItem;
import net.ihago.room.api.bigemoji.RouletteNotify;
import net.ihago.room.api.bigemoji.SendRouletteRequest;
import net.ihago.room.api.bigemoji.SendRouletteResponse;

public class TurnTablePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    private long mTemplate;
    private List<TurnTableItem> mTurnTableItemList = new ArrayList<TurnTableItem>();
    private TurnTableDialogManager mDialogManager;
    private FaceNotifyDispatchService mFaceNotifyDispatchService;
    private IPageLifeCycle mPageLifeCycle = new IPageLifeCycle(){

        public void onDetach() {
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onDetach hide", (Object[])new Object[0]);
            if (TurnTablePresenter.this.mDialogManager != null) {
                TurnTablePresenter.this.mDialogManager.hideTurnTable();
            }
        }

        public void onHidden() {
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onHidden hide", (Object[])new Object[0]);
            if (TurnTablePresenter.this.mDialogManager != null) {
                TurnTablePresenter.this.mDialogManager.hideTurnTable();
            }
        }

        public void onPageDestroy() {
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onDestroy hide", (Object[])new Object[0]);
            if (TurnTablePresenter.this.mDialogManager != null) {
                TurnTablePresenter.this.mDialogManager.hideTurnTable();
            }
        }
    };
    private INotifyDispatchService.INotifyHandler<EmojiPush> mNotifyHandler = new INotifyDispatchService.INotifyHandler<EmojiPush>(){

        public void onHandleNotify(EmojiPush notify2) {
            if (notify2 == null) {
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onHandleNotify notify null", (Object[])new Object[0]);
                return;
            }
            if (notify2.header.__isDefaultInstance()) {
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onHandleNotify header null", (Object[])new Object[0]);
                return;
            }
            if (!notify2.roulette_notify.__isDefaultInstance()) {
                final RouletteNotify rouletteNotify = notify2.roulette_notify;
                if (rouletteNotify == null) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onHandleNotify rouletteNotify null", (Object[])new Object[0]);
                    return;
                }
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onHandleNotify text:%s, index:%s, roomId:%s, template:%s", (Object[])new Object[]{rouletteNotify.text, rouletteNotify.index, notify2.header.roomid, rouletteNotify.template});
                boolean isPageUnVisible = !TurnTablePresenter.this.getPage().isPageVisible();
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onHandleNotify roomMiniPresenter null", (Object[])new Object[0]);
                if (!TurnTablePresenter.this.isPlayManager(AccountUtil.getUid())) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"receive turntable notify, isMini:%s", (Object[])new Object[]{isPageUnVisible});
                    if (isPageUnVisible) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (rouletteNotify == null) {
                                    return;
                                }
                                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"receive turntable notify, showMsg:%s, template:%s, index:%s", (Object[])new Object[]{rouletteNotify.text, rouletteNotify.template, rouletteNotify.index});
                                IPublicScreenModulePresenter publicScreenPresenter = (IPublicScreenModulePresenter)TurnTablePresenter.this.getPresenter(IPublicScreenModulePresenter.class);
                                if (publicScreenPresenter != null) {
                                    String nick = ResourceUtils.getString((int)R.string.short_tips_turntable_name);
                                    SpannableString spannableString = new SpannableString((CharSequence)(nick + " " + rouletteNotify.text));
                                    ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.color_80ffffff));
                                    spannableString.setSpan((Object)foregroundColorSpan, 0, nick.length(), 17);
                                    BaseImMsg msg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateAvatarContentMsg((CharSequence)spannableString);
                                    publicScreenPresenter.getPublicScreenPresenter().appendLocalMsg(msg);
                                }
                            }
                        }, (long)9000L);
                    } else if (TurnTablePresenter.this.mDialogManager != null) {
                        List<TurnTableItem> turnTableItemList = TurnTablePresenter.this.getTurnTableItemList();
                        if (turnTableItemList == null || turnTableItemList.size() == 0) {
                            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"guest turntable show null", (Object[])new Object[0]);
                            return;
                        }
                        TurnTableDialog turnTableDialog = new TurnTableDialog((Context)((IChannelPageContext)TurnTablePresenter.this.getMvpContext()).getContext(), turnTableItemList, rouletteNotify.index, false);
                        turnTableDialog.setResultTips(rouletteNotify.text);
                        TurnTablePresenter.this.mDialogManager.showGuestTurnTable(rouletteNotify.index, turnTableDialog, new TurnTableDialogManager.ITurntableOperationCallback(){

                            @Override
                            public void onGoClick() {
                            }

                            @Override
                            public void onResultShow(String tips) {
                                if (!TextUtils.isEmpty((CharSequence)tips)) {
                                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"guest turntable onResultShow:%s", (Object[])new Object[]{tips});
                                    IPublicScreenPresenter publicScreenPresenter = ((IPublicScreenModulePresenter)TurnTablePresenter.this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
                                    if (publicScreenPresenter == null) {
                                        return;
                                    }
                                    String nick = ResourceUtils.getString((int)R.string.short_tips_turntable_name);
                                    SpannableString spannableString = new SpannableString((CharSequence)(nick + " " + rouletteNotify.text));
                                    ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.color_80ffffff));
                                    spannableString.setSpan((Object)foregroundColorSpan, 0, nick.length(), 17);
                                    BaseImMsg msg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateAvatarContentMsg((CharSequence)spannableString);
                                    publicScreenPresenter.appendLocalMsg(msg);
                                }
                            }
                        }, (IChannel)TurnTablePresenter.this.getChannel());
                        RoomTrack.INSTANCE.reportRouShow(TurnTablePresenter.this.getChannel().getChannelId());
                    }
                }
            }
        }
    };

    public void getConfig(String roomId) {
        FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"getConfig roomId:%s", (Object[])new Object[]{roomId});
        GetRouletteConfigRequest request = new GetRouletteConfigRequest.Builder().template(Long.valueOf(0L)).build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)request, (IProtoCallback)new IProtoCallback<GetRouletteConfigResponse>(){

            public void onResponse(@Nullable GetRouletteConfigResponse message) {
                if (message == null) {
                    FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"getConfig null", (Object[])new Object[0]);
                    return;
                }
                if (!message.err.__isDefaultInstance()) {
                    FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"getConfig fail:%s", (Object[])new Object[]{message.err.code});
                    return;
                }
                if (!message.config.__isDefaultInstance()) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"getConfig success:%s", (Object[])new Object[]{message.config});
                    TurnTablePresenter.this.mTemplate = message.config.template;
                    List rouletteItemList = message.config.items;
                    if (rouletteItemList != null) {
                        TurnTablePresenter.this.mTurnTableItemList.clear();
                        for (RouletteItem item : rouletteItemList) {
                            TurnTableItem turnTableItem = new TurnTableItem();
                            turnTableItem.setCount(item.num);
                            turnTableItem.setType(item.type);
                            turnTableItem.setUrl(item.url);
                            TurnTablePresenter.this.mTurnTableItemList.add(turnTableItem);
                        }
                    }
                } else {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"getConfig null", (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"getConfig timeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"getConfig error, code:%s, reason:%s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    public List<TurnTableItem> getTurnTableItemList() {
        ArrayList<TurnTableItem> turnTableItemList = new ArrayList<TurnTableItem>();
        turnTableItemList.addAll(this.mTurnTableItemList);
        return turnTableItemList;
    }

    public void sendRequest(String roomId, final ISendRequestCallback callback) {
        FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"sendRequest template:%s, roomId:%s", (Object[])new Object[]{this.mTemplate, roomId});
        SendRouletteRequest request = new SendRouletteRequest.Builder().template(Long.valueOf(this.mTemplate)).build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)request, (IProtoCallback)new IProtoCallback<SendRouletteResponse>(){

            public void onResponse(@Nullable SendRouletteResponse message) {
                if (message == null) {
                    FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"sendRequest null", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onFailed(-1, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!message.err.__isDefaultInstance()) {
                    FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"sendRequest fail:%s", (Object[])new Object[]{message.err.code});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onFailed(-1, "sendRequest fail");
                            }
                        }
                    });
                    return;
                }
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"sendRequest success\uff0cindex:%s, text:%s", (Object[])new Object[]{message.index, message.text});
                final int index = message.index;
                final String text = message.text;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSucceed(index, text);
                        }
                    }
                });
                if (!message.config.__isDefaultInstance()) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"sendRequest updateConfig\uff0cconfig:%s", (Object[])new Object[]{message.config});
                    TurnTablePresenter.this.mTemplate = message.config.template;
                    List rouletteItemList = message.config.items;
                    if (rouletteItemList != null && rouletteItemList.size() > 0) {
                        TurnTablePresenter.this.mTurnTableItemList.clear();
                        for (RouletteItem item : rouletteItemList) {
                            TurnTableItem turnTableItem = new TurnTableItem();
                            turnTableItem.setCount(item.num);
                            turnTableItem.setType(item.type);
                            turnTableItem.setUrl(item.url);
                            TurnTablePresenter.this.mTurnTableItemList.add(turnTableItem);
                        }
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"sendRequest timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailed(-1, "");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                FeatureLog.e((String)"FTVoiceRoomTurnTable", (String)"sendRequest error, code:%s, reason:%s", (Object[])new Object[]{code, reason});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFailed(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void onInit(IChannelPageContext mvpContext2) {
        super.onInit(mvpContext2);
        FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"NotifyDispatcher addHandler", (Object[])new Object[0]);
        if (this.getChannel() != null) {
            this.mFaceNotifyDispatchService = new FaceNotifyDispatchService();
            this.mFaceNotifyDispatchService.setRoomId(this.getChannel().getChannelId());
            this.mFaceNotifyDispatchService.addHandler(this.mNotifyHandler);
            ProtoManager.getInstance().registerNotify((IProtoNotify)this.mFaceNotifyDispatchService);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mFaceNotifyDispatchService != null) {
            ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mFaceNotifyDispatchService);
        }
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onPageAttach", (Object[])new Object[0]);
        if (isReAttach) {
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"onPageAttach isReAttach true", (Object[])new Object[0]);
            return;
        }
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(this.mPageLifeCycle);
        this.mDialogManager = TurnTableDialogManager.newInstance((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        if (!TextUtils.isEmpty((CharSequence)this.getChannel().getChannelId())) {
            this.getConfig(this.getChannel().getChannelId());
        }
    }

    public void start() {
        if (this.mDialogManager == null) {
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"start dialogManager null", (Object[])new Object[0]);
            return;
        }
        if (this.mDialogManager.canGo()) {
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"can go", (Object[])new Object[0]);
            List<TurnTableItem> turnTableItemList = this.getTurnTableItemList();
            if (turnTableItemList == null || turnTableItemList.size() == 0) {
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"owner turntable show null", (Object[])new Object[0]);
                ToastUtils.showToast((Context)((IChannelPageContext)this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                return;
            }
            final TurnTableDialog turnTableDialog = new TurnTableDialog((Context)((IChannelPageContext)this.getMvpContext()).getContext(), turnTableItemList);
            this.mDialogManager.showOwnerTurnTable((IChannel)this.getChannel(), turnTableDialog, new TurnTableDialogManager.ITurntableOperationCallback(){

                @Override
                public void onGoClick() {
                    TurnTablePresenter.this.sendRequest(TurnTablePresenter.this.getChannel().getChannelId(), new ISendRequestCallback(){

                        @Override
                        public void onSucceed(int index, String text) {
                            if (turnTableDialog == null) {
                                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"showOwnerTurnTable goClick onSucceed turnTableDialog null", (Object[])new Object[0]);
                                return;
                            }
                            turnTableDialog.hideLoading();
                            turnTableDialog.start(index, text);
                        }

                        @Override
                        public void onFailed(int code, String reason) {
                            ToastUtils.showToast((Context)((IChannelPageContext)TurnTablePresenter.this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                            if (turnTableDialog == null) {
                                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"showOwnerTurnTable goClick sendRequest onFailed turnTableDialog null", (Object[])new Object[0]);
                                return;
                            }
                            turnTableDialog.hideLoading();
                        }
                    });
                    RoomTrack.INSTANCE.reportRouGoButClick(TurnTablePresenter.this.getChannel().getChannelId());
                }

                @Override
                public void onResultShow(String tips) {
                    if (!TextUtils.isEmpty((CharSequence)tips) || TurnTablePresenter.this.isDestroyed()) {
                        FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"owner turntable onResultShow:%s", (Object[])new Object[]{tips});
                        IPublicScreenModulePresenter publicScreenPresenter = (IPublicScreenModulePresenter)TurnTablePresenter.this.getPresenter(IPublicScreenModulePresenter.class);
                        if (publicScreenPresenter != null && ServiceManagerProxy.getService(IPublicScreenService.class) != null) {
                            String nick = ResourceUtils.getString((int)R.string.short_tips_turntable_name);
                            SpannableString spannableString = new SpannableString((CharSequence)(nick + " " + tips));
                            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.color_80ffffff));
                            spannableString.setSpan((Object)foregroundColorSpan, 0, nick.length(), 17);
                            BaseImMsg msg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateAvatarContentMsg((CharSequence)spannableString);
                            publicScreenPresenter.getPublicScreenPresenter().appendLocalMsg(msg);
                        }
                    }
                }
            });
            RoomTrack.INSTANCE.reportRouShow(this.getChannel().getChannelId());
        } else {
            ToastUtils.showToast((Context)((IChannelPageContext)this.getMvpContext()).getContext(), (int)R.string.tips_turntable_resume_tips);
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"can't go", (Object[])new Object[0]);
        }
    }

    private boolean isPlayManager(long uid) {
        return (this.isOwnerOrMaster(uid) || this.getChannel().getRoleService().isMeAnchor()) && this.getChannel().getSeatService().isInFirstSeat(uid);
    }

    private boolean isOwnerOrMaster(long uid) {
        return this.getChannel().getRoleService().getRoleCache(uid) == 15 || this.getChannel().getRoleService().getRoleCache(uid) == 10;
    }

    public static interface ISendRequestCallback {
        public void onSucceed(int var1, String var2);

        public void onFailed(int var1, String var2);
    }
}

