/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.redpacket;

import android.view.ViewGroup;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.friend.behavior.FriendInviteBehavior;
import com.yy.hiyo.tools.revenue.redpacket.RedPacketInviteBehavior;
import com.yy.hiyo.wallet.base.IRedPacketService;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketBehavior;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketHandler;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.PacketChatMsg;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.PacketShareInfo;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketEntranceReqParam;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;

public class RoomRedPacketPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IRedPacketBehavior {
    private IRedPacketHandler mRedPacketHandler;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public void onInit(IChannelPageContext mvpContext2) {
        super.onInit(mvpContext2);
        ChannelPluginData curPluginData = this.getChannel().getPluginService().getCurPluginData();
        this.mBinder.singleBindSourceTo((KvoSource)curPluginData);
        RedPacketParam param = new RedPacketParam(this.getChannel().getChannelId(), (IRedPacketBehavior)this);
        this.mRedPacketHandler = ((IRedPacketService)ServiceManagerProxy.getServiceManager().getService(IRedPacketService.class)).createHandler(param);
        this.reqEntrance(curPluginData.getId());
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        this.mRedPacketHandler.start((ViewGroup)this.getWindow().getExtLayer());
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        if (this.mRedPacketHandler != null) {
            this.mRedPacketHandler.pause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mBinder.clearAllKvoConnections();
        if (this.mRedPacketHandler != null) {
            this.mRedPacketHandler.destroy();
        }
    }

    public void showRedPacket() {
        this.mRedPacketHandler.showRedPacket();
    }

    @KvoMethodAnnotation(name="id", sourceClass=ChannelPluginData.class)
    public void onGameIdChanged(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        this.reqEntrance((String)event.newValue());
    }

    private void reqEntrance(String gameId) {
        if (this.mRedPacketHandler != null) {
            String tagId = null;
            if (this.getChannelDetailInfo().baseInfo.tag.getFirstTag() != null) {
                tagId = this.getChannelDetailInfo().baseInfo.tag.getFirstTag().getTagId();
            }
            RedPacketEntranceReqParam req = new RedPacketEntranceReqParam(tagId, gameId);
            this.mRedPacketHandler.reqRedPacketEntrance(req, null);
        }
    }

    public void addPacketChatMsg(PacketChatMsg msg) {
        if (msg == null || this.isDestroyed()) {
            return;
        }
        long uid = msg.getUid();
        int roleCache = this.getChannel().getRoleService().getRoleCache(uid);
        IPublicScreenService service2 = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
        if (service2 != null) {
            if (msg.getType() == 3) {
                ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsg(service2.getMsgItemFactory().generateGrabPacketMsg(this.getChannel().getChannelId(), msg, uid, roleCache));
            } else {
                ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsg(service2.getMsgItemFactory().generatePacketMsg(this.getChannel().getChannelId(), msg, uid, roleCache));
            }
        }
    }

    public void sharePacket(PacketShareInfo info) {
        ((InvitePresenter)this.getPresenter(InvitePresenter.class)).showFriendInvitePanel((FriendInviteBehavior)new RedPacketInviteBehavior(this.getMvpContext(), info), null, 0);
    }

    public PanelLayer getPanelLayer() {
        return this.getPage().getWindow().getPanelLayer();
    }

    public String roomName() {
        return this.getChannelDetailInfo().baseInfo.name;
    }

    public long roomOwnUid() {
        return this.getChannelDetailInfo().baseInfo.ownerUid;
    }

    public boolean isRoomLock() {
        return this.getChannelDetailInfo().baseInfo != null && this.getChannelDetailInfo().baseInfo.isLock();
    }

    public String gameId() {
        return this.getChannel().getPluginService().getCurPluginData().getId();
    }
}

