/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.gift;

import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftFlashLocation;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import java.util.ArrayList;
import java.util.List;

public class GiftDataHelper {
    private static final int DEFAULT_CODE = GiftChannel.VOICE_GAME_ROOM_USED_CHANNEL.getChannel();
    public static final int CHESS_GAME_ROOM_USED_CHANNEL = -1;

    public static int parseGiftChannel(int roomMode, boolean videoMode, boolean isVideoPk) {
        if (roomMode == -1) {
            return GiftChannel.CHESS_GAME_ROOM_USED_CHANNEL.getChannel();
        }
        if (roomMode == 11) {
            return GiftChannel.KTV_ROOM_USED_CHANNEL.getChannel();
        }
        if (roomMode == 13) {
            return GiftChannel.PICK_ME_ROOM_USED_CHANNEL.getChannel();
        }
        if (roomMode == 15) {
            return GiftChannel.MULTI_VIDEO_CHANNEL.getChannel();
        }
        if (roomMode == 16 || roomMode == 17) {
            return GiftChannel.AUDIO_PK_CHANNEL.getChannel();
        }
        if (roomMode == 14) {
            return videoMode ? (isVideoPk ? GiftChannel.VIDEO_PK_CHANNEL.getChannel() : GiftChannel.RADIO_VIDEO_USED_CHANNEL.getChannel()) : GiftChannel.RADIO_ROOM_USED_CHANNEL.getChannel();
        }
        if (ChannelDefine.isGameModeIncludeLocal((int)roomMode)) {
            return GiftChannel.VOICE_GAME_ROOM_USED_CHANNEL.getChannel();
        }
        if (roomMode == 10) {
            return GiftChannel.VOICE_ROOM_USED_CHANNEL.getChannel();
        }
        if (roomMode == 1) {
            return DEFAULT_CODE;
        }
        return DEFAULT_CODE;
    }

    public static GiftFlashLocation paraseFlashParam(int[] location) {
        GiftFlashLocation giftFlashLocation = new GiftFlashLocation();
        if (location == null || location.length != 2) {
            return giftFlashLocation;
        }
        giftFlashLocation.setMarginLeft(location[0]);
        giftFlashLocation.setMarginTop(location[1]);
        giftFlashLocation.notifyLocationChanged();
        return giftFlashLocation;
    }

    public static synchronized List<GiftUserInfo> genSeatList(List<UserInfoKS> userInfoKSList, long ownerId, ISeatService seatService) {
        ArrayList<GiftUserInfo> giftUserList = new ArrayList<GiftUserInfo>();
        if (FP.empty(userInfoKSList)) {
            return giftUserList;
        }
        for (UserInfoKS userInfoKS : userInfoKSList) {
            if (userInfoKS.uid == 0L) continue;
            GiftUserInfo giftUserInfo = new GiftUserInfo();
            giftUserInfo.setUserInfo(userInfoKS);
            giftUserInfo.setIndex(userInfoKSList.indexOf(userInfoKS));
            if (seatService.isInSeatAboutGift(userInfoKS.uid)) {
                if (ownerId == userInfoKS.uid) {
                    giftUserInfo.setUserType(1);
                }
            } else {
                giftUserInfo.setUserType(2);
            }
            giftUserList.add(giftUserInfo);
        }
        return giftUserList;
    }
}

