/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator.ui;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.hiyo.tools.revenue.R;

public class ShimmerLayout
extends YYFrameLayout {
    private static final int DEFAULT_ANIMATION_DURATION = 1500;
    private static final byte DEFAULT_ANGLE = 20;
    private static final byte MIN_ANGLE_VALUE = -45;
    private static final byte MAX_ANGLE_VALUE = 45;
    private static final byte MIN_MASK_WIDTH_VALUE = 0;
    private static final byte MAX_MASK_WIDTH_VALUE = 1;
    private static final byte MIN_GRADIENT_CENTER_COLOR_WIDTH_VALUE = 0;
    private static final byte MAX_GRADIENT_CENTER_COLOR_WIDTH_VALUE = 1;
    private int maskOffsetX;
    private Rect maskRect;
    private Paint gradientTexturePaint;
    private ValueAnimator maskAnimator;
    private Bitmap localMaskBitmap;
    private Bitmap maskBitmap;
    private Canvas canvasForShimmerMask;
    private boolean isAnimationReversed;
    private boolean isAnimationStarted;
    private boolean autoStart;
    private int shimmerAnimationDuration;
    private int shimmerColor;
    private int shimmerAngle;
    private float maskWidth;
    private float gradientCenterColorWidth;
    private ViewTreeObserver.OnPreDrawListener startAnimationPreDrawListener;
    private Animator.AnimatorListener mAnimatorListener;

    public ShimmerLayout(Context context) {
        this(context, null);
    }

    public ShimmerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShimmerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ShimmerLayout, 0, 0);
        try {
            this.shimmerAngle = a.getInteger(R.styleable.ShimmerLayout_shimmer_angle, 20);
            this.shimmerAnimationDuration = a.getInteger(R.styleable.ShimmerLayout_shimmer_animation_duration, 1500);
            this.shimmerColor = a.getColor(R.styleable.ShimmerLayout_shimmer_color, this.getColor(R.color.shimmer_color));
            this.autoStart = a.getBoolean(R.styleable.ShimmerLayout_shimmer_auto_start, false);
            this.maskWidth = a.getFloat(R.styleable.ShimmerLayout_shimmer_mask_width, 0.5f);
            this.gradientCenterColorWidth = a.getFloat(R.styleable.ShimmerLayout_shimmer_gradient_center_color_width, 0.1f);
            this.isAnimationReversed = a.getBoolean(R.styleable.ShimmerLayout_shimmer_reverse_animation, false);
        }
        finally {
            a.recycle();
        }
        this.setMaskWidth(this.maskWidth);
        this.setGradientCenterColorWidth(this.gradientCenterColorWidth);
        this.setShimmerAngle(this.shimmerAngle);
        this.enableForcedSoftwareLayerIfNeeded();
        if (this.autoStart && this.getVisibility() == 0) {
            this.startShimmerAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        this.resetShimmering();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (!this.isAnimationStarted || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
        } else {
            this.dispatchDrawShimmer(canvas);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            if (this.autoStart) {
                this.startShimmerAnimation();
            }
        } else {
            this.stopShimmerAnimation();
        }
    }

    public void startShimmerAnimation() {
        if (this.isAnimationStarted) {
            return;
        }
        if (this.getWidth() == 0) {
            this.startAnimationPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    ShimmerLayout.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    ShimmerLayout.this.startShimmerAnimation();
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(this.startAnimationPreDrawListener);
            return;
        }
        Animator animator = this.getShimmerAnimation();
        animator.start();
        this.isAnimationStarted = true;
    }

    public void stopShimmerAnimation() {
        if (this.startAnimationPreDrawListener != null) {
            this.getViewTreeObserver().removeOnPreDrawListener(this.startAnimationPreDrawListener);
        }
        this.resetShimmering();
    }

    public boolean isAnimationStarted() {
        return this.isAnimationStarted;
    }

    public void setShimmerColor(int shimmerColor) {
        this.shimmerColor = shimmerColor;
        this.resetIfStarted();
    }

    public void setShimmerAnimationDuration(int durationMillis) {
        this.shimmerAnimationDuration = durationMillis;
        this.resetIfStarted();
    }

    public void setAnimationReversed(boolean animationReversed) {
        this.isAnimationReversed = animationReversed;
        this.resetIfStarted();
    }

    public void setAnimationListener(Animator.AnimatorListener listener2) {
        this.mAnimatorListener = listener2;
    }

    public void setShimmerAngle(int angle) {
        if (angle < -45 || 45 < angle) {
            throw new IllegalArgumentException(String.format("shimmerAngle value must be between %d and %d", (byte)-45, (byte)45));
        }
        this.shimmerAngle = angle;
        this.resetIfStarted();
    }

    public void setMaskWidth(float maskWidth) {
        if (maskWidth <= 0.0f || 1.0f < maskWidth) {
            throw new IllegalArgumentException(String.format("maskWidth value must be higher than %d and less or equal to %d", (byte)0, (byte)1));
        }
        this.maskWidth = maskWidth;
        this.resetIfStarted();
    }

    public void setGradientCenterColorWidth(float gradientCenterColorWidth) {
        if (gradientCenterColorWidth <= 0.0f || 1.0f <= gradientCenterColorWidth) {
            throw new IllegalArgumentException(String.format("gradientCenterColorWidth value must be higher than %d and less than %d", (byte)0, (byte)1));
        }
        this.gradientCenterColorWidth = gradientCenterColorWidth;
        this.resetIfStarted();
    }

    private void resetIfStarted() {
        if (this.isAnimationStarted) {
            this.resetShimmering();
            this.startShimmerAnimation();
        }
    }

    private void dispatchDrawShimmer(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.localMaskBitmap = this.getMaskBitmap();
        if (this.localMaskBitmap == null) {
            return;
        }
        if (this.canvasForShimmerMask == null) {
            this.canvasForShimmerMask = new Canvas(this.localMaskBitmap);
        }
        this.canvasForShimmerMask.drawColor(0, PorterDuff.Mode.CLEAR);
        this.canvasForShimmerMask.save();
        this.canvasForShimmerMask.translate((float)(-this.maskOffsetX), 0.0f);
        super.dispatchDraw(this.canvasForShimmerMask);
        this.canvasForShimmerMask.restore();
        this.drawShimmer(canvas);
        this.localMaskBitmap = null;
    }

    private void drawShimmer(Canvas destinationCanvas) {
        this.createShimmerPaint();
        destinationCanvas.save();
        destinationCanvas.translate((float)this.maskOffsetX, 0.0f);
        destinationCanvas.drawRect((float)this.maskRect.left, 0.0f, (float)this.maskRect.width(), (float)this.maskRect.height(), this.gradientTexturePaint);
        destinationCanvas.restore();
    }

    private void resetShimmering() {
        if (this.maskAnimator != null) {
            this.maskAnimator.end();
            this.maskAnimator.removeAllUpdateListeners();
        }
        this.maskAnimator = null;
        this.gradientTexturePaint = null;
        this.isAnimationStarted = false;
        this.releaseBitMaps();
    }

    private void releaseBitMaps() {
        this.canvasForShimmerMask = null;
        if (this.maskBitmap != null) {
            this.maskBitmap.recycle();
            this.maskBitmap = null;
        }
    }

    private Bitmap getMaskBitmap() {
        if (this.maskBitmap == null) {
            this.maskBitmap = this.createBitmap(this.maskRect.width(), this.getHeight());
        }
        return this.maskBitmap;
    }

    private void createShimmerPaint() {
        if (this.gradientTexturePaint != null) {
            return;
        }
        int edgeColor = this.reduceColorAlphaValueToZero(this.shimmerColor);
        float shimmerLineWidth = (float)(this.getWidth() / 2) * this.maskWidth;
        float yPosition = 0 <= this.shimmerAngle ? (float)this.getHeight() : 0.0f;
        LinearGradient gradient = new LinearGradient(0.0f, yPosition, (float)Math.cos(Math.toRadians(this.shimmerAngle)) * shimmerLineWidth, yPosition + (float)Math.sin(Math.toRadians(this.shimmerAngle)) * shimmerLineWidth, new int[]{this.getColor(R.color.transparent), this.shimmerColor, this.shimmerColor, this.getColor(R.color.transparent)}, this.getGradientColorDistribution(), Shader.TileMode.CLAMP);
        BitmapShader maskBitmapShader = new BitmapShader(this.localMaskBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        ComposeShader composeShader = new ComposeShader((Shader)gradient, (Shader)maskBitmapShader, PorterDuff.Mode.DST_IN);
        this.gradientTexturePaint = new Paint();
        this.gradientTexturePaint.setAntiAlias(true);
        this.gradientTexturePaint.setDither(true);
        this.gradientTexturePaint.setFilterBitmap(true);
        this.gradientTexturePaint.setShader((Shader)composeShader);
    }

    private Animator getShimmerAnimation() {
        if (this.maskAnimator != null) {
            return this.maskAnimator;
        }
        if (this.maskRect == null) {
            this.maskRect = this.calculateBitmapMaskRect();
        }
        int animationToX = this.getWidth();
        final int animationFromX = this.getWidth() > this.maskRect.width() ? -animationToX : -this.maskRect.width();
        final int shimmerBitmapWidth = this.maskRect.width();
        int shimmerAnimationFullLength = animationToX - animationFromX;
        this.maskAnimator = this.isAnimationReversed ? ValueAnimator.ofInt((int[])new int[]{shimmerAnimationFullLength, 0}) : ValueAnimator.ofInt((int[])new int[]{0, shimmerAnimationFullLength});
        this.maskAnimator.setDuration((long)this.shimmerAnimationDuration);
        this.maskAnimator.setRepeatCount(-1);
        if (this.mAnimatorListener != null) {
            this.maskAnimator.addListener(this.mAnimatorListener);
        }
        this.maskAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ShimmerLayout.this.maskOffsetX = animationFromX + (Integer)animation.getAnimatedValue();
                if (ShimmerLayout.this.maskOffsetX + shimmerBitmapWidth >= 0) {
                    ShimmerLayout.this.invalidate();
                }
            }
        });
        return this.maskAnimator;
    }

    private Bitmap createBitmap(int width, int height) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            return null;
        }
    }

    private int getColor(int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getContext().getColor(id2);
        }
        return this.getResources().getColor(id2);
    }

    private int reduceColorAlphaValueToZero(int actualColor) {
        return Color.argb((int)0, (int)Color.red((int)actualColor), (int)Color.green((int)actualColor), (int)Color.blue((int)actualColor));
    }

    private Rect calculateBitmapMaskRect() {
        return new Rect(0, 0, this.calculateMaskWidth(), this.getHeight());
    }

    private int calculateMaskWidth() {
        double shimmerLineBottomWidth = (double)((float)(this.getWidth() / 2) * this.maskWidth) / Math.cos(Math.toRadians(Math.abs(this.shimmerAngle)));
        double shimmerLineRemainingTopWidth = (double)this.getHeight() * Math.tan(Math.toRadians(Math.abs(this.shimmerAngle)));
        return (int)(shimmerLineBottomWidth + shimmerLineRemainingTopWidth);
    }

    private float[] getGradientColorDistribution() {
        float[] colorDistribution = new float[4];
        colorDistribution[0] = 0.0f;
        colorDistribution[3] = 1.0f;
        colorDistribution[1] = 0.5f - this.gradientCenterColorWidth / 2.0f;
        colorDistribution[2] = 0.5f + this.gradientCenterColorWidth / 2.0f;
        return colorDistribution;
    }

    private void enableForcedSoftwareLayerIfNeeded() {
        if (Build.VERSION.SDK_INT <= 16) {
            this.setLayerType(1, null);
        }
    }
}

