/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.tools.revenue.R;
import java.util.ArrayList;
import java.util.List;

public class InstructionDialog
extends YYDialog {
    private View mView;
    private Context mContext;

    public InstructionDialog(@NonNull Context context) {
        super(context, R.style.normal_yydialog);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.dialog_calculator_instruction_channel, null);
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(ResolutionUtils.getScreenWidth((Context)this.mContext) * 5 / 6, -2);
        this.setContentView(this.mView, contentLp);
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResourceUtils.getString((int)R.string.tips_calculator_instruction_dialog_1));
        list.add(ResourceUtils.getString((int)R.string.tips_calculator_instruction_dialog_2));
        RecyclerView recyclerView = (RecyclerView)this.mView.findViewById(R.id.rv_instruction);
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.mContext, 1);
        itemDecoration.setDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_calculator_instruction_divider));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        recyclerView.setAdapter((RecyclerView.Adapter)new InstructionAdapter(this.mContext, list));
        this.mView.findViewById(R.id.btn_ok).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InstructionDialog.this.dismiss();
            }
        });
    }

    static class InstructionAdapter
    extends RecyclerView.Adapter<NormalViewHolder> {
        private List<String> mList;
        private Context mContext;

        public InstructionAdapter(Context context, List<String> list) {
            this.mList = list;
            this.mContext = context;
        }

        @NonNull
        public NormalViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new NormalViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_calculator_instruction_channel, parent, false));
        }

        public void onBindViewHolder(@NonNull NormalViewHolder holder, int position) {
            holder.tv.setText((CharSequence)this.mList.get(position));
        }

        public int getItemCount() {
            return this.mList.size();
        }

        class NormalViewHolder
        extends RecyclerView.ViewHolder {
            private YYTextView tv;

            public NormalViewHolder(View itemView) {
                super(itemView);
                this.tv = (YYTextView)itemView.findViewById(R.id.tv_instruction);
            }
        }
    }
}

