/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator.rank;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.tools.revenue.calculator.rank.CalculatorRankData;
import java.util.ArrayList;
import java.util.List;
import net.ihago.room.api.calculator.ContributorsRank;
import net.ihago.room.api.calculator.GetCharmContributorsRankReq;
import net.ihago.room.api.calculator.GetCharmContributorsRankRes;

public class CalculatorRankModel {
    public void getRank(String roomId, long uid, final GetRankCallback callback) {
        FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankModel getRank: roomid:%s, uid:%s", (Object[])new Object[]{roomId, uid});
        GetCharmContributorsRankReq req = new GetCharmContributorsRankReq.Builder().uid(Long.valueOf(uid)).limit(Integer.valueOf(100)).build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetCharmContributorsRankRes>(){

            public void onResponse(@NonNull GetCharmContributorsRankRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankModel getRank \u7ed3\u679c:%s", (Object[])new Object[]{code});
                if (ProtoManager.isSuccessCode((long)code)) {
                    ArrayList<CalculatorRankData> rankDataList = new ArrayList<CalculatorRankData>();
                    int index = 1;
                    for (ContributorsRank rank : message.ranks) {
                        CalculatorRankData calculatorRankData = new CalculatorRankData(rank.avatar, rank.charm_value, rank.nick, rank.uid);
                        calculatorRankData.setIndex(index++);
                        rankDataList.add(calculatorRankData);
                    }
                    callback.onSuccess(message.charm_value, rankDataList);
                } else {
                    callback.onFail();
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankModel getRank \u7ed3\u679c: timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail();
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankModel getRank \u7ed3\u679c:%s", (Object[])new Object[]{code});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail();
                    }
                });
                return false;
            }
        });
    }

    public static interface GetRankCallback {
        public void onSuccess(long var1, List<CalculatorRankData> var3);

        public void onFail();
    }
}

