/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.tools.revenue.calculator.bean.CalculatorStyleData;
import com.yy.hiyo.tools.revenue.calculator.bean.HatEffectConfigData;
import java.util.HashMap;
import java.util.Map;
import net.ihago.room.api.calculator.Egg;
import net.ihago.room.api.calculator.GetRoomCalculatorConfigReq;
import net.ihago.room.api.calculator.GetRoomCalculatorConfigRes;
import net.ihago.room.api.calculator.HatSpecialEffect;
import net.ihago.room.api.calculator.SpecialEffect;

public enum CalculatorStyleManager {
    INSTANCE;

    public static final int STYLE_COMMON = 1;
    public static final int STYLE_SPECIAL = 2;
    private String mVersion = "";
    private Map<Integer, CalculatorStyleData> mStyleDataMap = new HashMap<Integer, CalculatorStyleData>();
    private Map<Integer, String> mEggMap = new HashMap<Integer, String>();
    private Map<Integer, HatEffectConfigData> mHatMap = new HashMap<Integer, HatEffectConfigData>();

    public void getConfig() {
        GetRoomCalculatorConfigReq req = new GetRoomCalculatorConfigReq.Builder().version(this.mVersion).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetRoomCalculatorConfigRes>(){

            public void onResponse(@NonNull GetRoomCalculatorConfigRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (!ProtoManager.isSuccessCode((long)code)) {
                    return;
                }
                if (CalculatorStyleManager.this.mVersion.equals(message.config.version)) {
                    return;
                }
                CalculatorStyleManager.this.mVersion = message.config.version;
                FeatureLog.i((String)"FTCalculator", (String)"getConfig version:%s", (Object[])new Object[]{CalculatorStyleManager.this.mVersion});
                Map specialEffectMap = message.config.effects;
                Map eggMap = message.config.eggs;
                Map hatEffects = message.config.hatEffects;
                for (Map.Entry entry : specialEffectMap.entrySet()) {
                    SpecialEffect value = (SpecialEffect)entry.getValue();
                    CalculatorStyleData calculatorData = CalculatorStyleData.createFrom(value);
                    if (calculatorData == null) continue;
                    CalculatorStyleManager.this.mStyleDataMap.put(value.effect_id, calculatorData);
                }
                for (Map.Entry entry : eggMap.entrySet()) {
                    Egg value = (Egg)entry.getValue();
                    CalculatorStyleManager.this.mEggMap.put(value.egg_id, value.egg_url);
                }
                for (Map.Entry entry : hatEffects.entrySet()) {
                    HatSpecialEffect value = (HatSpecialEffect)entry.getValue();
                    CalculatorStyleManager.this.mHatMap.put(value.effect_id, new HatEffectConfigData(value.effect_id, value.effect_style, value.effect_url));
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public CalculatorStyleData getData(int id2) {
        if (this.mStyleDataMap.containsKey(id2)) {
            return this.mStyleDataMap.get(id2);
        }
        return new CalculatorStyleData();
    }

    public String getEggUrl(int id2) {
        if (this.mEggMap.containsKey(id2)) {
            return this.mEggMap.get(id2);
        }
        return "";
    }

    public HatEffectConfigData getHatSpecialEffectData(int id2) {
        if (this.mHatMap.containsKey(id2)) {
            return this.mHatMap.get(id2);
        }
        return null;
    }

    public String getHatUrl(int id2) {
        if (this.mHatMap.containsKey(id2) && this.mHatMap.get(id2) != null) {
            return this.mHatMap.get(id2).getEffectUrl();
        }
        return "";
    }

    public void addData(CalculatorStyleData calculatorStyleData) {
        if (calculatorStyleData != null) {
            this.mStyleDataMap.put(calculatorStyleData.getEffectId(), calculatorStyleData);
        }
    }
}

