/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.degrade.SimpleSceneOptLimiterCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.base.bean.CalculatorData;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IMsgItemFactory;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.cbase.tools.ICalculatorRequestCallback;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.tools.revenue.R;
import com.yy.hiyo.tools.revenue.calculator.CalculatorStyleManager;
import com.yy.hiyo.tools.revenue.calculator.PickMeHatPresenter;
import com.yy.hiyo.tools.revenue.calculator.RoomCalculatorNotifyDispatchService;
import com.yy.hiyo.tools.revenue.calculator.bean.CalculatorStyleData;
import com.yy.hiyo.tools.revenue.calculator.ui.InstructionDialog;
import com.yy.hiyo.tools.revenue.calculator.ui.LevelUpDialog;
import com.yy.hiyo.tools.revenue.gift.RoomGiftPresenter;
import java.util.ArrayList;
import java.util.List;
import net.ihago.room.api.calculator.CalculatorBcUri;
import net.ihago.room.api.calculator.CalculatorNotify;
import net.ihago.room.api.calculator.CharmValue;
import net.ihago.room.api.calculator.CloseRoomCalculatorReq;
import net.ihago.room.api.calculator.CloseRoomCalculatorRes;
import net.ihago.room.api.calculator.GetRoomCalculatorReq;
import net.ihago.room.api.calculator.GetRoomCalculatorRes;
import net.ihago.room.api.calculator.OpenRoomCalculatorReq;
import net.ihago.room.api.calculator.OpenRoomCalculatorRes;
import net.ihago.room.api.calculator.ResetRoomCalculatorReq;
import net.ihago.room.api.calculator.ResetRoomCalculatorRes;
import net.ihago.room.api.calculator.RetCode;
import net.ihago.room.api.calculator.SpecialEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalculatorPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    public static final int TYPE_CLOSE_EMPTY_SEAT = 0;
    public static final int TYPE_CLOSE_GAME = 1;
    private String mRoomId = "";
    private boolean mIsOpen;
    private RoomCalculatorNotifyDispatchService mRoomCalculatorNotifyDispatchService;
    private SVGAImageView mSVGAImageView;
    private ISceneOptLimiterCallback sceCallback = new SimpleSceneOptLimiterCallback<Boolean>(){

        @Nullable
        public List<Boolean> needDiscardWhenOnDiscard(@NotNull List<? extends Boolean> items, float discardRatio, int discardMinRemain, int maxRemain) {
            return null;
        }

        @NotNull
        public DiscardResult onDiscard(Boolean item, float discardRatio, int discardMinRemain, int maxRemain) {
            return DiscardResult.DISCARD_ADD_NEW;
        }

        public void onAppendItem(Boolean item) {
            SeatPresenter seatPresenter = (SeatPresenter)CalculatorPresenter.this.getPresenter(SeatPresenter.class);
            if (seatPresenter != null) {
                seatPresenter.updateSeatValues();
            }
        }

        public boolean isDisCardOldDataFrequency() {
            return true;
        }

        public boolean needSkip(Boolean item) {
            return false;
        }
    };
    private ISceneOptLimiter<Boolean> sceneOptLimiter = null;
    private INotifyDispatchService.INotifyHandler<CalculatorNotify> mNotifyHandler = new INotifyDispatchService.INotifyHandler<CalculatorNotify>(){

        public void onHandleNotify(CalculatorNotify notify2) {
            if (notify2 == null) {
                FeatureLog.i((String)"FTCalculator", (String)"onHandleNotify notify null", (Object[])new Object[0]);
                return;
            }
            if (notify2.header == null) {
                FeatureLog.i((String)"FTCalculator", (String)"onHandleNotify header null", (Object[])new Object[0]);
                return;
            }
            if (CalculatorPresenter.this.isDestroyed()) {
                MLog.error((Object)"FTCalculator", (String)"presenter \u9500\u6bc1\u4e86, %s", (Object[])new Object[]{notify2.uri});
                return;
            }
            if (!StringUtils.equal((String)CalculatorPresenter.this.getChannel().getChannelId(), (String)notify2.header.roomid)) {
                FeatureLog.i((String)"FTCalculator", (String)"onHandleNotify roomId not right, currentRoomId:%s, service roomId:%s", (Object[])new Object[]{CalculatorPresenter.this.getChannel().getChannelId(), notify2.header.roomid});
                if (VersionUtil.isLocalDevBuild()) {
                    throw new RuntimeException("onHandleNotify roomId not right, notifyRoomId " + notify2.header.roomid + ",\n roomData" + CalculatorPresenter.this.getChannel().toString());
                }
                return;
            }
            if (notify2.uri == CalculatorBcUri.UriCharmValueRaiseNotify) {
                CalculatorPresenter.this.handleCharmValueCalculator(notify2);
            } else if (notify2.uri == CalculatorBcUri.UriCloseCalculatorNotify) {
                CalculatorPresenter.this.handleCloseCalculator(notify2);
            } else if (notify2.uri == CalculatorBcUri.UriForceCloseCalculatorNotify) {
                CalculatorPresenter.this.handleForceCloseCalculator(notify2);
            } else if (notify2.uri == CalculatorBcUri.UriOpenCalculatorNotify) {
                CalculatorPresenter.this.handleOpenCalculator(notify2);
            } else if (notify2.uri == CalculatorBcUri.UriResetCalculatorNotify) {
                CalculatorPresenter.this.handleResetCalculator(notify2);
            }
        }
    };

    private ISceneOptLimiter<Boolean> getSceneOptLimiter() {
        ISceneDegradedService service2 = (ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class);
        if (this.sceneOptLimiter == null && service2 != null) {
            this.sceneOptLimiter = service2.createLimiter("calculator", this.sceCallback);
        }
        return this.sceneOptLimiter;
    }

    public void open(final String roomId, final ICalculatorRequestCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"open roomId null", (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        CalculatorPresenter.this.mIsOpen = false;
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
            return;
        }
        OpenRoomCalculatorReq openRoomCalculatorReq = new OpenRoomCalculatorReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)openRoomCalculatorReq, (IProtoCallback)new IProtoCallback<OpenRoomCalculatorRes>(){

            public void onResponse(final @NonNull OpenRoomCalculatorRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (CalculatorPresenter.this.isDestroyed()) {
                    return;
                }
                if (message == null) {
                    FeatureLog.i((String)"FTCalculator", (String)"open roomId:%s onResponse message null\uff0c currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                CalculatorPresenter.this.mIsOpen = false;
                                callback.onFail(-1L, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                CalculatorPresenter.this.mIsOpen = false;
                                callback.onFail(message.result.errcode.longValue(), message.result.errmsg);
                            }
                        }
                    });
                    FeatureLog.i((String)"FTCalculator", (String)"open roomId:%s onResponse result error code:%s, error msg:%s, currentRoomId:%s", (Object[])new Object[]{roomId, message.result.errcode, message.result.errmsg, CalculatorPresenter.this.mRoomId});
                    return;
                }
                FeatureLog.i((String)"FTCalculator", (String)"open roomId:%s onResponse success, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                CalculatorPresenter.this.mIsOpen = true;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSuccess(roomId);
                        }
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTCalculator", (String)"open roomId:%s timeout, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            CalculatorPresenter.this.mIsOpen = false;
                            callback.onFail(-1L, "time out");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                FeatureLog.i((String)"FTCalculator", (String)"open roomId:%s error, code:%s, reason:%s, currentRoomId:%s", (Object[])new Object[]{roomId, code, reason, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            CalculatorPresenter.this.mIsOpen = false;
                            callback.onFail((long)code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public boolean isRoomOpen(String roomId) {
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"roomId:%s RoomOpen current roomId null", (Object[])new Object[]{roomId});
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"currentRoomId:%s isRoomOpen target roomId null", (Object[])new Object[]{this.mRoomId});
            return false;
        }
        if (!this.mRoomId.equals(roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"isRoomOpen target roomId:%s not equals current roomId:%s", (Object[])new Object[]{roomId, this.mRoomId});
            return false;
        }
        return this.mIsOpen;
    }

    public void getRoomStatus(Context context, final String roomId, final ICalculatorStatusRequestCallback callback) {
        if (context == null) {
            FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus context null", (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        CalculatorPresenter.this.mIsOpen = false;
                        callback.onFail(-1L, "context null");
                    }
                }
            });
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)context)) {
            FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus not network", (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        CalculatorPresenter.this.mIsOpen = false;
                        callback.onFail(-1L, "not network");
                    }
                }
            });
            return;
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus roomId null, currentRoomId:%s", (Object[])new Object[]{this.mRoomId});
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        CalculatorPresenter.this.mIsOpen = false;
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
            return;
        }
        GetRoomCalculatorReq getRoomCalculatorReq = new GetRoomCalculatorReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)getRoomCalculatorReq, (IProtoCallback)new IProtoCallback<GetRoomCalculatorRes>(){

            public void onResponse(final @NonNull GetRoomCalculatorRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (CalculatorPresenter.this.isDestroyed()) {
                    return;
                }
                if (message == null) {
                    FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus roomId:%s onResponse message null, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                CalculatorPresenter.this.mIsOpen = false;
                                callback.onFail(-1L, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    CalculatorPresenter.this.mIsOpen = false;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onFail(message.result.errcode, message.result.errmsg);
                            }
                        }
                    });
                    FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus roomId:%s onResponse result error code:%s, error msg:%s. currentRoomId:%s", (Object[])new Object[]{roomId, message.result.errcode, message.result.errmsg, CalculatorPresenter.this.mRoomId});
                    return;
                }
                CalculatorStyleData calculatorStyleData = CalculatorStyleData.createFrom(message.special_effect);
                if (calculatorStyleData != null) {
                    CalculatorStyleManager.INSTANCE.addData(calculatorStyleData);
                }
                FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus roomId:%s onResponse success, status:%s, currentRoomId:%s", (Object[])new Object[]{roomId, message.is_open, CalculatorPresenter.this.mRoomId});
                CalculatorPresenter.this.mIsOpen = message.is_open;
                CalculatorPresenter.this.getChannel().getCalculatorService().clearCharmValue();
                CalculatorPresenter.this.getChannel().getCalculatorService().setCalculatorOpen(message.is_open.booleanValue());
                CalculatorPresenter.this.getChannel().getCalculatorService().setHatOpen(message.is_show_hat.booleanValue());
                if (!message.is_open.booleanValue()) {
                    CalculatorPresenter.this.updateSeatValues();
                }
                SpecialEffect specialEffect = message.special_effect;
                CalculatorStyleManager.INSTANCE.addData(CalculatorStyleData.createFrom(specialEffect));
                final List charmValueList = message.charm_values;
                final ArrayList<CalculatorData> roomCharmValueList = new ArrayList<CalculatorData>();
                if (charmValueList != null) {
                    for (CharmValue value : charmValueList) {
                        if (value == null) continue;
                        boolean isUp = false;
                        if (value.old_level != value.new_level) {
                            isUp = true;
                        }
                        int effectId = 0;
                        if (charmValueList.indexOf(value) == 0) {
                            effectId = specialEffect.effect_id;
                        }
                        roomCharmValueList.add(new CalculatorData(value.uid.longValue(), value.charm_value.longValue(), value.raise_value.longValue(), value.seat.longValue(), effectId, isUp, value.upgrade_time.longValue()));
                    }
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSuccess(roomId, message, roomCharmValueList, charmValueList);
                        }
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus roomId:%s timeout, currentRoomId", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            CalculatorPresenter.this.mIsOpen = false;
                            callback.onFail(-1L, "time out");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                FeatureLog.i((String)"FTCalculator", (String)"getRoomStatus roomId:%s error, code:%s, reason:%s, currentRoomId:%s", (Object[])new Object[]{roomId, code, reason, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            CalculatorPresenter.this.mIsOpen = false;
                            callback.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void close(final String roomId, final ICalculatorRequestCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"close roomId null, currentRoomId:%s", (Object[])new Object[]{this.mRoomId});
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        CalculatorPresenter.this.mIsOpen = false;
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
            return;
        }
        CloseRoomCalculatorReq closeRoomCalculatorReq = new CloseRoomCalculatorReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)closeRoomCalculatorReq, (IProtoCallback)new IProtoCallback<CloseRoomCalculatorRes>(){

            public void onResponse(final @NonNull CloseRoomCalculatorRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (CalculatorPresenter.this.isDestroyed()) {
                    return;
                }
                if (message == null) {
                    FeatureLog.i((String)"FTCalculator", (String)"close roomId:%s onResponse message null, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                CalculatorPresenter.this.mIsOpen = false;
                                callback.onFail(-1L, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onFail(message.result.errcode.longValue(), message.result.errmsg);
                            }
                        }
                    });
                    FeatureLog.i((String)"FTCalculator", (String)"close roomId:%s onResponse result error code:%s, error msg:%s, currentRoomId:%s", (Object[])new Object[]{roomId, message.result.errcode, message.result.errmsg, CalculatorPresenter.this.mRoomId});
                    return;
                }
                FeatureLog.i((String)"FTCalculator", (String)"close roomId:%s onResponse success, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                CalculatorPresenter.this.mIsOpen = false;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSuccess(roomId);
                        }
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTCalculator", (String)"close roomId:%s timeout, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "time out");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                FeatureLog.i((String)"FTCalculator", (String)"close roomId:%s error, code:%s, reason:%s, currentRoomId:%s", (Object[])new Object[]{roomId, code, reason, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail((long)code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void reset(final String roomId, final ICalculatorRequestCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"reset roomId null, currentRoomId:%s", (Object[])new Object[]{this.mRoomId});
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        CalculatorPresenter.this.mIsOpen = false;
                        callback.onFail(-1L, "roomId null");
                    }
                }
            });
            return;
        }
        ResetRoomCalculatorReq resetRoomCalculatorReq = new ResetRoomCalculatorReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)resetRoomCalculatorReq, (IProtoCallback)new IProtoCallback<ResetRoomCalculatorRes>(){

            public void onResponse(final @NonNull ResetRoomCalculatorRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (CalculatorPresenter.this.isDestroyed()) {
                    return;
                }
                if (message == null) {
                    FeatureLog.i((String)"FTCalculator", (String)"reset roomId:%s onResponse message null, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                CalculatorPresenter.this.mIsOpen = false;
                                callback.onFail(-1L, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onFail(message.result.errcode.longValue(), message.result.errmsg);
                            }
                        }
                    });
                    FeatureLog.i((String)"FTCalculator", (String)"reset roomId:%s onResponse result error code:%s, error msg:%s, currentRoomId:%s", (Object[])new Object[]{roomId, message.result.errcode, message.result.errmsg, CalculatorPresenter.this.mRoomId});
                    return;
                }
                FeatureLog.i((String)"FTCalculator", (String)"reset roomId:%s onResponse success, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSuccess(roomId);
                        }
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTCalculator", (String)"reset roomId:%s timeout, currentRoomId:%s", (Object[])new Object[]{roomId, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(-1L, "time out");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                FeatureLog.i((String)"FTCalculator", (String)"reset roomId:%s error, code:%s, reason:%s, currentRoomId:%s", (Object[])new Object[]{roomId, code, reason, CalculatorPresenter.this.mRoomId});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail((long)code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public void handleClickCalculator() {
        FeatureLog.i((String)"FTCalculator", (String)"clickMoreCalculator", (Object[])new Object[0]);
        boolean canOpen = this.isRoomOpen(this.mRoomId);
        if (canOpen) {
            this.showCalculatorBottom();
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)this.getMvpContext()).getContext())) {
            ToastUtils.showToast((Context)((IChannelPageContext)this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
            FeatureLog.i((String)"FTCalculator", (String)"handleClickCalculator not network", (Object[])new Object[0]);
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog();
        if (((IChannelPageContext)this.getMvpContext()).getDialogLinkManager() != null) {
            ((IChannelPageContext)this.getMvpContext()).getDialogLinkManager().showDialog((BaseDialog)progressDialog);
        }
        this.open(this.mRoomId, new ICalculatorRequestCallback(){

            public void onSuccess(String roomId) {
                boolean isShowLevelUp;
                if (((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getDialogLinkManager() != null) {
                    ((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
                }
                if (!TextUtils.isEmpty((CharSequence)CalculatorPresenter.this.mRoomId) && !CalculatorPresenter.this.mRoomId.equals(roomId) || CalculatorPresenter.this.isDestroyed()) {
                    FeatureLog.i((String)"FTCalculator", (String)"open roomId not right, currentRoomId:%s, roomId:%s", (Object[])new Object[]{CalculatorPresenter.this.mRoomId, roomId});
                    return;
                }
                boolean isShowed = SettingFlags.getBoolean((String)"key_calculator_instruction_showed", (boolean)false);
                if (!isShowed) {
                    FeatureLog.i((String)"FTCalculator", (String)"first open", (Object[])new Object[0]);
                    InstructionDialog dialog = new InstructionDialog((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext());
                    dialog.show();
                    SettingFlags.setBoolean((String)"key_calculator_instruction_showed", (boolean)true);
                    SettingFlags.setBoolean((String)"key_calculator_instruction_showed_new", (boolean)true);
                    RoomTrack.INSTANCE.calculatorInstructionShow(CalculatorPresenter.this.getChannel().getChannelId());
                } else if (!SettingFlags.containKey((String)"key_calculator_instruction_showed_new") && !(isShowLevelUp = SettingFlags.getBoolean((String)"key_calculator_instruction_level_up", (boolean)false))) {
                    SettingFlags.setBoolean((String)"key_calculator_instruction_level_up", (boolean)true);
                    LevelUpDialog dialog = new LevelUpDialog((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext());
                    dialog.show();
                }
                if (CalculatorPresenter.this.getPublicScreenPresenter() != null && CalculatorPresenter.this.getMsgItemFactory() != null) {
                    PureTextMsg pureTextMsg = CalculatorPresenter.this.getMsgItemFactory().generateLocalPureTextMsg(CalculatorPresenter.this.getChannel().getChannelId(), (CharSequence)ResourceUtils.getString((int)R.string.tips_calculator_start_msg), CalculatorPresenter.this.getChannel().getRoleService().getMyRoleCache());
                    pureTextMsg.setMsgState(1);
                    CalculatorPresenter.this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
                    if (!isShowed) {
                        SysTextMsg systemMsg = CalculatorPresenter.this.getMsgItemFactory().generateSysTextMsg(CalculatorPresenter.this.getChannel().getChannelId(), ResourceUtils.getString((int)R.string.tips_calculator_play_msg));
                        CalculatorPresenter.this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)systemMsg);
                    }
                }
                CalculatorPresenter.this.getChannel().getCalculatorService().clearCharmValue();
                CalculatorPresenter.this.getChannel().getCalculatorService().setCalculatorOpen(true);
                CalculatorPresenter.this.updateSeatValues();
            }

            public void onFail(long code, String reason) {
                if (((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getDialogLinkManager() != null) {
                    ((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getDialogLinkManager().dismissDialog();
                }
                if (code == (long)RetCode.kCalculatorCodeNotPrivilege.getValue()) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.short_tips_only_master_can_open);
                } else if (code == (long)RetCode.kCalculatorCodeInGame.getValue()) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.short_tips_cur_mode_can_not_open);
                } else if (code == (long)RetCode.kCalculatorCodeNobody.getValue()) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.short_tips_cannot_open_with_no_user);
                } else if (code == (long)RetCode.kCalculatorCodeOpening.getValue()) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.short_tips_calcu_had_open);
                } else {
                    ToastUtils.showToast((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext(), (int)R.string.tips_unknown_error);
                }
            }
        });
    }

    private void updateSeatValues() {
        this.getSceneOptLimiter().addItem((Object)true);
    }

    private void showCalculatorBottom() {
        FeatureLog.i((String)"FTCalculator", (String)"showCalculatorBottom", (Object[])new Object[0]);
        RoomTrack.INSTANCE.calculatorPopShow(this.mRoomId);
        ((IChannelPageContext)this.getMvpContext()).getDialogLinkManager().showCommonPopupDialog(this.showBottomDialog(new ICalculatorBottomOperation(){

            @Override
            public void onReset() {
                RoomTrack.INSTANCE.calculatorPopResetClick(CalculatorPresenter.this.mRoomId);
                if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext())) {
                    ToastUtils.showToast((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                    FeatureLog.i((String)"FTCalculator", (String)"onReset not network", (Object[])new Object[0]);
                    return;
                }
                CalculatorPresenter.this.reset(CalculatorPresenter.this.mRoomId, new ICalculatorRequestCallback(){

                    public void onSuccess(String roomId) {
                        if (!TextUtils.isEmpty((CharSequence)CalculatorPresenter.this.mRoomId) && !CalculatorPresenter.this.mRoomId.equals(roomId) || CalculatorPresenter.this.isDestroyed()) {
                            FeatureLog.i((String)"FTCalculator", (String)"reset roomId not right, currentRoomId:%s, roomId:%s", (Object[])new Object[]{CalculatorPresenter.this.mRoomId, roomId});
                            return;
                        }
                        CalculatorPresenter.this.getChannel().getCalculatorService().clearCharmValue();
                        CalculatorPresenter.this.updateSeatValues();
                    }

                    public void onFail(long code, String reason) {
                        ToastUtils.showToast((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                    }
                });
            }

            @Override
            public void onClose() {
                RoomTrack.INSTANCE.calculatorPopCloseClick(CalculatorPresenter.this.mRoomId);
                if (!NetworkUtils.isNetworkAvailable((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext())) {
                    ToastUtils.showToast((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                    FeatureLog.i((String)"FTCalculator", (String)"onClose not network", (Object[])new Object[0]);
                    return;
                }
                CalculatorPresenter.this.close(CalculatorPresenter.this.mRoomId, new ICalculatorRequestCallback(){

                    public void onSuccess(String roomId) {
                        if (!TextUtils.isEmpty((CharSequence)CalculatorPresenter.this.mRoomId) && !CalculatorPresenter.this.mRoomId.equals(roomId) || CalculatorPresenter.this.isDestroyed()) {
                            FeatureLog.i((String)"FTCalculator", (String)"close roomId not right, currentRoomId:%s, roomId:%s", (Object[])new Object[]{CalculatorPresenter.this.mRoomId, roomId});
                            return;
                        }
                        if (CalculatorPresenter.this.getPublicScreenPresenter() != null && CalculatorPresenter.this.getMsgItemFactory() != null) {
                            PureTextMsg pureTextMsg = CalculatorPresenter.this.getMsgItemFactory().generateLocalPureTextMsg(CalculatorPresenter.this.getChannel().getChannelId(), (CharSequence)ResourceUtils.getString((int)R.string.tips_calculator_close_msg), CalculatorPresenter.this.getChannel().getRoleService().getMyRoleCache());
                            pureTextMsg.setMsgState(1);
                            CalculatorPresenter.this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
                        }
                        CalculatorPresenter.this.getChannel().getCalculatorService().clearCharmValue();
                        CalculatorPresenter.this.getChannel().getCalculatorService().setCalculatorOpen(false);
                        CalculatorPresenter.this.getChannel().getCalculatorService().setHatOpen(false);
                        CalculatorPresenter.this.updateSeatValues();
                    }

                    public void onFail(long code, String reason) {
                        ToastUtils.showToast((Context)((IChannelPageContext)CalculatorPresenter.this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                    }
                });
            }
        }), true, true);
    }

    public void setStatus(String roomId, boolean isOpen) {
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"updatePanelView current roomId null", (Object[])new Object[0]);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"updatePanelView target roomId null", (Object[])new Object[0]);
            return;
        }
        if (!this.mRoomId.equals(roomId)) {
            FeatureLog.i((String)"FTCalculator", (String)"updatePanelView target roomId:%s not equals current roomId:%s", (Object[])new Object[]{roomId, this.mRoomId});
            return;
        }
        this.mIsOpen = isOpen;
    }

    public List<ButtonItem> showBottomDialog(final ICalculatorBottomOperation operation) {
        ArrayList<ButtonItem> buttonItemList = new ArrayList<ButtonItem>();
        ButtonItem resetItem = new ButtonItem(ResourceUtils.getString((int)R.string.tips_calculator_reset), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (operation != null) {
                    operation.onReset();
                }
            }
        });
        buttonItemList.add(resetItem);
        ButtonItem closeItem = new ButtonItem(ResourceUtils.getString((int)R.string.tips_calculator_close), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (operation != null) {
                    operation.onClose();
                }
            }
        });
        buttonItemList.add(closeItem);
        return buttonItemList;
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            this.mRoomId = this.getChannel().getChannelId();
            FeatureLog.i((String)"FTCalculator", (String)"onPageAttach:%s", (Object[])new Object[]{this.mRoomId});
            this.getCalculatorStatus(this.getChannel().getChannelId());
            FeatureLog.i((String)"FTCalculator", (String)"onPageAttach addHandler", (Object[])new Object[0]);
            this.mRoomCalculatorNotifyDispatchService = new RoomCalculatorNotifyDispatchService();
            this.mRoomCalculatorNotifyDispatchService.addHandler(this.mNotifyHandler);
            this.mRoomCalculatorNotifyDispatchService.setRoomId(this.mRoomId);
            ProtoManager.getInstance().registerNotify((IProtoNotify)this.mRoomCalculatorNotifyDispatchService);
            CalculatorStyleManager.INSTANCE.getConfig();
        }
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        if (this.mSVGAImageView != null && this.getPage().getPageView() instanceof ViewGroup) {
            ((ViewGroup)this.getPage().getPageView()).removeView((View)this.mSVGAImageView);
        }
    }

    public void getCalculatorStatus(String roomId) {
        this.getRoomStatus((Context)((IChannelPageContext)this.getMvpContext()).getContext(), roomId, new ICalculatorStatusRequestCallback(){

            @Override
            public void onSuccess(final String roomId, final GetRoomCalculatorRes message, final List<CalculatorData> charmValueList, final List<CharmValue> valueList) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!TextUtils.isEmpty((CharSequence)CalculatorPresenter.this.mRoomId) && !CalculatorPresenter.this.mRoomId.equals(roomId)) {
                            FeatureLog.i((String)"FTCalculator", (String)"getCalculatorStatus roomId not right, currentRoomId:%s, requestRoomId:%s", (Object[])new Object[]{CalculatorPresenter.this.mRoomId, roomId});
                            return;
                        }
                        if (CalculatorPresenter.this.isDestroyed()) {
                            FeatureLog.i((String)"FTCalculator", (String)"getCalculatorStatus destroyed", (Object[])new Object[0]);
                            return;
                        }
                        if (message.is_open.booleanValue()) {
                            PickMeHatPresenter pickMeHatPresenter;
                            CalculatorPresenter.this.getChannel().getCalculatorService().clearCharmValue();
                            CalculatorPresenter.this.getChannel().getCalculatorService().addCharmValueList((ArrayList)charmValueList);
                            CalculatorPresenter.this.getChannel().getCalculatorService().setCalculatorOpen(true);
                            if (message.is_show_hat.booleanValue() && (pickMeHatPresenter = (PickMeHatPresenter)CalculatorPresenter.this.getPresenter(PickMeHatPresenter.class)) != null) {
                                pickMeHatPresenter.updateCapValue(valueList, (ArrayList)charmValueList, message.pickme_round_new);
                            }
                            CalculatorPresenter.this.updateSeatValues();
                        }
                    }
                }, (long)500L);
            }

            @Override
            public void onFail(long code, String reason) {
                if (CalculatorPresenter.this.isDestroyed()) {
                    FeatureLog.i((String)"FTCalculator", (String)"getCalculatorStatus destroyed", (Object[])new Object[0]);
                    return;
                }
                CalculatorPresenter.this.getChannel().getCalculatorService().clearCharmValue();
                CalculatorPresenter.this.getChannel().getCalculatorService().setCalculatorOpen(false);
                CalculatorPresenter.this.getChannel().getCalculatorService().setHatOpen(false);
                CalculatorPresenter.this.updateSeatValues();
            }
        });
    }

    private void handleCharmValueCalculator(CalculatorNotify notify2) {
        PickMeHatPresenter pickMeHatPresenter;
        if (notify2 == null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive charmValueRaise notify null", (Object[])new Object[0]);
            return;
        }
        if (notify2.charm_raise.__isDefaultInstance()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive charmValueRaise null", (Object[])new Object[0]);
            return;
        }
        if (notify2.header != null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive charmValueRaise:%s, roomId:%s, isOpen:%s", (Object[])new Object[]{notify2.charm_raise.charm_values, notify2.header.roomid, notify2.charm_raise.is_open});
        }
        if (notify2.charm_raise.egg_id != 0 && !notify2.charm_raise.is_show_hat.booleanValue()) {
            this.initSvga(notify2.charm_raise.egg_id);
        }
        if (notify2.charm_raise.room_old_level < notify2.charm_raise.room_new_level && !notify2.charm_raise.is_show_hat.booleanValue() && this.getPublicScreenPresenter() != null && this.getMsgItemFactory() != null) {
            SysTextMsg systemMsg = this.getMsgItemFactory().generateSysTextMsg(this.getChannel().getChannelId(), ResourceUtils.getString((int)R.string.tips_calculator_level_up, (Object[])new Object[]{notify2.charm_raise.room_old_level, notify2.charm_raise.room_new_level}));
            this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)systemMsg);
        }
        List charmValueList = notify2.charm_raise.charm_values;
        ArrayList<CalculatorData> roomCharmValueList = new ArrayList<CalculatorData>();
        if (charmValueList != null) {
            for (CharmValue value : charmValueList) {
                if (value == null) continue;
                roomCharmValueList.add(new CalculatorData(value.uid.longValue(), value.charm_value.longValue(), value.raise_value.longValue(), value.seat.longValue(), value.effect_id.intValue(), value.show_upgrade.booleanValue(), value.upgrade_time.longValue()));
            }
        }
        if (notify2.header != null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive charmValueRaise, roomId:%s", (Object[])new Object[]{notify2.header.roomid});
            this.setStatus(notify2.header.roomid, notify2.charm_raise.is_open);
        }
        this.getChannel().getCalculatorService().clearCharmValue();
        if (notify2.charm_raise.is_open.booleanValue()) {
            this.getChannel().getCalculatorService().addCharmValueList(roomCharmValueList);
        }
        if (notify2.charm_raise.is_show_hat.booleanValue() && (pickMeHatPresenter = (PickMeHatPresenter)this.getPresenter(PickMeHatPresenter.class)) != null) {
            pickMeHatPresenter.updateCapValue(charmValueList, roomCharmValueList, notify2.charm_raise.pickme_round_new);
        }
        this.getChannel().getCalculatorService().setCalculatorOpen(notify2.charm_raise.is_open.booleanValue());
        this.getChannel().getCalculatorService().setHatOpen(notify2.charm_raise.is_show_hat.booleanValue());
        this.updateSeatValues();
    }

    private IPublicScreenPresenter getPublicScreenPresenter() {
        IPublicScreenPresenter publicScreenPresenter = null;
        if (this.getPresenter(IPublicScreenModulePresenter.class) != null) {
            publicScreenPresenter = ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
        }
        return publicScreenPresenter;
    }

    private IMsgItemFactory getMsgItemFactory() {
        IMsgItemFactory iMsgItemFactory = null;
        if (this.getPresenter(IPublicScreenModulePresenter.class) != null) {
            iMsgItemFactory = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory();
        }
        return iMsgItemFactory;
    }

    private void initSvga(int eggId) {
        if (!TextUtils.isEmpty((CharSequence)CalculatorStyleManager.INSTANCE.getEggUrl(eggId))) {
            if (this.mSVGAImageView == null) {
                this.mSVGAImageView = new SVGAImageView((Context)((IChannelPageContext)this.getMvpContext()).getContext());
                this.mSVGAImageView.setLoops(1);
                this.mSVGAImageView.setCallback(new SVGACallback(){
                    SVGAImageView svgaImageView;
                    {
                        this.svgaImageView = CalculatorPresenter.this.mSVGAImageView;
                    }

                    public void onPause() {
                        new Handler().post(new Runnable(){

                            @Override
                            public void run() {
                                if (svgaImageView != null && CalculatorPresenter.this.getPage() != null && CalculatorPresenter.this.getPage().getPageView() instanceof ViewGroup) {
                                    ((ViewGroup)CalculatorPresenter.this.getPage().getPageView()).removeView((View)svgaImageView);
                                }
                            }
                        });
                    }

                    public void onFinished() {
                        new Handler().post(new Runnable(){

                            @Override
                            public void run() {
                                if (svgaImageView != null && CalculatorPresenter.this.getPage() != null && CalculatorPresenter.this.getPage().getPageView() instanceof ViewGroup) {
                                    ((ViewGroup)CalculatorPresenter.this.getPage().getPageView()).removeView((View)svgaImageView);
                                }
                            }
                        });
                    }

                    public void onRepeat() {
                    }

                    public void onStep(int i, double v) {
                    }
                });
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                this.mSVGAImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    if (CalculatorPresenter.this.mSVGAImageView != null && CalculatorPresenter.this.getPage() != null && CalculatorPresenter.this.getPage().getPageView() instanceof ViewGroup) {
                        ((ViewGroup)CalculatorPresenter.this.getPage().getPageView()).removeView((View)CalculatorPresenter.this.mSVGAImageView);
                    }
                }
            });
            ((ViewGroup)this.getPage().getPageView()).addView((View)this.mSVGAImageView);
            SvgaLoader.load((SVGAImageView)this.mSVGAImageView, (String)CalculatorStyleManager.INSTANCE.getEggUrl(eggId), (boolean)true, (int)0, (int)0, null, null, null);
        }
    }

    private void handleCloseCalculator(CalculatorNotify notify2) {
        if (notify2 == null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive closeCalculator notify null", (Object[])new Object[0]);
            return;
        }
        if (notify2.close.__isDefaultInstance()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive closeCalculator null", (Object[])new Object[0]);
            return;
        }
        if (this.isDestroyed()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive closeCalculator isDestroyed", (Object[])new Object[0]);
            return;
        }
        if (notify2.header != null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive closeCalculator, roomId:%s", (Object[])new Object[]{notify2.header.roomid});
            this.setStatus(notify2.header.roomid, false);
        }
        if (this.getPublicScreenPresenter() != null && this.getMsgItemFactory() != null && !this.isPlayManager(AccountUtil.getUid())) {
            PureTextMsg pureTextMsg = this.getMsgItemFactory().generateLocalPureTextMsg(this.getChannel().getChannelId(), (CharSequence)ResourceUtils.getString((int)R.string.tips_calculator_close_msg), this.getChannel().getRoleService().getRoleCache(notify2.close.uid.longValue()), notify2.close.uid.longValue());
            pureTextMsg.setMsgState(1);
            this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
        }
        this.getChannel().getCalculatorService().clearCharmValue();
        this.getChannel().getCalculatorService().setCalculatorOpen(false);
        this.getChannel().getCalculatorService().setHatOpen(false);
        PickMeHatPresenter pickMeHatPresenter = (PickMeHatPresenter)this.getPresenter(PickMeHatPresenter.class);
        if (pickMeHatPresenter != null) {
            pickMeHatPresenter.remove();
        }
        this.updateSeatValues();
        ((RoomGiftPresenter)this.getPresenter(RoomGiftPresenter.class)).stopPlay("jishuqi");
    }

    private void handleForceCloseCalculator(CalculatorNotify notify2) {
        PickMeHatPresenter pickMeHatPresenter;
        if (notify2 == null || this.isDestroyed()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive forceCloseCalculator notify null", (Object[])new Object[0]);
            return;
        }
        if (notify2.force_close.__isDefaultInstance()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive forceCloseCalculator null", (Object[])new Object[0]);
            return;
        }
        if (notify2.header != null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive forceCloseCalculator, roomId:%s", (Object[])new Object[]{notify2.header.roomid});
            this.setStatus(notify2.header.roomid, false);
        }
        if (this.getMsgItemFactory() != null && this.getPublicScreenPresenter() != null) {
            String tips = "";
            tips = notify2.force_close.getForce_typeValue() == 0 ? ResourceUtils.getString((int)R.string.tips_calculator_seat_close_msg) : (notify2.force_close.getForce_typeValue() == 1 ? ResourceUtils.getString((int)R.string.tips_calculator_game_close_msg) : ResourceUtils.getString((int)R.string.tips_calculator_close_tips));
            SysTextMsg pureTextMsg = this.getMsgItemFactory().generateSysTextMsg(this.getChannel().getChannelId(), tips);
            this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
        }
        if ((pickMeHatPresenter = (PickMeHatPresenter)this.getPresenter(PickMeHatPresenter.class)) != null) {
            pickMeHatPresenter.remove();
        }
        this.getChannel().getCalculatorService().clearCharmValue();
        this.getChannel().getCalculatorService().setCalculatorOpen(false);
        this.getChannel().getCalculatorService().setHatOpen(false);
        this.updateSeatValues();
    }

    private void handleOpenCalculator(CalculatorNotify notify2) {
        if (notify2 == null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive openCalculator notify null", (Object[])new Object[0]);
            return;
        }
        if (notify2.open.__isDefaultInstance()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive openCalculator null", (Object[])new Object[0]);
            return;
        }
        if (this.isDestroyed()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive openCalculator isDestroyed", (Object[])new Object[0]);
            return;
        }
        if (notify2.header != null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive openCalculator,roomId:%s", (Object[])new Object[]{notify2.header.roomid});
            this.setStatus(notify2.header.roomid, true);
        }
        if (this.getPublicScreenPresenter() != null && this.getMsgItemFactory() != null && !this.isPlayManager(AccountUtil.getUid())) {
            PureTextMsg pureTextMsg = this.getMsgItemFactory().generateLocalPureTextMsg(this.getChannel().getChannelId(), (CharSequence)ResourceUtils.getString((int)R.string.tips_calculator_start_msg), this.getChannel().getRoleService().getRoleCache(notify2.open.uid.longValue()), notify2.open.uid.longValue());
            pureTextMsg.setMsgState(1);
            this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
        }
        this.getChannel().getCalculatorService().clearCharmValue();
        this.getChannel().getCalculatorService().setCalculatorOpen(true);
        this.updateSeatValues();
        ((RoomGiftPresenter)this.getPresenter(RoomGiftPresenter.class)).startPlay("jishuqi");
    }

    private void handleResetCalculator(CalculatorNotify notify2) {
        if (notify2 == null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive resetCalculator notify null", (Object[])new Object[0]);
            return;
        }
        if (notify2.reset.__isDefaultInstance()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive resetCalculator null", (Object[])new Object[0]);
            return;
        }
        if (this.isDestroyed()) {
            FeatureLog.i((String)"FTCalculator", (String)"receive resetCalculator isDestroyed", (Object[])new Object[0]);
            return;
        }
        if (notify2.header != null) {
            FeatureLog.i((String)"FTCalculator", (String)"receive resetCalculator,roomId:%s", (Object[])new Object[]{notify2.header.roomid});
        }
        this.getChannel().getCalculatorService().clearCharmValue();
        this.updateSeatValues();
        PickMeHatPresenter pickMeHatPresenter = (PickMeHatPresenter)this.getPresenter(PickMeHatPresenter.class);
        if (pickMeHatPresenter != null) {
            pickMeHatPresenter.remove();
        }
        if (this.getMsgItemFactory() != null && this.getPublicScreenPresenter() != null) {
            if (this.getChannel().getCalculatorService().isHatOpen()) {
                UserInfoKS myUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(notify2.reset.uid.longValue(), null);
                String nick = myUserInfo.nick;
                long uid = notify2.reset.uid;
                int role = this.getChannel().getRoleService().getRoleCache(notify2.reset.uid.longValue());
                String content = ResourceUtils.getString((int)R.string.short_tips_reseat, (Object[])new Object[]{nick});
                PureTextMsg pureTextMsg = this.getMsgItemFactory().generateLocalPickMeMsg(this.getChannel().getChannelId(), (CharSequence)content, role, uid);
                pureTextMsg.setMsgState(1);
                this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
            } else {
                PureTextMsg pureTextMsg = this.getMsgItemFactory().generateLocalPureTextMsg(this.getChannel().getChannelId(), (CharSequence)ResourceUtils.getString((int)R.string.tips_calculator_reset_msg), this.getChannel().getRoleService().getRoleCache(notify2.reset.uid.longValue()), notify2.reset.uid.longValue());
                pureTextMsg.setMsgState(1);
                this.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mRoomCalculatorNotifyDispatchService != null) {
            FeatureLog.i((String)"FTCalculator", (String)"onDestroy unregister handler", (Object[])new Object[0]);
            this.mRoomCalculatorNotifyDispatchService.clear();
            ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mRoomCalculatorNotifyDispatchService);
        }
        this.getSceneOptLimiter().destroy();
        ((RoomGiftPresenter)this.getPresenter(RoomGiftPresenter.class)).stopPlay("jishuqi");
    }

    private boolean isPlayManager(long uid) {
        return this.isOwnerOrMaster(uid) || this.getChannel().getRoleService().isMeAnchor() || this.getChannel().getSeatService().isInFirstSeat(uid);
    }

    private boolean isOwnerOrMaster(long uid) {
        return this.getChannel().getRoleService().getRoleCache(uid) == 15 || this.getChannel().getRoleService().getRoleCache(uid) == 10;
    }

    public static interface ICalculatorStatusRequestCallback {
        public void onSuccess(String var1, GetRoomCalculatorRes var2, List<CalculatorData> var3, List<CharmValue> var4);

        public void onFail(long var1, String var3);
    }

    public static interface ICalculatorBottomOperation {
        public void onReset();

        public void onClose();
    }
}

