/*
 * Decompiled with CFR 0.152.
 */
package com.yy.report.ui.dialog;

import android.app.Dialog;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.Window;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.report.R;
import com.yy.report.uicallback.IReportViewCallBack;
import java.util.ArrayList;
import java.util.List;

public class ReportNewDialog
implements BaseDialog {
    public static final String TAG = "ReportNewDialog";
    private IReportViewCallBack mCallBack;
    private YYTextView mChatMessages;
    private YYTextView mAvatarAndAlbum;
    private YYTextView mNicknameAndSign;
    private YYTextView mGamesText;
    private YYTextView mSubmit;
    private YYTextView mCancelBtn;
    private Drawable mRadioNor;
    private Drawable mRadioPre;
    private int selectGender = 0;
    private List<YYTextView> radioList = new ArrayList<YYTextView>(3);
    private int index = 0;

    public ReportNewDialog(IReportViewCallBack callBacks) {
        this.mCallBack = callBacks;
    }

    public void init(Dialog dialog) {
        Window window = dialog.getWindow();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        if (window == null) {
            return;
        }
        this.mRadioNor = ResourceUtils.getDrawable((int)R.drawable.report_radio_nor);
        this.mRadioNor.setBounds(0, 0, this.mRadioNor.getMinimumWidth(), this.mRadioNor.getMinimumHeight());
        this.mRadioPre = ResourceUtils.getDrawable((int)R.drawable.report_radio_pre);
        this.mRadioPre.setBounds(0, 0, this.mRadioPre.getMinimumWidth(), this.mRadioPre.getMinimumHeight());
        window.setContentView(R.layout.window_new_report_dialog);
        this.mChatMessages = (YYTextView)window.findViewById(R.id.report_chat_messages);
        this.mAvatarAndAlbum = (YYTextView)window.findViewById(R.id.report_avatar_and_album);
        this.mNicknameAndSign = (YYTextView)window.findViewById(R.id.report_nickname_and_sign);
        this.mGamesText = (YYTextView)window.findViewById(R.id.report_games);
        this.mCancelBtn = (YYTextView)window.findViewById(R.id.report_new_cancel);
        this.mSubmit = (YYTextView)window.findViewById(R.id.report_new_submit);
        this.mSubmit.setOnClickListener(v -> {
            this.mCallBack.onNewSubmitClick(this.getReportType());
            dialog.dismiss();
            MLog.info((Object)TAG, (String)"mSubmit clicked", (Object[])new Object[0]);
        });
        this.mCancelBtn.setOnClickListener(v -> dialog.dismiss());
        this.mChatMessages.setOnClickListener(v -> this.selectIndex(0));
        this.mAvatarAndAlbum.setOnClickListener(v -> this.selectIndex(1));
        this.mNicknameAndSign.setOnClickListener(v -> this.selectIndex(2));
        this.mGamesText.setOnClickListener(v -> this.selectIndex(3));
        this.radioList.add(this.mChatMessages);
        this.radioList.add(this.mAvatarAndAlbum);
        this.radioList.add(this.mNicknameAndSign);
        this.radioList.add(this.mGamesText);
        this.selectIndex(this.selectGender);
    }

    private void selectIndex(int index) {
        if (index < 0 || index > 3) {
            return;
        }
        for (YYTextView tv : this.radioList) {
            tv.setCompoundDrawables(this.mRadioNor, null, null, null);
            this.checkRTLDrawable(tv, R.drawable.report_radio_nor);
        }
        this.radioList.get(index).setCompoundDrawables(this.mRadioPre, null, null, null);
        this.checkRTLDrawable(this.radioList.get(index), R.drawable.report_radio_pre);
        this.index = index;
        MLog.info((Object)TAG, (String)"select report type Index =%d", (Object[])new Object[]{index});
    }

    private void checkRTLDrawable(YYTextView tv, int mRadioDrawable) {
        if (Build.VERSION.SDK_INT >= 17) {
            tv.setCompoundDrawablesRelativeWithIntrinsicBounds(mRadioDrawable, 0, 0, 0);
        } else {
            tv.setCompoundDrawablesWithIntrinsicBounds(mRadioDrawable, 0, 0, 0);
        }
    }

    private int getReportType() {
        if (this.index == 0) {
            return 5;
        }
        if (this.index == 1) {
            return 60001;
        }
        if (this.index == 2) {
            return 60002;
        }
        if (this.index == 3) {
            return 3;
        }
        return this.index;
    }

    public int getId() {
        return 0;
    }
}

